/***********************************************************/
/* File Id.                  PushPop.C                     */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/06/88.                     */
/* Date Last Modified.                                     */
/*                                                         */
/*         (c) Copyright 1989, 1990 by Stan Milam          */
/*                                                         */
/* Comments:  This file contains functions to save & re-   */
/* store the contents of a screen text block.  These func- */
/* tions return pointers to window structures containing   */
/* the text buffers and other info.                        */
/***********************************************************/

#if __TURBOC__ || __ZTC__
#   define _fmalloc farmalloc
#   define _ffree   farfree
#   if __TURBOC__
#      include <alloc.h>
#   endif
#else
#   include <malloc.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"

WNDPTR *wpush(int urow, int ucol, int lrow, int lcol) {

   int far  *scrnptr;
   int      rows, cols, page, pagesize;
   int      mx_rows, mx_cols;
   unsigned offset, scrnseg;
   WNDPTR   *wnd;

   if (!chk_video_state(&mx_rows,&mx_cols))
      return(NULL);

   wnd = (WNDPTR *) malloc(sizeof(WNDPTR));
   if (wnd == NULL) return(wnd);            /* Exit if error */

   memset(wnd, '\0', sizeof(WNDPTR));

   if (lcol > mx_cols) {                    /* Check to see if window */
      mx_cols = lcol - mx_cols;             /* will fit on screen. Fix if */
      lcol -= mx_cols;                      /* we have to */
      ucol -= mx_cols;
   }

   if (lrow > mx_rows) {                     /* Check for greater than 25 */
      mx_rows = lrow - mx_rows;              /* rows and fix if needed */
      lrow -= mx_rows;
      urow -= mx_rows;
   }

   rows = (lrow - urow) + 1;
   cols = (lcol - ucol) + 1;

   wnd->wbuffer = (char far *) _fmalloc((rows * cols) * 2);
   if (wnd->wbuffer == (char far *) NULL) { /* If error then */
      free(wnd);                            /* Free memory */
      return(NULL);                         /* Exit if no memory allocated */
   }
   wnd->wsave = (char far *) NULL;          /* Make NULL to be sure */

   page      = getpage();
   scrnseg   = getscrnseg();
   pagesize  = getpagesize();

   wnd->urow = urow;                        /* Save rows & cols in struct */
   wnd->ucol = ucol;
   wnd->lrow = lrow;
   wnd->lcol = lcol;
   wnd->page = page;
   wnd->attr = (char) ((BLACK << 4) + LIGHTGRAY);
   wnd->hideflag = 0;

   offset = MK_SCRNOFF(urow, ucol);               /* Create pointer to */
   scrnptr = (int far *) MK_FP(scrnseg, offset);  /* Screen */

   SaveScrn(rows,cols,scrnptr,wnd->wbuffer);
   re_order(wnd, PUSH);
   return(wnd);
}

/***********************************************************/
/*                            Wpop                         */
/*                                                         */
/* Will restore the underlying screen image and free memory*/
/* to the heap again.  Removes window from the internal    */
/* list of windows.                                        */
/***********************************************************/

WNDPTR *wpop(WNDPTR *wnd)  {

   int mx_rows, mx_cols;

   if (!chk_video_state(&mx_rows,&mx_cols)) return(0);
   if (wnd == NULL) return(NULL);
   if (wnd->wbuffer == (char far *) NULL)   /* If null pointer */
      return(wnd);                          /* quit with bad return */
   re_order(wnd, POP);                      /* Remove from internal list */
   _ffree(wnd->wbuffer);
   wnd->wbuffer = (char far *) NULL;
   if (wnd->wsave != (char far *) NULL) {   /* Memory buffer */
      _ffree(wnd->wsave);
      wnd->wsave = (char far *) NULL;
   }
   free(wnd);                               /* Free allocated window */
   wnd = (WNDPTR *) NULL;                   /* Make it NULL */
   return(wnd);                             /* Return the NULL Pointer */
}
