/* code to disable <Ctrl><Alt><Del>.                                */
/* Compiled and tested under TC++ and MSC 6                         */

#include <dos.h>
#include "pchwio.h"

#define CTRLALT        (0x08|0x04) /* bit flags set in kbstat()     */
#define DELSCAN        0x53        /* keyboard scan code for <Del>  */
#define KEYPORT        0x60        /* keyboard scan code port       */
#define CONTROLLERPORT 0x20        /* interrupt controller port     */
#define kbstat()       peek(0,0x417)  /* BIOS data area - kb flags  */

#define keyport()      inp(KEYPORT)
        /* macro that returns the scancode of the key that caused   */
        /* the interrupt                                            */

#define install()      (oldkbisr=getvect(0x09),setvect(0x09,newkbisr))
        /* installation macro, installs newkbisr() in the keyboard  */
        /* interrupt chain                                          */

#define uninstall()       setvect(0x09,oldkbisr)
        /* removal macro, call to remove newkbisr() from interrupt  */
        /* chain.  oldkbisr()  must be removed before program ends  */

void (INTERRUPT FAR * oldkbisr)(void);
        /* address of old keyboard ISR                              */

void INTERRUPT FAR newkbisr(void)
{
   if((keyport()==DELSCAN)&&((kbstat()&CTRLALT)==CTRLALT))
   {
       char kbin = (char)inp(KEYPORT+1);      /* reset keyboard */

       outp(KEYPORT+1, kbin|0x80);
       outp(KEYPORT+1, kbin);
       disable();
       outp(CONTROLLERPORT,0x20); /* tell controller to shut up */
       enable();
   }
   else
       oldkbisr();  /* chain to old keyboard isr */
}

#ifdef TEST

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <signal.h>
#include <errno.h>

main()
{
      int ch = 0;
      void cleanup(void), cbrk(int);

      install();
      atexit(cleanup);

      signal(SIGINT, cbrk);

      puts("This is a test of Ctrl-Alt-Del disabling.");
      puts("Press any key, but only Esc should stop this program.");

      while (0x1b != ch)
      {
            if (kbhit())
                  ch = getch();
      }
      return EXIT_SUCCESS;
}

void cleanup(void)
{
      uninstall();
}

#ifdef __WATCOMC__
 #pragma off (unreferenced);
#endif
#ifdef __TURBOC__
 #pragma argsused
#endif

void cbrk(int sig)
{
      signal(SIGINT, SIG_IGN);
      signal(SIGINT, cbrk);
}

#endif /* TEST */
