/****************************************************************************/
/*																																					*/
/* MENU.C   																																*/
/*																																					*/
/* This program is a simple demonstration of the usage of a main menu to		*/
/* drive an application.                                                    */
/*                                                                          */
/* Also included in this demo is a demonstration on how to toggle between		*/
/* 25 and 43/50 text modes, while keeping the same windows on the screen.		*/
/* Just pick the appropriate menu selection to see it!                    	*/
/*                                                         Boyd Gafford			*/
/*                                                         EnQue Software		*/
/*                                                         02/01/92         */
/*																																					*/
/****************************************************************************/
#include <ctype.h>
#include "uw.h"
#include "uw_globx.h"
#include "uw_keys.h"


/*----------------------- global window variables --------------------------*/
MENU		Files_menu, Utility_menu, Config_menu,		/* the menus themselves		*/
				Terminal_menu, Network_menu;
MENU		*Drop_mnps[5];														/* pointers to the above	*/
MENU		Top_menu, *Top_mnp = &Top_menu;						/* main top menu!					*/
WINDOW	Back_wn, *Back_wnp = &Back_wn;						/* the desktop window			*/


/*********/
/* ~main */
/*       ********************************************************************/
/****************************************************************************/
main()
{
	int		back_att  = (LIGHTGRAY << 4) | BLACK,
				bdr_att   = (LIGHTGRAY << 4) | BLACK,
				csr_att   = (CYAN << 4) | YELLOW,
				first_att = (LIGHTGRAY << 4) | RED;
	int		i, id, save_att, end_flag = OFF;

	init_video(80, 25);

  init_mouse();

	Drop_mnps[0] = &Files_menu;
	Drop_mnps[1] = &Utility_menu;
	Drop_mnps[2] = &Config_menu;
	Drop_mnps[3] = &Network_menu;
	Drop_mnps[4] = &Terminal_menu;

	menu_create(0, 0, V_cols, 0, M_HORIZONTAL, back_att, bdr_att, csr_att,
							first_att, NO_BDR, WN_NORMAL, Top_mnp);

  item_add(" Files         ", 1, 1, &Top_menu);
  item_add(" Utilities     ", 2, 1, &Top_menu);
  item_add(" Configure     ", 3, 1, &Top_menu);
	item_add(" Networking    ", 4, 6, &Top_menu);
	item_add(" Terminal      ", 5, 1, &Top_menu);

	menu_create(0, 1, 16, 8, M_VERTICAL, back_att, bdr_att, csr_att,
							first_att, SGL_BDR, WN_NORMAL, Drop_mnps[0]);

  item_add(" Directory     ", 6, 1, &Files_menu);
  item_add(" Change Path   ", 7, 1, &Files_menu);
  item_add(" OS-Shell      ", 8, 1, &Files_menu);
  item_add(" Spawn Program ", 9, 1, &Files_menu);
  item_add(" View a File   ", 10, 1, &Files_menu);
  item_add(" Exit          ", 11, 2, &Files_menu);

	menu_create(15, 1, 33, 7, M_VERTICAL, back_att, bdr_att, csr_att,
							first_att, SGL_BDR, WN_NORMAL, Drop_mnps[1]);

  item_add(" Turn Log On/Off ", 12, 6, &Utility_menu);
  item_add(" Rings to Answer ", 13, 1, &Utility_menu);
  item_add(" Modem Off       ", 14, 7, &Utility_menu);
  item_add(" Modem On        ", 15, 1, &Utility_menu);
  item_add(" Local Log-On    ", 16, 1, &Utility_menu);

	menu_create(30, 1, 48, 6, M_VERTICAL, back_att, bdr_att, csr_att,
							first_att, SGL_BDR, WN_NORMAL, Drop_mnps[2]);

  item_add(" General Options  ", 17, 1, &Config_menu);
  item_add(" Modem/Terminal   ", 18, 1, &Config_menu);
  item_add(" Directories      ", 19, 1, &Config_menu);
	item_add(" 25/43/50 rows    ", 20, 1, &Config_menu);

	menu_create(45, 1, 62, 9, M_VERTICAL, back_att, bdr_att, csr_att,
							first_att, SGL_BDR, WN_NORMAL, Drop_mnps[3]);

	item_add(" User Accounts  ", 21, 1, &Network_menu);
	item_add(" Backup System  ", 22, 1, &Network_menu);
	item_add(" Message System ", 23, 1, &Network_menu);
	item_add(" File System    ", 24, 1, &Network_menu);
	item_add(" Door System    ", 25, 1, &Network_menu);
	item_add(" Event Setup    ", 26, 1, &Network_menu);
	item_add(" Wait for Call  ", 27, 1, &Network_menu);

	menu_create(60, 1, 76, 8, M_VERTICAL, back_att, bdr_att, csr_att,
							first_att, SGL_BDR, WN_NORMAL, Drop_mnps[4]);

	item_add(" Terminal Mode ", 28, 1, &Terminal_menu);
	item_add(" Hang-Up       ", 29, 1, &Terminal_menu);
	item_add(" Phone List    ", 30, 1, &Terminal_menu);
	item_add(" Settings      ", 31, 1, &Terminal_menu);
	item_add(" Download      ", 32, 1, &Terminal_menu);
	item_add(" Upload        ", 33, 1, &Terminal_menu);

	V_rows = 50;
	/* first fool UltraWin into thinking we have 50 rows! */
	wn_create(0, 1, 80, 49, NO_BDR, WN_NORMAL, Back_wnp);
	/* create the window to the maximum possible size for VGA!	*/
	V_rows = 25;
	/* put the V_rows back to normal */

	wn_color(WHITE, BLUE, Back_wnp);
	wn_bdr_color(WHITE, BLUE, Back_wnp);
	add_window(Back_wnp);
	menu_set(Top_mnp);
	m_show();

	while (!end_flag)
	{
		id = menu_system(Top_mnp, Drop_mnps, 0);
		switch(id)
		{
			case 11:																		/* time to quit!					*/
				end_flag = ON;
				break;
			case 20:																		/* change video mode			*/
				m_hide();																	/* turn off mouse 				*/
				if( V_rows > 25 )													/* some slick code to do	*/
				{
					set_25_rows();
					wn_rfsh(Top_mnp->wnp);
					wn_clear(Back_wnp);
				} else mode43();
				V_rows = get_num_rows();
				csr_hide();																/* hide hardware csr			*/
				m_rowrange( 0, V_rows - 1);								/* set new mouse y range	*/
				m_show();																	/* turn on mouse!					*/
				break;
		}
	}

	m_hide();
  menu_restore(Top_mnp);
  menu_destroy(Top_mnp);
	for(i=0; i<5; i++)
		menu_destroy(Drop_mnps[i]);
	remove_window(Back_wnp);
	end_mouse();
  end_video();
}
/*** end of main ***/

/*** END OF FILE ***/
