; File......: REBOOT.ASM
; Author....: Ted Means
; Date......: $Date:   15 Aug 1991 23:08:04  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/reboot.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/reboot.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:08:04   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   12 Jun 1991 01:28:02   GLENN
;  Added choice of warm or cold reboot.  Documentation and code change.
;  
;     Rev 1.0   01 Apr 1991 01:03:50   GLENN
;  Nanforum Toolkit
;  



;  $DOC$
;  $FUNCNAME$
;      FT_REBOOT()
;  $CATEGORY$
;      DOS/BIOS
;  $ONELINER$
;      Force a warm or cold boot
;  $SYNTAX$
;      FT_REBOOT( <nBootType> ) -> NIL
;  $ARGUMENTS$
;      <nBootType> is used to indicate the type of reboot.  A value of zero
;      will cause a cold boot, while any other value will cause a warm boot.
;  $RETURNS$
;      NIL
;  $DESCRIPTION$
;      This function is valuable if you need to reboot the PC for some
;      reason; e.g. an installation routine that modifies CONFIG.SYS or
;      AUTOEXEC.BAT.
;
;      The source code is written to adhere to Turbo Assembler's IDEAL mode.
;      To use another assembler, you will need to rearrange the PROC and
;      SEGMENT directives, and also the ENDP and ENDS directives (a very
;      minor task).
;  $EXAMPLES$
;      #define COLD 0
;      #define WARM 1
;
;      // Issue a warm boot
;
;      FT_Reboot(WARM)
;
;  $END$
;


         IDEAL

Public   FT_REBOOT

Extrn    __ParNI:Far

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_REBOOT Far

         Mov       AX,1                      ; Specify first param
         Push      AX                        ; Put on stack
         Call      __ParNI                   ; Get param
         Xor       DX,DX                     ; Clear DX
         Mov       DS,DX                     ; Set DS to low memory
         Or        AX,AX                     ; Cold boot requested?         
         JZ        POST                      ; If so, don't set for warm
         Mov       AX,1234h                  ; Set up AX for warm boot

POST:    Mov       [Word Ptr 472h],AX        ; Indicate a warm boot
         DB        0EAh                      ; JMP to POST -- this method
         DD        0F000FFF0h                ; overcomes TASM bug
Endp     FT_REBOOT
Ends     _NanFor
End

