
// Copyright 1992, David Perelman-Hall & Jamshid Afshar

#include <assert.h>
#include <iostream.h>
#include <strstream.h>
#include <fstream.h>
#include "category.h"

bool parse( const Category& goal, const Category_Sequence& string ); //###

extern unsigned int _stklen = 40000U;

const char *default_file = "parse.in";

int main(int argc, char *argv[])
{
   Category_Sequence input;
   if (argc > 2) {
      cerr << argv[0] << ": Parses an input sentence passed on the command line." << endl;
      cerr << "parse \"sentence\"" << endl;
      exit(1);
   }
   else if (argc==2) {
      istrstream(argv[1]) >> input;
      }
   else { // argc==1
      ifstream(default_file) >> input;
      }


/*
//      Category("THEY") + Category("SEE");
      Category("THEY") + Category("SEE") + Category("HER") + Category("REPORT");
//      Category("THEY") + Category("REPORT") + Category("HER") + Category("SEE");
*/
   if (!parse( Category("S"), input))
      cout << "Unparsable.\n";
   return 0;
}
