
// Copyright 1992, David Perelman-Hall & Jamshid Afshar

#include "misc.h"
#include "edge.h"
#include "chart.h"
#include "agenda.h"
#include "rules.h"

#ifdef __TURBOC__
#include <alloc.h>
#endif


bool parse( const Category& goal, const Category_Sequence& string )
{
   cout << "Parsing \"" << string << "\"";
   cout << endl << endl;

   RuleList rules;

   // READ IN THE RULES
   rules.read("rulelist");

   Agenda agenda;
   Chart chart(string);
   int vertex = 0; 
   Category_Sequence remaining = string;
   
   while( !remaining.isEmpty() ) {
      agenda.add( Edge( vertex, vertex + 1, remaining.pop() ), chart );
      vertex += 1;
   }

   while( !agenda.isEmpty() ){

      // GRAB AN EDGE OFF THE AGENDA.
      Edge edge = agenda.getNext();

      // SHOW THE EDGE
      cout << "Next edge off agenda-: " << edge << "\n";

      // ADD EDGE TO CHART. TRY TO COMBINE EDGE W/ OTHERS IN CHART.
      // THEN ADD ANY APPLICATION OF FUNDAMENTAL RULE TO AGENDA.
      // IF EDGE IS INACTIVE, TRY TO APPLY GRAMMAR RULES TO RESULT IN
      // AN APPLICATION OF FUNDAMENTAL RULE--AND ADD ANY APPLICATION TO
      // AGENDA.
      chart.add( edge, agenda, rules );
#ifdef __TURBOC__
      cerr << "Memory left: " << farcoreleft() << endl;
#endif
   }

   cout << endl;
   cout << chart;
   cout << endl;

   // TEST CHART FOR SUCCESS(ES)
   return chart.success( goal, string );

   // will work on parse tree today
}
