#if !defined (TDISK)                 // Prevents multiple declarations errors
#define TDISK


/*
   Module        : TDISK.HPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : tdisk class declaration.
*/


// Headers ------------------------------------------------------------------

#include "twindow.hpp"                                       // Other modules


// Macros -------------------------------------------------------------------

#include "stdmacro.h"                           // Standard macro definitions


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"                             // Standard type definitions
#include "prjtype.h"                       // This project's type definitions


// Prototypes ---------------------------------------------------------------

class tdisk                                                    // Disk object
{
   int   id ;                               // Disk's ID (1..10), 1 = largest
   int   color ;                                              // Disk's color
   int   row ;                           // Disk's current position in window
   int   col ;
   twindow huge *winptr ;                               // Ptr to work window


public:

tdisk                                                          // Constructor
(
   int           did,                                            // Disk's id
   int           drow,                             // Initial disk's position
   int           dcol,
   twindow huge *twinptr                                // Ptr to work window
) ;

~tdisk () ;                                                     // Destructor

void tdisk::show () ;                    // Displays disk at current position

void tdisk::erase                        // Erases disk from current position
(
   int towercolor                                            // Tower's color
) ;

void tdisk::moveto                     // Moves disk from on tower to another
(
   int target_row,                                         // Destination row
   int target_col,                                         // Destination col
   int source_color,                                  // Source tower's color
   int target_color,                             // Destination tower's color
   int speed                                             // Animation's speed
) ;


} ;


// End Header File ----------------------------------------------------------

#endif
