#if !defined (FILEFCTS)           /* Prevents multiple declarations errors */
#define FILEFCTS


/*
   Module        : FILEFCTS.H
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Files related functions.
*/


/* Headers --------------------------------------------------------------- */

#include <stdio.h>


/* Macros ---------------------------------------------------------------- */

#include "stdmacro.h"                        /* Standard macro definitions */


/* TypeDefs -------------------------------------------------------------- */

#include "stdtype.h"                          /* Standard type definitions */


/* Prototypes ------------------------------------------------------------ */

#ifdef __cplusplus                     /* Enables linking with C++ modules */
extern "C" {
#endif

int far fnewline              /* Goes to start of next line in a text file */
(
   FILE *f                                         /* Ptr to opened stream */
) ;

dword far fsize                              /* Returns file size in bytes */
(
   FILE *f                                         /* Ptr to opened stream */
) ;

int far fcopy                                        /* Copies a disk file */
(
   char huge *srcpath,                     /* Complete path to source file */
   char huge *destpath,               /* Complete path to destination file */
   bool      verify                  /* TRUE: Verify ON  FALSE: Verify OFF */
) ;


#ifdef __cplusplus
}
#endif


/* End Header File ------------------------------------------------------- */

#endif
