#if !defined (SCRFCTS)            /* Prevents multiple declarations errors */
#define SCRFCTS


/*
   Module        : SCRFCTS.H
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Screen related functions.
*/


/* Headers --------------------------------------------------------------- */

#include <conio.h>


/* Macros ---------------------------------------------------------------- */

#include "stdmacro.h"


/* Typedefs -------------------------------------------------------------- */

#include "stdtype.h"

struct cur_info                        /* Can hold every cursor attributes */
{
   byte attribute ;                                      /* Text attribute */
   byte curx ;                           /* X coordinate in current window */
   byte cury ;                           /* Y coordinate in current window */
   word curtype ;                                          /* Cursor shape */
} ;


/* Prototypes ------------------------------------------------------------ */

#ifdef __cplusplus                     /* Enables linking with C++ modules */
extern "C" {
#endif

void far scr_textattr                 /* Sets colors of next video outputs */
(
   int back,                                           /* Background color */
   int fore                                            /* Foreground color */
) ;

void far scr_vsave           /* Saves all video informations except cursor */
(
   struct text_info huge *ti,                 /* Ptr to a text_info struct */
   char huge*huge *savedscr            /* Ptr to ptr to screen's save area */
) ;

void far scr_vrestore     /* Restores all video informations except cursor */
(
   struct text_info huge *ti,                 /* Ptr to a text_info struct */
   char huge*huge *savedscr            /* Ptr to ptr to screen's save area */
) ;

void far scr_csave                          /* Saves all cursor attributes */
(
   struct cur_info huge *ci                    /* Ptr to a cur_info struct */
) ;

void far scr_crestore                    /* Restores all cursor attributes */
(
   struct cur_info huge *ci                    /* Ptr to a cur_info struct */
) ;


#ifdef __cplusplus
}
#endif


/* End Source File ------------------------------------------------------- */

#endif
