#if !defined (TMENUBAR)              // Prevents multiple declarations errors
#define TMENUBAR


/*
   Module        : TMENUBAR.HPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : tmenubar declaration file.
*/


// Headers ------------------------------------------------------------------

#include <conio.h>                                      // System's libraries

#include "twindow.hpp"                                       // Other modules


// Macros -------------------------------------------------------------------

#include "stdmacro.h"                           // Standard macro definitions


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"                             // Standard type definitions

struct tmenuitem                                             // One menu item
{
   char      huge *itemtext ;                                  // Item's text
   int             itemkey ;             // Item's hotkey (letters or digits)
   int             itemrow ;                                    // Item's row
   int             itemrtnval ;                        // Item's return value
   bool            itemavail ;        // TRUE: available FALSE: not available
   char      huge *itemsltext ;                   // Help text for statusline
   int             itemhlpctx ;            // This item's help context number
   tmenuitem huge *itemnext ;                            // Next item in link
   tmenuitem huge *itemprevious ;                    // Previous item in link
} ;

struct tmenu                                                      // One menu
{
   char       huge *menuname ;                                 // Menu's name
   int              menukey ;               // Menu's key (Letters or digits)
   int              menucolpos ;                    // Menu's column position
   char       huge *menusltext ;                  // Help text for statusline
   int              menuhlpctx ;             // This menu help context number
   tmenuitem  huge *itemfirst ;                         // First item in link
   tmenuitem  huge *itemlast ;                           // Last item in link
   int              itemcount ;               // Number of items in this menu
   int              itemmaxwidth ;                     // Widest item's width
   int              itemlastkey ;             // Last selected item  (hotkey)
   tmenu      huge *menunext ;                           // Next menu in link
   tmenu      huge *menuprevious ;                   // Previous menu in link
} ;


// --------------------------------------------------------------------------

class tmenubar
{
   int         menubackcolor ;                  // Menubar's background color
   int         menuforecolor ;                  // Menubar's foreground color
   int         menuhighcolor ;                   // Menubar's highlight color
   int         menucursorcolor ;                  // Selection cursor's color
   int         menucount ;                      // Number of menus on menubar
   int         menubarwidth ;                   // Width of all created menus
   int         menulastkey ;                   // Last menu selected (hotkey)
   int         menuhlpctx ;                 // Menubar's general help context
   tmenu huge *menufirst ;                              // First menu in link
   tmenu huge *menulast ;                                // Last menu in link


public:

far tmenubar () ;                                              // Constructor

far ~tmenubar () ;                                              // Destructor

void far tmenubar::setcolors                           // Sets menubar colors
(
   int back=LIGHTGRAY,                                    // Background color
   int fore=BLACK,                                        // Foreground color
   int high=RED,                                           // Highlight color
   int cursor=GREEN                                           // Cursor color
) ;

void far tmenubar::sethlpctx           // Sets menubar's default help context
(
   int hlpctx=EV_NOHLPCTX                              // Help context number
) ;

void far tmenubar::addmenu                              // Creates a new menu
(
   char huge *name,                                            // Menu's name
   int       hotkey,                       // Menu's hotkey (letter or digit)
   char huge *sltext=NULL,                   // Statusline text for this menu
   int       hlpctx=EV_NOHLPCTX                 // Menu's help context number
) ;

void far tmenubar::additem               // Adds an item to last created menu
(
   char huge *text=NULL,                                       // Item's text
   int        hotkey=II_NUL,               // Item's hotkey (letter or digit)
   int        returnval=II_NUL,                  // Return value of this item
   char huge *sltext=NULL,                          // Item's statusline text
   int        hlpctx=EV_NOHLPCTX                // Item's help context number
) ;

void far tmenubar::itemsetavail         // Sets item's availability ON or OFF
(
   int  menuhotkey,                         // Hotkey of menu in wich item is
   int  itemhotkey,                             // Hotkey of menu item to set
   bool state=TRUE                   // TRUE: available  FALSE: Not available
) ;

input_info far tmenubar::through                         // Activates menubar
(
   input_info ii                                // Pass input through menubar
) ;

void far tmenubar::refresh () ;                        // Redraws the menubar


private :

tmenu huge* far tmenubar::menuexist    // Checks if menu exists. Returns addr
(
   int menuhotkey                                   // Hotkey of menu to find
) ;

tmenuitem huge* far tmenubar::itemexist              // Checks if item exists
(
   int menuhotkey,                                   // Menu in which to look
   int itemhotkey                                         // Item to look for
) ;

void far tmenubar::menudraw                                // Displays 1 menu
(
   int  hotkey=II_NUL,                              // Hotkey of menu to draw
   bool cursorflag=FALSE                             // TRUE: Displays cursor
) ;

void far tmenubar::itemdraw                      // Displays 1 item in a menu
(
   twindow   huge *winptr,                              // Ptr to menu window
   tmenuitem huge *itemptr,                         // Ptr to item to display
   bool            cursorflag=FALSE     // FALSE: Cursor off  TRUE: Cursor on
) ;

input_info far tmenubar::chooseitem () ;       // Opens menu and chooses item


} ;


// --------------------------------------------------------------------------

   extern tmenubar menubar ;            // Reference to global menubar object


// End Header File ----------------------------------------------------------

#endif
