//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.
//                   test8.cpp
//
//  This programs tests storage and btree clases
//  If you Define the simbol DEBUG_BT for compiling, you will see
//  when an object is created and when is deleted




#include <iostream.h>
#include "dll.h"
#include "btypes.h"
#include "storage.h"
#include "btree.h"

class espe_C {
public:
	int_B a;
	int_B b;
	char_B c;
};

class parent_C {
public:
	int_B a;
	int_B b;
	char_B c;
	void func0();
	virtual void func1();
	virtual void func2();
	virtual void func3();
	parent_C();
};

	parent_C::parent_C(){ a.create(); b.create(); c.create(); }

void parent_C::func0() { cout<<"parent\n";}
void parent_C::func1() { cout<<"parent\n";}
void parent_C::func2() { cout<<"parent\n";}
void parent_C::func3() { cout<<sizeof(this)<<":"<<"parent\n";}


class sun1_C:public parent_C {
public:
	int_B d;
	void func1();
	sun1_C(); 
};


sun1_C::sun1_C() { d.create(); }
void sun1_C::func1() { cout<<"sun1\n";}


class sun2_C:public parent_C {
public:
	void func1();
};

void sun2_C::func1() { cout<<"sun2\n";}




typedef bt_C<parent_C> parent_B;
name_BT(parent_B,"parent_C");
typedef bt_C<sun1_C> sun1_B;
name_BT(sun1_B,"sun1_C");
typedef bt_C<sun2_C> sun2_B;
name_BT(sun2_B,"sun2_C");

typedef bt_C< dll_C<parent_B> > dll_parent_B;

void lista_func1(dll_parent_B& lista)
{
	printf("\n=========Lista=========\n");
	if(lista.is_void()) return;
	if (lista().first())
		do lista().item()().func1();
			while (lista().next());
}


int main()
{
	try
	{
		dll_parent_B lista,lista2,lista3;
		parent_B parent;
		parent_B parent2;
		sun1_B sun1;
		sun1.create();
		parent2=&sun1;
		int n;
		cout<<sizeof(espe_C)<<":"<<sizeof(parent_C)<<":"
			 <<sizeof(types_C)<<":"<<sizeof(gen_B)<<"\n";
		parent.create();
		parent().func3();
		{
			//int trans;
			u_long_B  position,position2,position3;
			btree_C arch;
			arch.init();

			position.create();
			position2.create();
			position3.create();

			arch.open("prueba.dbf",CREATE);
			//trans=arch.begin_trans();
			//arch.set_active_trans(trans);
			for(n=0,lista3.create();n<10;n++)
				if (n>1 && n<8) lista3().insert_r(parent2);
				else   lista3().insert_r(parent);

			for(n=0;n<20;n++){
				arch.put(&lista3,position3);
			}

			n=0;
			if (arch.first(&lista,position))
				do cout<<++n<<"\n";
				while (arch.next(&lista,position));

			while (arch.last(position3)) arch.del(position3);

			n=0;
			if (arch.first(&lista,position))
				do cout<<++n<<"\n";
				while (arch.next(&lista,position));

			for(n=0;n<20;n++)
				arch.put(&lista3,position3);

			n=0;
			if (arch.first(position))
				do cout<<++n<<"\n";
				while (arch.next(position));

			int i;

			for(n=0;n<5;n++)   {
				arch.put(&lista3,position3);
				i=0;
				if (arch.first(position))
					do cout<<++i<<"\n";
					while (arch.next(position));

			}

			n=0;
			if (arch.first(&lista3,position))
				do cout<<++n<<"\n";
				while (arch.next(&lista3,position));
			//arch.end_trans(trans);
			arch.close();
		}
		lista_func1(lista3);
	}
	catch(except_C& except) {
	  cout<<except.msg()<<"\n";
	  cout<<except.extra_msg()<<"\n";
	}
	cout<<"N.BT:"<<types_C::n_bt<<"\n";//number of objets referenced by handlers

	return 0;
}
