program MC68705_Module_Tester;
type
   Str255=String[255];
   filename = string[38];
   filextn  = string[3];
   symbol   = string[8];

   Regs  = record Case Integer of
           1: (AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags :integer);
           2: (AL, AH, BL, BH, CL, CH, DL, DH            :byte);
         End;

   oprec = record                                {Machine Opcode Table}
      mnemonic : symbol;      {Op-code mnemonic}
      stub,                   {Basic hex. opcode if +ve, or command if -ve}
      modes    : integer;     {Addressing modes, bit-mapped}
      end;
   oplist      = array[1..127] of oprec; {Table of opcodes}

   ViewControl = (Initz, View, Finish);  {File-Viewer controls}

const
   codefilename : filename    = '68705OPC.BIN';  {Name of op-codes file}
   digit        : set of char = ['0'..'9'];
   logline      : integer     = 16;              {Report line for subtasks}
   filstem      = ' Default File: ';  {Flag work-file on screen}
   srcextn      : filextn = 'SRC';    {Std. extension for Source files}
   hexextn      : filextn = 'HEX';    {Std. extension for Hex. files}
   comenv       = 'COMSPEC';          {Environment key - DOS Command}
   wprenv       = 'WORDPATH';         {Environment key - Word Processor}

   version     : string[4] = '1.01';  {Assembler Version no.}

   whitespace  : set of char = [' ' , #9];
   upper       : set of char = ['A'..'Z'];
   lower       : set of char = ['a'..'z'];
   nofile      : string[6]   = '<None>';    {Null file}

   TAB         : char = ^I;
   CR          : char = ^M;
   LF          : char = ^J;
   ESC         : char = #27;
   ENDFILE     : char = ^Z;

var
   commandpath,                       {Path to DOS COMMAND processor}
   wordprocpath,                      {Path to Word Processor, or null}
   dfltname,                          {Main Default file name}
   listname,                          {Assembler listing file}
   srcname           : filename;      {and Primary source-file}
   hexfile,                           {Hex. (Motorola) format File}
   lstfile           : text;          {Listing File}

   memvalid,                          {Memory image holds a good program}
   altered           : boolean;       {Memory image changed: needs saving}
   today             : symbol;        {Current date, ex-DOS}
   memmax,                            {Highest memory loc.}
   oldsel,                            {Last sub-task run}
   runjob,                            {Choose sub-task to run}
   errcount          : integer;       {Count Assembler errors seen}
   memory            : array[0..8191] of byte; {The MC68705 RAM & EPROM}
   prefix            : string[80];    {Message frame - Asm. & Emulator}


{*************** Hexadecimal Output (Listing) Routines *****************
                  These all load results into PREFIX }

Procedure hexchar (loc :integer; value :byte);   {List 1 hex. character}
const
   hextab : array[0..15] of char =
            ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

begin
   prefix[loc]:= hextab[value and 15];
   end;

Procedure hexbyte (loc :integer; value :byte);   {List 1 hex. byte}
begin
   hexchar(loc, value div 16);
   hexchar(loc+1, value);
   end;

Procedure hexword (loc, value :integer);         {List 1 hex. word}
begin
   hexbyte(loc  ,hi(value));
   hexbyte(loc+2,lo(value));
   end;

Function hex( a:char) :integer;      {Just the hex. value of 'a'}
begin
   if a in digit then
      hex:= ord(a) - ord('0')
   else if a in ['A'..'F'] then
      hex:= ord(a) - ord('A') + 10
   else
      hex:= -1;
   end;

Function date : symbol;              {Gets Date, as DD:MM:YY}
var
   registers  :Regs;                 {Machine registers for DOS call}
   day, month :string[2];
   year       :string[4];

begin
   with registers do begin
      AX := $2A00;                   {DOS call for Date}
      INTR ($21, registers);         {To DOS}
      str(CX:4,year);                {Unpack Year}
      str(lo(DX):2,day);
      str(hi(DX):2,month);           {Day & Month}
      if (month[1] =' ') then month[1]:= '0'; {Leading zero in Month}
      date:= day + ':' + month + ':' + copy(year,3,2);
      end
   end;



{************************** Main Program Routines ************************}

type
   axis   = (xco,yco);
   coord  = array[xco..yco] of integer;

const
   horline   : byte = $cd;                 {Special screen chars. - effects}
   verline   : byte = $ba;
   topleft   : byte = $c9;
   topright  : byte = $bb;
   botleft   : byte = $c8;
   botright  : byte = $bc;
   midleft   : byte = $cc;
   midright  : byte = $b9;
   midtop    : byte = $cb;
   midbot    : byte = $ca;
   crossing  : byte = $ce;

   win1top   : coord = (2,4);              {Main screen windows}
   win1bot   : coord = (27,24);
   win2top   : coord = (37,4);
   win2bot   : coord = (80,22);
   win3top   : coord = (37,22);
   win3bot   : coord = (80,24);

   cline     : integer = 8;              {No. of elements in "selector" array}

procedure choose(sel :integer);            {Display one choice}
type
   choice = string[20];

const
   selector  : array[1..8] of choice =(
               'Select Default File',
               'Run DOS Command',
               'Run Word Processor',
               'Assembler',
               'Execution Emulator',
               'Load Exorciser file',
               'Save Exorciser file',
               'Exit to DOS' );
begin
   gotoxy(win1top[xco]+1,(2*sel)+win1top[yco]+2);
   write(sel:2, '. ', selector[sel]);
   end;

Function environment (arg :filename) : filename; {Get Environment String}
  Type
    Env=Array [0..32767] Of Char;
  Var
    EPtr: ^Env;
    EStr: string[255];
    Done: Boolean;
    I: Integer;

  Begin
    for i:= 1 to length(arg) do arg[i]:= upcase(arg[i]);  {Uppercase argt.}
    EPtr:=Ptr(MemW[CSeg:$002C],0);
    environment:= '';
    I:=0;
    Done:=False;
    EStr:='';
    Repeat
      If EPtr^[I]=#0 Then
       Begin
        If EPtr^[I+1]=#0 Then Done:=True;
        If Copy(EStr,1,length(arg)+1) = (arg + '=') then
         Begin
          environment:= copy(estr,length(arg)+2,100);
          Done:=True;
         End;
        EStr:='';
       End
      Else EStr:=EStr+EPtr^[I];
      I:=I+1;
    Until Done;
  End;

procedure showfile;                        {Display current file}
var
   xpt, scol  : integer;
begin
   scol:= win3top[xco]+length(filstem)+1;
   highvideo;
   gotoxy(scol, win3top[yco]+1);
   for xpt:= scol to win3bot[xco]-1 do write(' '); {Selective blank-out}
   gotoxy(scol, win3top[yco]+1);
   write(dfltname);
   end;

procedure setwin(topgap :integer);         {Set a reduced-size window}
begin
   window ( win2top[xco]+1, win2top[yco]+topgap+1,
            win2bot[xco]-1, win2bot[yco]-1);
   end;


procedure showsel(level :integer);         {Display Main-Menu choices}
var
   ctr : integer;

begin
   window(1,1,80,25);                      {Window controls OFF}

   if (level = 0) then begin               {Zero: re-display everything}
      lowvideo;
      for ctr:= 1 to cline do choose(ctr);     {Main menu choices}
      end
   else if (level > 0) then begin          {Positive: One in highlight}
      highvideo;
      choose(level);
      end
   else begin                              {Negative: One in background}
      lowvideo;
      choose(-level);
      end;

   window(win2top[xco]+1, win2top[yco]+1,  {Then reset working window}
          win2bot[xco]-1, win2bot[yco]-1);
   end;

procedure vbar(start, finish :coord);      {Draws a vertical bar on screen}
var                                        {OMITTING the given end-points}
   y    : integer;

begin
   for y:= start[yco]+1 to finish[yco]-1 do begin
      gotoxy(start[xco], y);
      write(chr(verline));
      end
   end;

procedure hbar(start, finish :coord);      {Draws horizontal bar on screen}
var                                        {OMITTING the given end-points}
   x    : integer;

begin
   gotoxy(start[xco]+1, start[yco]);
   for x:= start[xco]+1 to finish[xco]-1 do write(chr(horline));
   end;

procedure drawwindow(tlt, brt :coord);     {Draws rectangular box on screen}
var
   x            : integer;
   diagl, diagr : coord;
   waste        : char;

begin                                      {Find the diagonal points}
   diagl:= tlt;     diagl[yco]:= brt[yco];
   diagr:= brt;     diagr[yco]:= tlt[yco];
                                           {Do the corners}
   gotoxy(tlt[xco],   tlt[yco]);   write(chr(topleft));
   gotoxy(diagl[xco], diagl[yco]); write(chr(botleft));
   gotoxy(diagr[xco], diagr[yco]); write(chr(topright));
   gotoxy(brt[xco],   brt[yco]);   write(chr(botright));

   hbar(tlt,diagr);                        {Two horizontal bars}
   hbar(diagl,brt);

   vbar(tlt,diagl);                        {Two vertical bars}
   vbar(diagr,brt);
   end;

{**************************************************************************

            S U B  -  T A S K   P R O C E D U R E S

***************************************************************************}

function stdfile(extn :filextn) :filename;   {Standard file extn.}
var
   x      : integer;
   tmp    : filename;
begin
   tmp:= dfltname;
   x:= pos('.',dfltname);
   if (((extn <> srcextn) or (x = 0)) and (tmp <> '')) then begin
      if (x > 0) then tmp:= copy(dfltname,1,x-1);
      tmp:= tmp + '.' + extn;
      end;
   stdfile:= tmp;
   end;

function workfile ( line :integer;           {Line to put query on}
                   usage :filename;          {Prompt string}
                    extn :filextn)           {Default name extension}
                         :filename;          {Makes correct file name}
var
   work : filename;
   wcol : integer;

begin
   gotoxy(2,line);
   lowvideo;
   write(usage:8, ' name: [');
   wcol:= wherex;
   highvideo;
   write(stdfile(extn));
   lowvideo;
   writeln(']');
   gotoxy(wcol-1,line+1);
   write('>');
   highvideo;
   readln(work);
   if (work = '') then work:= stdfile(extn);
   if ((pos('.', work) =0) and
       (work[length(work)] <> ':'))  then work:= work + '.' + extn;
   gotoxy(wcol,line+1);
   write(work);
   workfile:= work;
   end;

function accept(line :integer) :boolean;   {User confirms task}
var
   ans  : char;
   pos  : integer;

begin
   highvideo;
   gotoxy(2,line);
   write('OK to Proceed [Y/CR or N]: ');
   pos:= wherex;
   read(kbd,ans);
   while (not (ans in ['Y', 'N', 'y', 'n', CR])) do begin
      gotoxy(2, line+1);
      write('"Y", CR, or "N", please');
      gotoxy(pos, line);
      read(kbd,ans);
      end;
   if (upcase(ans) in ['Y', 'y', CR]) then
      accept:= true
   else begin
      accept:= false;
      prefix:= 'Cancelled by User';
      end
   end;

{$I 68705SVC.PAS}
{$I 68705VIW.PAS}
{$I 68705DBG.PAS}

begin
   memmax:= 2047;             {Test fix only}
   writeln;
   writeln('Viewer File (or "<None>"):'); readln(listname);
   DoEmulation;
   end.
