opdclass o_reg   = { 3, NO , NO , NO , 0};
opdclass o_rp    = { 2, NO , NO , NO , 0};
opdclass o_mem   = {16, NO , YES, NO , 0};
opdclass o_data  = { 8, YES, NO , NO , 0};
opdclass o_data2 = {16, YES, YES, NO , 0};
opdclass o_port  = { 8, NO , NO , NO , 0};
opdclass o_rupt  = { 3, NO , NO , NO , 0};
opdclass o_cond  = { 3, NO , NO , NO , 0};

insclass i_reg1  = {1, 1, &o_reg , &o_none, -3, 0};
insclass i_reg2  = {1, 1, &o_reg , &o_none,  0, 0};
insclass i_rp    = {1, 1, &o_rp  , &o_none, -4, 0};
insclass i_data  = {2, 1, &o_data, &o_none,  8, 0};
insclass i_rd    = {2, 2, &o_reg , &o_data, -3, 8};
insclass i_drd   = {3, 2, &o_reg , &o_data2,-3, 16};
insclass i_mem   = {3, 1, &o_mem , &o_none,  8, 0};
insclass i_rupt  = {1, 1, &o_rupt, &o_none, -3, 0};
insclass i_port  = {2, 1, &o_port, &o_none,  8, 0};
insclass i_rr    = {1, 2, &o_reg , &o_reg , -3, 0};
insclass i_cond  = {1, 1, &o_cond, &o_none, -3, 0};
insclass i_condm = {3, 2, &o_cond, &o_mem , -3, 16};

opdef optab[] = {
	"aci"    , &i_data , 0xce, geninstr,
	"adc"    , &i_reg2 , 0x88, geninstr,
	"adcm"   , &i_noopd, 0x8e, geninstr,
	"add"    , &i_reg2 , 0x80, geninstr,
	"addm"   , &i_noopd, 0x86, geninstr,
	"adi"    , &i_data , 0xc6, geninstr,
	"ana"    , &i_reg2 , 0xa0, geninstr,
	"anam"   , &i_noopd, 0xa6, geninstr,
	"ani"    , &i_data , 0xe6, geninstr,
	"call"   , &i_mem  , 0xcd, geninstr,
	"cc"     , &i_condm, 0xc4, geninstr,
	"cma"    , &i_noopd, 0x2f, geninstr,
	"cmc"    , &i_noopd, 0x3f, geninstr,
	"cmp"    , &i_reg2 , 0xb8, geninstr,
	"cmpm"   , &i_noopd, 0xbe, geninstr,
	"cpi"    , &i_data , 0xfe, geninstr,
	"daa"    , &i_noopd, 0x27, geninstr,
	"dad"    , &i_rp   , 0x09, geninstr,
	"dcr"    , &i_reg1 , 0x05, geninstr,
	"dcrm"   , &i_noopd, 0x35, geninstr,
	"dcx"    , &i_rp   , 0x0b, geninstr,
	"di"     , &i_noopd, 0xf3, geninstr,
	"ei"     , &i_noopd, 0xfd, geninstr,
	"hlt"    , &i_noopd, 0x76, geninstr,
	"in"     , &i_port , 0xdb, geninstr,
	"inr"    , &i_reg1 , 0x04, geninstr,
	"inrm"   , &i_noopd, 0x34, geninstr,
	"inx"    , &i_rp   , 0x03, geninstr,
	"jc"     , &i_condm, 0xc2, geninstr,
	"jmp"    , &i_mem  , 0xc3, geninstr,
	"lda"    , &i_mem  , 0x3a, geninstr,
	"ldax"   , &i_rp   , 0x0a, geninstr,
	"ldi"    , &i_rd   , 0x06, geninstr,
	"ldr"    , &i_reg1 , 0x46, geninstr,
	"lhld"   , &i_mem  , 0x2a, geninstr,
	"lxi"    , &i_drd  , 0x01, geninstr,
	"mrr"    , &i_rr   , 0x40, geninstr,
	"mvim"   , &i_data , 0x36, geninstr,
	"nop"    , &i_noopd, 0x00, geninstr,
	"ora"    , &i_reg2 , 0xb0, geninstr,
	"oram"   , &i_noopd, 0xb6, geninstr,
	"ori"    , &i_data , 0xf6, geninstr,
	"out"    , &i_port , 0xd3, geninstr,
	"pchl"   , &i_noopd, 0xe9, geninstr,
	"pop"    , &i_rp   , 0xc1, geninstr,
	"poppsw" , &i_noopd, 0xf1, geninstr,
	"push"   , &i_rp   , 0xc5, geninstr,
	"pushpsw", &i_noopd, 0xf5, geninstr,
	"ral"    , &i_noopd, 0x17, geninstr,
	"rar"    , &i_noopd, 0x1f, geninstr,
	"rc"     , &i_condm, 0xc0, geninstr,
	"ret"    , &i_noopd, 0xc9, geninstr,
	"rim"    , &i_noopd, 0x20, geninstr,
	"rlc"    , &i_noopd, 0x07, geninstr,
	"rrc"    , &i_noopd, 0x0f, geninstr,
	"rst"    , &i_rupt , 0xc7, geninstr,
	"sbb"    , &i_reg2 , 0x98, geninstr,
	"sbbm"   , &i_noopd, 0x9e, geninstr,
	"sbi"    , &i_data , 0xde, geninstr,
	"shld"   , &i_mem  , 0x22, geninstr,
	"sim"    , &i_noopd, 0x30, geninstr,
	"sphl"   , &i_noopd, 0xf9, geninstr,
	"sta"    , &i_mem  , 0x32, geninstr,
	"stax"   , &i_rp   , 0x02, geninstr,
	"stc"    , &i_noopd, 0x37, geninstr,
	"str"    , &i_reg2 , 0x70, geninstr,
	"sub"    , &i_reg2 , 0x90, geninstr,
	"subm"   , &i_noopd, 0x96, geninstr,
	"sui"    , &i_data , 0xd6, geninstr,
	"xchg"   , &i_noopd, 0xeb, geninstr,
	"xra"    , &i_reg2 , 0xa8, geninstr,
	"xram"   , &i_noopd, 0xae, geninstr,
	"xri"    , &i_data , 0xee, geninstr,
	"xthl"   , &i_noopd, 0xe3, geninstr,
};

#define oplen sizeof(optab)/sizeof(opdef)

symbol predef[] = {
	{"ra"        ,      7, &o_reg , (segmnt *)0 },
	{"rb"        ,      0, &o_reg , (segmnt *)0 },
	{"rc"        ,      1, &o_reg , (segmnt *)0 },
	{"rd"        ,      2, &o_reg , (segmnt *)0 },
	{"re"        ,      3, &o_reg , (segmnt *)0 },
	{"rh"        ,      4, &o_reg , (segmnt *)0 },
	{"rl"        ,      5, &o_reg , (segmnt *)0 },
	{"rbc"       ,      0, &o_rp  , (segmnt *)0 },
	{"rde"       ,      1, &o_rp  , (segmnt *)0 },
	{"rhl"       ,      2, &o_rp  , (segmnt *)0 },
	{"sp"        ,      3, &o_rp  , (segmnt *)0 },
	{"rupt0"     ,      0, &o_rupt, (segmnt *)0 },
	{"rupt1"     ,      1, &o_rupt, (segmnt *)0 },
	{"rupt2"     ,      2, &o_rupt, (segmnt *)0 },
	{"rupt3"     ,      3, &o_rupt, (segmnt *)0 },
	{"rupt4"     ,      4, &o_rupt, (segmnt *)0 },
	{"rupt5"     ,      5, &o_rupt, (segmnt *)0 },
	{"rupt6"     ,      6, &o_rupt, (segmnt *)0 },
	{"rupt7"     ,      7, &o_rupt, (segmnt *)0 },
	{"nz"        ,      0, &o_cond, (segmnt *)0 },
	{"z"         ,      1, &o_cond, (segmnt *)0 },
	{"nc"        ,      2, &o_cond, (segmnt *)0 },
	{"c"         ,      3, &o_cond, (segmnt *)0 },
	{"po"        ,      4, &o_cond, (segmnt *)0 },
	{"pe"        ,      5, &o_cond, (segmnt *)0 },
	{"p"         ,      6, &o_cond, (segmnt *)0 },
	{"m"         ,      7, &o_cond, (segmnt *)0 },
	{"ramstart"  ,      0, &o_mem , (segmnt *)0 },
	{"ramend"    ,      0, &o_mem , (segmnt *)0 },
	{"romstart"  ,      0, &o_mem , (segmnt *)0 },
	{"romend"    ,      0, &o_mem , (segmnt *)0 },
	{""          ,      0, &o_none, (segmnt *)0 }
};
