/*
        Custom Computer Consultants
        Universal Cross Assembler
        8051 Symbols
        5 April 1986
*/

#include <stdio.h>
#include <uasm.h>

char   *version = {"8051 Assembler -- V3.2  4/5/86\n"} ;

#define BSEG    0       /*      Register Segment        */
#define CSEG    1       /*      Code Segment            */
#define DSEG    2       /*      Data Segment            */
#define XSEG    3       /*      External Data Segment   */
#define ASCII   4       /*      String                  */
#define PAGE    5       /*      Page Eject              */
#define RADIX   6       /*      Define Radix            */
#define BIT     7       /*      Bit Address             */
#define DB      8       /*      Define Byte             */
#define DS      9       /*      Define Storage          */
#define DW      10      /*      Define Word             */
#define EQU     11      /*      Equate                  */
#define ORG     12      /*      Origin                  */

extern int     pass1 ;
extern int     lbl ;
extern int     i, j, k ;
extern int     lnspp ;
extern int     cc ;
extern int     ilc ;
extern int     active ;
extern int     instl ;
extern int     parval ;
extern int     radix ;
extern int     cput ;
extern int     syte, sytx ;

extern unsigned        unpar ;
extern unsigned        ha, he, hsp ;

extern unsigned  char    ch ;
extern unsigned  char    sym ;

extern char    *iptr ;  
extern char    segtype[] ;

extern unsigned  char    ib[] ;
extern unsigned  char    pv[] ;
extern unsigned  char    px[] ;

extern           int     pj[] ;
extern           int     il[] ;
extern char    *pc[], *pseudo[] ;

extern int     (*pp[])() ;
extern int     (*ppo[])() ;

extern char    ibuf[] ;

extern struct  symbol  symtab[] ;

#define SYMTYPE  (symtab[sytx].flags&(NSEG-1))

code_seg() { return CSEG ; }

not_cseg(seg)
int    seg ;
{
       if( seg == BSEG || seg == DSEG ) return TRUE ;
       else return FALSE ;
}

set_il()
{
       il[BSEG] =     0 ;
       il[CSEG] =     0 ;
       il[DSEG] =    32 ;
       il[XSEG] = 16384 ;
}

set_type()
{
       segtype[BSEG] = '^'  ;
       segtype[CSEG] = '\'' ;
       segtype[DSEG] = '\"' ;
       segtype[XSEG] = '+'  ;
}


gen(len)
int     len ;
{
        ib[2] = parval & 0xFF ;
        ib[1] = len == 3 ? parval >> 8 : ib[2] ;
        instl = len ;
        ib[0] = pv[k] ;
        return TRUE ;
}               

nopr()  { return gen(1) ; }

accm()  { if( nomatch("A") )            return FALSE ;
          return gen(1) ; }

abac()  { if( nomatch("AB") )           return FALSE ;
          return gen(1) ; }

cflg()  { if( nomatch("C") )            return FALSE ;
          return gen(1) ; }

dptr()  { if( nomatch("DPTR") )         return FALSE ;
          return gen(1) ; }

bita()  { parval = eval() ;
          return gen(2) ;  }

dadr()  { parval = eval() ;
          return gen(2) ;  }

adrl()  { parval = eval() ;
          return gen(3) ;  }

adrs()  { parval = eval() ;
          gen(2) ;
          ib[0] |= (( parval >> 3 ) & 0xE0 ) ;
          return TRUE  ; }

adrx()  { unpar = parval = eval() ;
          
          if ( unpar < 2048 )
                { gen(2) ; ib[0] |= (( unpar >> 3 ) & 0xE0 ) ; }
          else  { gen(3) ; ++ib[0] ; }

          return TRUE  ; }

rela()  { crela(2) ;
          return gen(2) ; }

crela(n)
int     n ;
{
        parval = eval() - ( ilc + n ) ;
        if( parval > 127 || parval < -128 ) push('R') ;
}


acir()  { if( nomatch("A,") )           return FALSE ;
          return indr() ; }

indr()  { if( nomatch("@R") )           return FALSE ;
          if( ch < '0' ||
              ch > '1'   )              return FALSE ;
          gen(1) ;
          ib[0] |= ( 0x01 & ( ch - '0' ) ) ;
          getch() ;
          return TRUE  ; }

irim()  { if( !indr() )                 return FALSE ;
          if( nomatch(",#") )           return FALSE ;
          parval = eval() ;
          ib[1] = parval & 0xFF ;
          ++instl ;
          return TRUE ; }

irac()  { if( !indr() )                 return FALSE ;
          if( nomatch(",A") )           return FALSE ;
          return TRUE ; }

irdd()  { if( !indr() )                 return FALSE ;
          if( notcomma() )              return FALSE ;
          if( !alphanum(ch) )           return FALSE ;
          parval = eval() ;
          ib[1] = parval & 0xFF ;
          ++instl ;
          return TRUE ; }

acrg()  { if( nomatch("A,") )           return FALSE ;
          return regr() ; }

regr()  { if( nomatch("R") )            return FALSE ;
          if( ch < '0' ||
              ch > '7'    )             return FALSE ;
          gen(1) ;
          ib[0] |= ( 0x07 & ( ch - '0' ) ) ;
          getch() ;
          return TRUE ; }

rgim()  { if( !regr() )                 return FALSE ;
          if( nomatch(",#") )           return FALSE ;
          parval = eval() ;
          ib[1] = parval & 0xFF ;
          ++instl ;
          return TRUE ; }

rgac()  { if( !regr() )                 return FALSE ;
          if( nomatch(",A") )           return FALSE ;
          return TRUE ; }

rgdd()  { if( !regr() )                 return FALSE ;
          if( notcomma() )              return FALSE ;
          if( !alphanum(ch) )           return FALSE ;
          parval = eval() ;
          ib[1] = parval & 0xFF ;
          ++instl ;
          return TRUE ; }

apdp()  { if( nomatch("@A+DPTR") )      return FALSE ;
          return gen(1) ; }


dpim()  { if( nomatch("DPTR,#") )       return FALSE ;
          parval = eval() ;
          return gen(3) ; }

acim()  { if( nomatch("A,#") )          return FALSE ;
          parval = eval() ;
          return gen(2) ; }

acdd()  { if( nomatch("A,") )           return FALSE ;
          if( !alphanum(ch) )           return FALSE ;
          return dadr() ; }

cfcb()  { if( nomatch("C,/") )          return FALSE ;
          if( !alphanum(ch) )           return FALSE ;
          return bita() ; }

cfba()  { if( nomatch("C,") )           return FALSE ;
          if( !alphanum(ch) )           return FALSE ;
          return bita() ; }

idac()  { if( nomatch("@DPTR,A") )      return FALSE ;
          return gen(1) ; }

acid()  { if( nomatch("A,@DPTR") )      return FALSE ;
          return gen(1) ; }

acap()  { if( nomatch("A,@A+PC") )      return FALSE ;
          return gen(1) ; }

acad()  { if( nomatch("A,@A+DPTR") )    return FALSE ;
          return gen(1) ; }

ddim()  { if( !alphanum(ch) )           return FALSE ;
          if( !dadr() )                 return FALSE ;
          if( nomatch(",#") )           return FALSE ;
          parval = eval() ;
          ib[2] = parval & 0xFF ;
          ++instl ;
          return TRUE ; }

ddir()  { if( !alphanum(ch) )           return FALSE ;
          parval = eval() ;
          if( notcomma() )              return FALSE ;
          if ( !indr() )                return FALSE ;
          ib[1] = parval & 0xFF ;
          instl = 2 ;
          return TRUE ; }

ddrg()  { if( !alphanum(ch) )           return FALSE ;
          parval = eval() ;
          if( notcomma() )              return FALSE ;
          if( !regr() )                 return FALSE ;
          ib[1] = parval & 0xFF ;
          instl = 2 ;
          return TRUE ; }

ddac()  { if( !alphanum(ch) )           return FALSE ;
          parval = eval() ;
          if ( nomatch(",A") )          return FALSE ;
          return gen(2) ; }

dddd()  { if( !alphanum(ch) )           return FALSE ;
          parval = eval() ;
          if ( notcomma() )             return FALSE ;
          ib[1] = parval & 0xFF ;
          if( !alphanum(ch) )           return FALSE ;
          parval = eval() ;
          ib[2] = parval & 0xFF ;
          ib[0] = pv[k] ;
          instl = 3 ;                   return TRUE ; }

barl()  { bita() ;
          if( notcomma() )              return FALSE ;
          crela(3) ;
          ib[2] = parval & 0xFF ;
          instl = 3 ;                   return TRUE  ; }

rgrl()  { if( !regr() )                 return FALSE ;
          if( notcomma() )              return FALSE ;
          crela(2) ; 
          ib[1] = parval & 0xFF ;
          instl = 2 ;
          return TRUE ; }

ddrl()  { if( !alphanum(ch) )           return FALSE ;
          parval = eval() ;
          if( notcomma() )              return FALSE ;
          gen(2) ;
          crela(3) ;
          ib[2] = parval & 0xFF ;
          instl = 3 ;                   return TRUE ; }

bacf()  { bita() ;
          if( nomatch(",C") )           return FALSE ;
          return TRUE ; }

cair()  { if( nomatch("A,#") )  return FALSE ; 
          parval = eval() ;
          if( notcomma() )      return FALSE ;
          gen(2) ;
          crela(3) ;
          ib[2] = parval & 0xFF ;
          instl = 3 ;                   return TRUE ; }

cadr()  { if( nomatch("A,") )           return FALSE ; 
          if( !ddrl() )                 return FALSE ;
          return TRUE ; }

ciir()  { if( !indr() )                 return FALSE ;
          if( nomatch(",#") )           return FALSE ;
          parval = eval() ;
          if( notcomma() )              return FALSE ;
          ib[1] = parval & 0xFF ;
          crela(3) ;
          ib[2] = parval & 0xFF ;
          instl = 3 ;                   return TRUE ; }

crir()  { if( !regr() )                 return FALSE ;
          if( nomatch(",#") )           return FALSE ;
          parval = eval() ;
          ib[1] = parval & 0xFF ;
          if( notcomma() )              return FALSE ;
          crela(3) ;
          ib[2] = parval & 0xFF ;
          instl = 3 ;                   return TRUE ; }


#define INFO     1
#define NOINFO   0

doseg()
{
       il[active] = ilc ;
       ilc = il[j] ;
       active = j ;
       return NOINFO ;
}

dods()
{
       instl = eval() ;
       return NOINFO ;
}

dodw()
{                
       parval = eval() ;
       ib[cput++] = parval >> 8 ;
       ib[cput++] = parval & 0xFF ;
       while ( sym == ',' ) {
         getch() ;
         parval = eval() ;
         ib[cput++] = parval >> 8 ;
         ib[cput++] = parval & 0xFF ;
         }
       instl = cput ;
       return INFO ;
}

dodb()
{
       parval = eval() ;
       ib[cput++] = parval & 0xFF ;
       while ( sym == ',' ) {
         getch() ;
         ib[cput++] = eval() & 0xFF ;
         }
       instl = cput ;
       return INFO ;
}                            

dobit()
{
       parval = eval() ;
       if ( pass1 && (lbl == OK) ) {
         symtab[syte-1].value = parval ;
         symtab[syte-1].flags = BSEG ;
         }
       return NOINFO ;
}

doequ()
{
       parval = eval() ;
       if ( pass1 && (lbl == OK) ) {
         symtab[syte-1].value = parval ;
         symtab[syte-1].flags = active ;
         }
       return NOINFO ;
}

doorg()
{
       parval = eval() ;
       ilc = parval ;
       if ( hsp == 0 ) ha = he = ilc ;
       return NOINFO ;
}

dopage()
{
       lnspp = 0 ;
       return NOINFO ;
}

doradix()
{
       radix = eval() ;
       return NOINFO ;
}

doascii()
{
       while( isin(ch," \t") ) getch() ;
       sym = ch ; getch() ;
       while( ch != sym && ch != '\n' ) {
         ib[cput++] = ch ;
         getch() ;
         }
       ib[cput++] = EOS ;
       instl = cput ;
       return INFO ;
}

/*
        build_pseudo -- build a table of pointers to pseudo-ops
*/

build_pseudo()
{
        
        j = -1 ;
        pseudo[++j] = "ASCII" ; pj[j] = ASCII ; ppo[ASCII] = doascii ;
        pseudo[++j] = "BIT"   ; pj[j] = BIT   ; ppo[BIT]   = dobit   ;
        pseudo[++j] = "BSEG"  ; pj[j] = BSEG  ; ppo[BSEG]  = doseg   ;
        pseudo[++j] = "CSEG"  ; pj[j] = CSEG  ; ppo[CSEG]  = doseg   ;
        pseudo[++j] = "DB"    ; pj[j] = DB    ; ppo[DB]    = dodb    ;
        pseudo[++j] = "DS"    ; pj[j] = DS    ; ppo[DS]    = dods    ;
        pseudo[++j] = "DSEG"  ; pj[j] = DSEG  ; ppo[DSEG]  = doseg   ;
        pseudo[++j] = "DW"    ; pj[j] = DW    ; ppo[DW]    = dodw    ;
        pseudo[++j] = "EQU"   ; pj[j] = EQU   ; ppo[EQU]   = doequ   ;
        pseudo[++j] = "ORG"   ; pj[j] = ORG   ; ppo[ORG]   = doorg   ;
        pseudo[++j] = "PAGE"  ; pj[j] = PAGE  ; ppo[PAGE]  = dopage  ;
        pseudo[++j] = "RADIX" ; pj[j] = RADIX ; ppo[RADIX] = doradix ;
        pseudo[++j] = "XSEG"  ; pj[j] = XSEG  ; ppo[XSEG]  = doseg   ;
        return ++j ;
}


/*
        buildopc -- build opcode definition tables
                pc - opcode strings
                px - index by opcode into opcode values & post processing
                pv - opcode values
                pp - post processing functions
*/
buildopc()
{


        i = j = 0 ;

        pc[i]="ACALL" ; px[i++]=j ;     pv[j]=0x11 ; pp[j++]=adrs ;
        pc[i]="ADD"   ; px[i++]=j ;     pv[j]=0x24 ; pp[j++]=acim ;
                                        pv[j]=0x26 ; pp[j++]=acir ;
                                        pv[j]=0x28 ; pp[j++]=acrg ;
                                        pv[j]=0x25 ; pp[j++]=acdd ;
        pc[i]="ADDC"  ; px[i++]=j ;     pv[j]=0x34 ; pp[j++]=acim ;
                                        pv[j]=0x36 ; pp[j++]=acir ;
                                        pv[j]=0x38 ; pp[j++]=acrg ;
                                        pv[j]=0x35 ; pp[j++]=acdd ;
        pc[i]="AJMP"  ; px[i++]=j ;     pv[j]=0x01 ; pp[j++]=adrs ;
        pc[i]="ANL"   ; px[i++]=j ;     pv[j]=0x54 ; pp[j++]=acim ;
                                        pv[j]=0x56 ; pp[j++]=acir ;
                                        pv[j]=0x58 ; pp[j++]=acrg ;
                                        pv[j]=0x55 ; pp[j++]=acdd ;
                                        pv[j]=0x82 ; pp[j++]=cfba ;
                                        pv[j]=0xB0 ; pp[j++]=cfcb ;
                                        pv[j]=0x52 ; pp[j++]=ddac ;
                                        pv[j]=0x53 ; pp[j++]=ddim ;
        pc[i]="BB"    ; px[i++]=j ;     pv[j]=0x20 ; pp[j++]=barl ;
        pc[i]="BBC"   ; px[i++]=j ;     pv[j]=0x10 ; pp[j++]=barl ;
        pc[i]="BC"    ; px[i++]=j ;     pv[j]=0x40 ; pp[j++]=rela ;
        pc[i]="BNB"   ; px[i++]=j ;     pv[j]=0x30 ; pp[j++]=barl ;
        pc[i]="BNC"   ; px[i++]=j ;     pv[j]=0x50 ; pp[j++]=rela ;
        pc[i]="BNZ"   ; px[i++]=j ;     pv[j]=0x70 ; pp[j++]=rela ;
        pc[i]="BR"    ; px[i++]=j ;     pv[j]=0x80 ; pp[j++]=rela ;
        pc[i]="BSR"   ; px[i++]=j ;     pv[j]=0x11 ; pp[j++]=adrx ;
        pc[i]="BZ"    ; px[i++]=j ;     pv[j]=0x60 ; pp[j++]=rela ;
        pc[i]="CALL"  ; px[i++]=j ;     pv[j]=0x11 ; pp[j++]=adrx ;
        pc[i]="CJNE"  ; px[i++]=j ;     pv[j]=0xB6 ; pp[j++]=ciir ;
                                        pv[j]=0xB4 ; pp[j++]=cair ;
                                        pv[j]=0xB5 ; pp[j++]=cadr ;
                                        pv[j]=0xB8 ; pp[j++]=crir ;
        pc[i]="CLR"   ; px[i++]=j ;     pv[j]=0xE4 ; pp[j++]=accm ;
                                        pv[j]=0xC3 ; pp[j++]=cflg ;
                                        pv[j]=0xC2 ; pp[j++]=bita ;
        pc[i]="CPL"   ; px[i++]=j ;     pv[j]=0xF4 ; pp[j++]=accm ;
                                        pv[j]=0xB3 ; pp[j++]=cflg ;
                                        pv[j]=0xB2 ; pp[j++]=bita ;
        pc[i]="DA"    ; px[i++]=j ;     pv[j]=0xD4 ; pp[j++]=accm ;
        pc[i]="DEC"   ; px[i++]=j ;     pv[j]=0x14 ; pp[j++]=accm ;
                                        pv[j]=0x16 ; pp[j++]=indr ;
                                        pv[j]=0x18 ; pp[j++]=regr ;
                                        pv[j]=0x15 ; pp[j++]=dadr ;
        pc[i]="DIV"   ; px[i++]=j ;     pv[j]=0x84 ; pp[j++]=abac ;
        pc[i]="DJNZ"  ; px[i++]=j ;     pv[j]=0xD8 ; pp[j++]=rgrl ;
                                        pv[j]=0xD5 ; pp[j++]=ddrl ;
        pc[i]="INC"   ; px[i++]=j ;     pv[j]=0x04 ; pp[j++]=accm ;
                                        pv[j]=0xA3 ; pp[j++]=dptr ;
                                        pv[j]=0x06 ; pp[j++]=indr ;
                                        pv[j]=0x08 ; pp[j++]=regr ;
                                        pv[j]=0x05 ; pp[j++]=dadr ;
        pc[i]="JB"    ; px[i++]=j ;     pv[j]=0x20 ; pp[j++]=barl ;
        pc[i]="JBC"   ; px[i++]=j ;     pv[j]=0x10 ; pp[j++]=barl ;
        pc[i]="JC"    ; px[i++]=j ;     pv[j]=0x40 ; pp[j++]=rela ;
        pc[i]="JMP"   ; px[i++]=j ;     pv[j]=0x73 ; pp[j++]=apdp ;
                                        pv[j]=0x01 ; pp[j++]=adrx ;
        pc[i]="JNB"   ; px[i++]=j ;     pv[j]=0x30 ; pp[j++]=barl ;
        pc[i]="JNC"   ; px[i++]=j ;     pv[j]=0x50 ; pp[j++]=rela ;
        pc[i]="JNZ"   ; px[i++]=j ;     pv[j]=0x70 ; pp[j++]=rela ;
        pc[i]="JSR"   ; px[i++]=j ;     pv[j]=0x11 ; pp[j++]=adrx ;
        pc[i]="JZ"    ; px[i++]=j ;     pv[j]=0x60 ; pp[j++]=rela ;
        pc[i]="LCALL" ; px[i++]=j ;     pv[j]=0x12 ; pp[j++]=adrl ;
        pc[i]="LJMP"  ; px[i++]=j ;     pv[j]=0x02 ; pp[j++]=adrl ;
        pc[i]="MOV"   ; px[i++]=j ;     pv[j]=0x74 ; pp[j++]=acim ;
                                        pv[j]=0xE6 ; pp[j++]=acir ;
                                        pv[j]=0xE8 ; pp[j++]=acrg ;
                                        pv[j]=0xE5 ; pp[j++]=acdd ;
                                        pv[j]=0x90 ; pp[j++]=dpim ;
                                        pv[j]=0xA2 ; pp[j++]=cfba ;
                                        pv[j]=0xF6 ; pp[j++]=irac ;
                                        pv[j]=0x76 ; pp[j++]=irim ;
                                        pv[j]=0xA6 ; pp[j++]=irdd ;
                                        pv[j]=0xF8 ; pp[j++]=rgac ;
                                        pv[j]=0x78 ; pp[j++]=rgim ;
                                        pv[j]=0xA8 ; pp[j++]=rgdd ;
                                        pv[j]=0xF5 ; pp[j++]=ddac ;
                                        pv[j]=0x92 ; pp[j++]=bacf ;
                                        pv[j]=0x75 ; pp[j++]=ddim ;
                                        pv[j]=0x86 ; pp[j++]=ddir ;
                                        pv[j]=0x88 ; pp[j++]=ddrg ;
                                        pv[j]=0x85 ; pp[j++]=dddd ;
        pc[i]="MOVC"  ; px[i++]=j ;     pv[j]=0x93 ; pp[j++]=acad ;
                                        pv[j]=0x83 ; pp[j++]=acap ;
        pc[i]="MOVX"  ; px[i++]=j ;     pv[j]=0xE0 ; pp[j++]=acid ;
                                        pv[j]=0xE2 ; pp[j++]=acir ;
                                        pv[j]=0xF0 ; pp[j++]=idac ;
                                        pv[j]=0xF2 ; pp[j++]=irac ;
        pc[i]="MUL"   ; px[i++]=j ;     pv[j]=0xA4 ; pp[j++]=abac ;
        pc[i]="NOP"   ; px[i++]=j ;     pv[j]=0x00 ; pp[j++]=nopr ;
        pc[i]="ORL"   ; px[i++]=j ;     pv[j]=0x44 ; pp[j++]=acim ;
                                        pv[j]=0x46 ; pp[j++]=acir ;
                                        pv[j]=0x48 ; pp[j++]=acrg ;
                                        pv[j]=0x45 ; pp[j++]=acdd ;
                                        pv[j]=0x72 ; pp[j++]=cfba ;
                                        pv[j]=0xA0 ; pp[j++]=cfcb ;
                                        pv[j]=0x42 ; pp[j++]=ddac ;
                                        pv[j]=0x43 ; pp[j++]=ddim ;
        pc[i]="POP"   ; px[i++]=j ;     pv[j]=0xD0 ; pp[j++]=dadr ;
        pc[i]="PUSH"  ; px[i++]=j ;     pv[j]=0xC0 ; pp[j++]=dadr ;
        pc[i]="RET"   ; px[i++]=j ;     pv[j]=0x22 ; pp[j++]=nopr ;
        pc[i]="RETI"  ; px[i++]=j ;     pv[j]=0x32 ; pp[j++]=nopr ;
        pc[i]="RL"    ; px[i++]=j ;     pv[j]=0x23 ; pp[j++]=accm ;
        pc[i]="RLC"   ; px[i++]=j ;     pv[j]=0x33 ; pp[j++]=accm ;
        pc[i]="RR"    ; px[i++]=j ;     pv[j]=0x03 ; pp[j++]=accm ;
        pc[i]="RRC"   ; px[i++]=j ;     pv[j]=0x13 ; pp[j++]=accm ;
        pc[i]="SETB"  ; px[i++]=j ;     pv[j]=0xD3 ; pp[j++]=cflg ;
                                        pv[j]=0xD2 ; pp[j++]=bita ;
        pc[i]="SJMP"  ; px[i++]=j ;     pv[j]=0x80 ; pp[j++]=rela ;
        pc[i]="SUBB"  ; px[i++]=j ;     pv[j]=0x94 ; pp[j++]=acim ;
                                        pv[j]=0x96 ; pp[j++]=acir ;
                                        pv[j]=0x98 ; pp[j++]=acrg ;
                                        pv[j]=0x95 ; pp[j++]=acdd ;
        pc[i]="SWAP"  ; px[i++]=j ;     pv[j]=0xC4 ; pp[j++]=accm ;
        pc[i]="XCH"   ; px[i++]=j ;     pv[j]=0xC8 ; pp[j++]=acrg ;
                                        pv[j]=0xC5 ; pp[j++]=acdd ;
                                        pv[j]=0xC6 ; pp[j++]=acir ;
        pc[i]="XCHD"  ; px[i++]=j ;     pv[j]=0xD6 ; pp[j++]=acir ;
        pc[i]="XRL"   ; px[i++]=j ;     pv[j]=0x64 ; pp[j++]=acim ;
                                        pv[j]=0x66 ; pp[j++]=acir ;
                                        pv[j]=0x68 ; pp[j++]=acrg ;
                                        pv[j]=0x65 ; pp[j++]=acdd ;
                                        pv[j]=0x62 ; pp[j++]=ddac ;
                                        pv[j]=0x63 ; pp[j++]=ddim ;
                         px[i] = j ;
        return i ;
}

/*
        End of 51SYM.C
*/

