/******************************************************************************
* Module    :   Post --- Create a multi-file, uuencoded USENET News posting
*               from a binary file.
*
* Author    :   John W. M. Stevens
*
* Notes     :   The Subject: line format has been designed to be easily
*               parsed.  This format is the most efficient to use.
******************************************************************************/

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>

#include    "post.h"

/*********************************** Globals *********************************/
int 	MsDosFileNms = 1;
char    *Version = "POST V1.1.0";
/*****************************************************************************/

/*-----------------------------------------------------------------------------
| Routine   :   ShowSynopsis() --- Show a summary of the command line
|               syntax.
-----------------------------------------------------------------------------*/

static  char    *Synopsis[] =
{
"--- Create Multi-Part Postings from a Binary File.\n\n",
"Options:\n",
"    -a  Make anonymous posting (Not Working).\n",
"    -d  Name of description file.\n",
"    -e  Execute a command for each part file.\n",
"    -f  Modify file names to be MS-DOS and USENET conformant.\n",
"    -h  Name of USENET header information file.\n",
"    -r  Repost flag.  This is an attempted repost.\n",
"    -m  Use EMail header.\n",
"    -n  Use USENET news header.\n",
"    -t  For erotic pictures only, type of activity in picture:\n",
"           b - Beastiality.\n",
"           f - Female, no lesbianism.\n",
"           g - Gay, male homosexual sex.\n",
"           h - Heterosexual sex.\n",
"           l - Lesbianism, female homosexual sex.\n",
"           m - Male, no homosexual activity.\n",
"           t - Tied up. (bondage).\n",
"    -v  Show version number and quit.\n\n",
"Example:\n",
"    post -e \"sndnews news-1.csn.net #\" -t f -r ds-f-025.gif\n",
NULL
};

static
void    ShowSynopsis(void)
{
    register    int     i;

	printf("%s ", Version);
    for (i = 0; Synopsis[i]; i++)
        printf( Synopsis[i] );
}

/*-----------------------------------------------------------------------------
| Routine   :   CmdLineParse() --- Parse the command line.
|
| Inputs    :   argc    - Number of command line arguments.
|               argv    - List of command line argument strings.
|               SwList  - Switch list.
-----------------------------------------------------------------------------*/

static
void    CmdLineParse(int        argc,
                     char       **argv,
                     char       *SwList)
{
    register    int         i;
    auto        char        *ArgPtr;
    auto        char        *SwPtr;
    auto        char        SwChar;
    auto        BIN_DATA    BinData;
    auto        FILE        *HdrFl;
    auto        FILE        *DescFl;
	static		char		CmdBfr[BFR_SZ];

    /*  Initialize the binary data structure.   */
    BinData.RepostFlag = 0;
    BinData.PictAction = PT_NONE;
	*CmdBfr = '\0';

    /*  Scan entire command line.   */
    HdrFl = DescFl = stdin;
    for (i = 1; i < argc; i++)
    {
        /*  Get a pointer to the argument.  */
        ArgPtr = argv[i];

        /*  Is this a switch?   */
        if (*ArgPtr == '-')
        {
            /*  Get switch character.   */
            if ((SwChar = *++ArgPtr) == '\0')
            {
                /*  There is no character after the switch marker,
                *   so declare an error.
                */
                ShowSynopsis();
                exit( 1 );
            }
            else if ((SwPtr = strchr(SwList, SwChar)) == NULL)
            {
                /*  Error, this is evidently an illegal switch
                *   character.
                */
                ShowSynopsis();
                exit( 1 );
            }
            else if (SwPtr[1] == '>')
            {
                /*  Get parameter string.  Parameter string can
                *   follow immediately after the switch character,
                *   or it can be the next command line string.
                */
                if (*++ArgPtr == '\0')
                {
                    /*  Next command line parameter is switch
                    *   parameter string.
                    */
                    if (i + 1 < argc)
                        ArgPtr = argv[++i];
                    else
                    {
                        ShowSynopsis();
                        exit( 1 );
                    }
                }
            }
            else
                ArgPtr++;
        }
        else
            SwChar = ' ';

        /*  Have argument processed.    */
        switch ( SwChar )
        {
        case 'a':
            ShowSynopsis();
            exit( 1 );
            break;
        case 'd':
            if (*ArgPtr == '-')
                DescFl = stdin;
            else if ((DescFl = fopen(ArgPtr, "r")) == NULL)
            {
                fprintf(stderr,
                        "%s %d : Error - Could not open file '%s' for "
                        "reading.\n",
                        __FILE__,
                        __LINE__,
                        ArgPtr);
                exit( 1 );
            }
            break;
		case 'e':
			/*	Get the string to execute.	*/
			if ( *ArgPtr )
				strcpy(CmdBfr, ArgPtr);
			else
			{
                fprintf(stderr,
                        "%s %d : Error - Missing command string to execute.\n",
                        __FILE__,
                        __LINE__);
                exit( 1 );
			}
			break;
        case 'f':
            if (*ArgPtr == '-')
                MsDosFileNms = 0;
            else
                MsDosFileNms = 1;
            break;
        case 'h':
            if (*ArgPtr == '-')
                HdrFl = stdin;
            else if ((HdrFl = fopen(ArgPtr, "r")) == NULL)
            {
                fprintf(stderr,
                        "%s %d : Error - Could not open file '%s' for "
                        "reading.\n",
                        __FILE__,
                        __LINE__,
                        ArgPtr);
                exit( 1 );
            }
            break;
		case 'm':
			HdrType( SwChar );
			break;
		case 'n':
			HdrType( SwChar );
			break;
        case 'r':
            BinData.RepostFlag = TRUE;
            break;
        case 't':
            /*  Get picture action type.    */
            switch ( *ArgPtr )
            {
            case 'b': /*    Beastiality.    */
                BinData.PictAction = PT_BEAST;
                break;
            case 'f': /*    Female, no lesbianism.  */
                BinData.PictAction = PT_FEMALE;
                break;
            case 'g': /*    Gay, male homosexual sex.   */
                BinData.PictAction = PT_GAY;
                break;
            case 'h': /*    Heterosexual sex.   */
                BinData.PictAction = PT_BOTH;
                break;
            case 'l': /*    Lesbianism, female homosexual sex.  */
                BinData.PictAction = PT_LESBIAN;
                break;
            case 'm': /*    Male, no homosexual activity.   */
                BinData.PictAction = PT_MALE;
                break;
            case 't': /*    Bondage (tied up).  */
                BinData.PictAction = PT_BONDAGE;
                break;
            }
            break;
		case 'v':
			printf("%s\n", Version);
			exit( 0 );
        case ' ':
			/*	UUencode and split.	*/
            Split(ArgPtr, HdrFl, DescFl, &BinData, CmdBfr);

            /*  Initialize the binary data structure.   */
            BinData.RepostFlag = 0;
            BinData.PictAction = PT_NONE;
            break;
        default:
            ShowSynopsis();
            exit( 1 );
        }
    }
}

int	    main(int    argc,
             char   **argv)
{
    /*  Parse command line parameters.  */
	if (argc >= 2)
		CmdLineParse(argc, argv, "ad>e>fh>mnrt>v");
	else
		ShowSynopsis();
    return( 0 );
}
