/******************************************************************************
* Module    :   Post header file.
*
* Author    :   John W. M. Stevens
******************************************************************************/

/*  Global constants.   */
#define TRUE    1
#define ERROR   1
#define MATCH   1
#define FALSE   0
#define OK      0

#define MAX_PATH            256
#define BFR_SZ              256
#define BYTES_PER_LINE      45
#define LINES_PER_PART      950

typedef unsigned    char    BYTE;

/*  Generic picture activity.
*   This must remain zero based, values separated by one, because these
*   values are used to index a table in split.c that provides string
*   values for constructing the Subject: line.
*/
typedef enum    {
    PT_NONE,        /*  For not a picture, or do not print type.            */
    PT_FEMALE,      /*  One or more women, not engaged in sexual activity.  */
    PT_MALE,        /*  One or more men, not engaged in sexual activity.    */
    PT_LESBIAN,     /*  Two or more women, lesbian action.                  */
    PT_GAY,         /*  Two or more men, gay action.                        */
    PT_BEAST,       /*  Sexual activity involving animals.                  */
    PT_BOTH,        /*  Heterosexual intercourse.                           */
    PT_BONDAGE      /*  Bondage, male or female.                            */
} PICT_ACT;

/*  Post type.  */
typedef struct  {
    PICT_ACT    PictAction;             /*  Type of picture action.         */
    int         RepostFlag;             /*  Is this a repost, or not?       */
} BIN_DATA;

/*  Define binary file type enumerations.   */
typedef enum
{
    UNKNOWN_TYPE,
    GIF87A,
    GIF89A,
    JFIF_JPEG,
    HSI1_JPEG
} BIN_TYPES;

/*  Function prototypes.    */
extern
void    Split(char      *FlName,
              FILE      *HdrFl,
              FILE      *DescFl,
              BIN_DATA  *BinData,
			  char		*CmdBfr);
extern
void    StripExt(char   *FlName,
                 char   *OutFlNm);
extern
void    BaseName(char   *FlName,
                 char   *BaseName);
extern
int     ModifyFlNm(char         *FlName,
                   BIN_TYPES    FileType,
                   char         *Exten,
                   char         *OutName);
extern
void    Encode(FILE     *BinFlPtr,
               FILE     *PartFlPtr,
               long     Lines);
extern
BIN_TYPES   IdBinFile(FILE  *FlPtr,
                      char  *ext);
extern
void	HdrType(char	SwChar);
