/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1992, 1993 Ralf Brown		*/
/*			All Rights Reserved.				*/
/*									*/
/*	File DVGUI.H	Types and Prototypes for UI* functions		*/
/*									*/
/************************************************************************/
/* LastEdit: 1/10/93							*/

#ifndef __DVGUI_H
#define __DVGUI_H

#ifndef __DVGLUE_H
#include "dvglue.h"
#endif /* __DVGLUE_H */


/*======================================================================*/
/*	       Constants for UImenu() and type DVMENU_ITEM	        */
/*======================================================================*/

/* types of menu items */
#define M_END	    0	/* marks end of array of menu items */
#define M_IGNORE    1	/* ignore this entry.  Useful for "commenting out" */
#define M_TEXT	    2	/* descriptive text, not a selection */
#define M_CENTER    3	/* centered text, not a selection */
#define M_SEP	    4	/* separator line, item.key1 is replicated */
#define M_FLAG	    5	/* set/clear flag variable */
#define M_FUNC	    6	/* invoke a function */
#define M_FUNCMENU  7	/* invoke a function, keep menu(s) visible */
#define M_SUBMENU   8	/* invoke a submenu displayed relative to orig menu */
#define M_SUBMENUR  9	/* invoke a submenu which replaces the original one */
#define M_QUIT	   10	/* quit current menu when selected */
#define M_TYPE_MASK 0x0F

/* combine one of the above with any combination of the below (not all item */
/* types accept all of the flags) */
#define M_EXIT	   0x10 /* exit menu after performing function or setting flag */
#define M_HOT      0x20 /* menu key without a visible entry */
#define M_HI	   0x40 /* highlight line */
#define M_SEL	   0x40 /* select M_FLAG entry by default */
#define M_KEY	   0x80 /* text after last blank is right-justified as menu key */
#define M_FLAG_MASK 0xF0

/* actions returned by menu function, may be ORed together */
#define MA_REDO   0
#define MA_DONE	  0	/* successful       \ 			 */
#define MA_EXIT	  1	/* return to caller  >mutually exclusive */
#define MA_ABORT  2	/* abort all menus  /                    */
#define MA_BEEP	  4	/* beep, then do anything else indicated */
#define MA_RESET  8	/* reset all "selected" bits */
#define MA_SELECT 16	/* change "selected" bits to reflect changed values */

/* errors returned by UImenu() */
#define ME_OK	      0   /* no error */
#define ME_NOMEM     -1   /* unable to allocate memory */
#define ME_RESOURCE  -2	  /* unable to allocate needed resource(s) */
#define ME_TOOBIG    -3   /* menu wouldn't fit on screen */
#define ME_BADITEM   -4   /* bad entry in array of menu items */


/*======================================================================*/
/*                          Types for UImenu()				*/
/*======================================================================*/

typedef int pascal (*DVMENU_FUNC)(OBJECT window,int status,char *results,long arg) ;

typedef struct
   {
   char *entry ;
   char type ;
   BYTE key1 ;
   BYTE key2 ;
   BYTE selected ;
   DVMENU_FUNC func ;
   long arg ;
   } DVMENU_ITEM ;

typedef struct _DVMENU_
   {
   char *title ;
   DVMENU_ITEM *items ;
   int row ;
   int col ;
   void (*before)(struct _DVMENU_ *menu) ;
   void (*after)(struct _DVMENU_ *menu) ;
   int (*cancel)(OBJECT window,int status,char *results) ;
   int (*error)(struct _DVMENU_ *menu,OBJECT window,int errcode) ;
   char allow_kbd ;
   char allow_oversize ;
   char allow_move ;
   char reset ;
   char marker ;
   char text_color ;
   char select_color ;
   } DVMENU ;

/*======================================================================*/
/*	       Constants for UIform() and type DVFORM_FIELD		*/
/*======================================================================*/

/* field types */
#define	F_END		 0	/* end of field list */
#define F_IGNORE	 1	/* disabled field */
#define F_OUT		 2	/* output field */
#define F_HOTKEY	 3	/* hotkey, no visible field */
#define F_SUBFORM	 4	/* invoke another form in separate window */
#define F_SUBFORMR	 5	/* invoke another form in current window */
#define F_SELECT	 6	/* selection field */
#define F_RADIO		 7	/* radio button, field.minsize = button set */
#define F_BOOL		 8	/* boolean (one char: Y or N) */
#define F_CHAR		 9	/* single char, field.format specs valid chars */
#define F_DECIMAL	10	/* unsigned decimal number */
#define F_SDECIMAL	11	/* signed decimal number */
#define F_HEX		12	/* hex number */
#define F_ALPHA		13	/* string of alphabetic characters */
#define F_STRING	14	/* string, field.format is valid characters */
#define F_FILENAME	15	/* MSDOS filename */
#define F_PATHNAME	16	/* MSDOS pathname */
#define F_CUSTOM	17	/* custom, field.format is picture of valid format */
#define F_US_PHONE	18	/* US phone number */
#define F_US_STATE	19	/* 2-letter state code */
#define F_ZIP		20	/* ZIP5 or ZIP9 */
#define F_ZIP5		21	/* US 5-digit ZIP code */
#define F_ZIP9		22	/* US 9-digit ZIP+4 code (requires 10-char field) */
#define F_ZIP_CANADA	23	/* Canadian postal code */
#define F_ZIP_UK	24	/* UK postal code */
#define F_ZIP_GERMANY	25	/* German postal code */

/* return values for validation function */
#define FA_DONE		0	/* field value is OK */
#define FA_REDO		1	/* invalid entry, retry */
#define FA_ABORT	2	/* terminate form */

/* status/errors returned by UIform() and UIform_process() */
#define FE_OK		 0	/* completed successfully */
#define FE_MORE		 1	/* not done yet, call UIform_process() */
#define FE_NOMEM	-1	/* out of memory */
#define FE_RESOURCE	-2	/* unable to allocate needed resource(s) */
#define FE_TOOBIG	-3	/* form wouldn't fit on screen, or >255 fields */
#define FE_BADITEM	-4	/* bad entry in array of fields */
#define FE_INVALID	-5	/* bad function argument */

/*======================================================================*/
/*			    Types for UIform()				*/
/*======================================================================*/

typedef struct
   {
   char type, width, height, minsize ;
   int flags ;
   char *format ;	/* valid chars for F_CHAR/F_STRING
   void *var ;
   int (*validate)(struct _DVFORM_ *form,OBJECT window,int field) ;
   } DVFORM_FIELD ;
   
typedef struct _DVFORM_
   {
   char *title ;
   char *text ;
   DVFORM_FIELD *fields ;
   int row, col ;
   void far (*filter)(void) ;
   char separate_window ;
   char esc_char ;	/* character introducing field number in text */
   } DVFORM ;

/*======================================================================*/
/*		Signal-handling constants and types			*/
/*======================================================================*/

typedef void pascal (*DVSIGNAL_HANDLER)(OBJECT window,NOTIFY_MSG *msg,long arg) ;

typedef struct
   {
   int signal ;
   DVSIGNAL_HANDLER func ;
   } SIGNAL_LIST ;

#define DVSIG_ADD	0
#define DVSIG_REMOVE	1

#define DVSIG_OK	0
#define DVSIG_ERROR	-1
#define DVSIG_NOMEM	-2
#define DVSIG_STACK	-3
#define DVSIG_NOTFOUND	-4
#define DVSIG_MAXID	32767

/*======================================================================*/
/*		the user-interface function calls			*/
/*======================================================================*/

OBJECT pascal UIwin_open(OBJECT parent,int minrows,int mincols,
			 int maxrows,int maxcols,int defrows,int defcols) ;
int pascal UIsignal(OBJECT window,int direction,int num_signals,
		    SIGNAL_LIST *signals,long arg,int stacksize) ;
int pascal UImenu(DVMENU *menu) ;
int pascal UIform(DVFORM *form,OBJECT window,int parallel,void **form_data) ;
int pascal UIform_process(void *form_data) ;

#endif /* __DVGUI_H */
