;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File PRINTF.ASM		Formatted output to a window		*
;*									*
;************************************************************************
;LastEdit: 12/20/92

	INCLUDE API.INC
	MIN_VERSION 2,00

	Header@

;========================================================================

; this version does all that the BC++ printf() does except:
;	floating point formats %e %f %g %E %G
;	incorrectly handles # flag together with zero-padding on %x %X %b %B
; additionally does:
;	%b	print integer in binary
;	%B	same as %lb
;	%D	same as %ld
;	%I	same as %li
;	%O	same as %lo
;	%U	same as %lu

;========================================================================

MAXDIGITS equ 34			; 32-bits in binary + sign + NUL

FLG_MINUS equ 01h
FLG_PLUS  equ 02h
FLG_BLANK equ 04h
FLG_SHARP equ 08h
FLG_ZERO  equ 10h

;========================================================================

lodsb_es	MACRO
IF LDATA
	db	26h			; ES: segment override
ENDIF
	lodsb
		ENDM

;========================================================================

DSeg@
no_floats db "DVprintf() does not support floating point."
no_floats_len equ $-no_floats
DSegEnd@

;========================================================================

CSeg@

ExtProc@ DVWIN_WRITE,__PASCAL__
ExtProc@ DVWIN_REPCHAR,__PASCAL__
extrn $DVG$HEX_WORD:near
extrn $DVG$STRLEN_DXAX:near

;------------------------------------------------------------------------

PubProc@ DVprintf,__CDECL__
@win = dword ptr [bp+SendOverhead]
@fmt = DPTR_ [bp+SendOverhead+4]
@first = SendOverhead+4+dPtrSize
; local variables
@pad = byte ptr [bp-1]
@flags = byte ptr [bp-2]
@radix = byte ptr [bp-3]
@size = byte ptr [bp-4]
@lowcase = byte ptr [bp-5]
; [bp-6] not used
@val = dword ptr [bp-10]
@width = word ptr [bp-12]
@precis = word ptr [bp-14]
@length = word ptr [bp-16]
@count = word ptr [bp-18]
@ascbuf = byte ptr [bp-18-MAXDIGITS]
	@EnterSend 18+MAXDIGITS
	push	si
	mov	@count,0
	mov	di,@first		; address first value to be printed
	LES_	si,@fmt
printf_loop:
	mov	bx,si
	xor	cx,cx
normal_loop:
	lodsb_es
	inc	cx
	or	al,al
	jz	normal_loop_done
	cmp	al,10			; \n ?
	jz	normal_loop_done
	cmp	al,'%'
	jnz	normal_loop
normal_loop_done:
	dec	si			; went one char too far
	dec	cx
	jz	printed_normal
	PUSHMEM32 @win
	PUSHDPTR es,bx			; string to display
	push	cx			; length
	add	@count,cx		; accumulate total # chars displayed
	call	DVWIN_WRITE@
printed_normal:
	lodsb_es
	or	al,al			; either NUL, LF, or '%'
	jz	printf_done
	cmp	al,'%'
	jz	do_conv_spec
	mov	ax,0A0Dh
	mov	cx,2
	jmp short print_CRLF
printf_done:
	pop	si
	@ExitSend

do_conv_spec:
	lodsb_es			; get next char
	cmp	al,'%'
	jne	not_percent
print_char:
	mov	cx,1
print_CRLF:
	mov	word ptr @ascbuf,ax
	PUSHMEM32 @win
	lea	bx,@ascbuf
	PUSHDPTR ss,bx
	push	cx			; number of characters to display
	add	@count,cx		; accumulate total # chars displayed
	call	DVWIN_WRITE@
	jmp	printf_loop
not_percent:
	mov	@pad,' '		; default pad character is blank
	mov	ah,0			; @flags defaults to 0
check_flags:
	cmp	al,'-'
	jne	not_minus
	or	ah,FLG_MINUS
	jmp short has_flag
not_minus:
	cmp	al,'+'
	jne	not_plus
	or	ah,FLG_PLUS
	jmp short has_flag
not_plus:
	cmp	al,' '
	jne	not_blank
	or	ah,FLG_BLANK
	jmp short has_flag
not_blank:
	cmp	al,'#'
	jne	not_flag
	or	ah,FLG_SHARP
has_flag:
	lodsb_es			; used up minus, so get next char
	jmp	check_flags
not_flag:
	cmp	al,'0'
	jne	not_zero
	or	ah,FLG_ZERO
	lodsb_es			; used up zero, so get next char
not_zero:
	mov	@flags,ah		; finally done checking flags, so store
	xor	cx,cx			; assume default (zero) width
	mov	bx,10
	cmp	al,'*'			; variable width?
	jne	not_varwidth
	lodsb_es			; used up asterisk, so get next char
	mov	cx,word ptr [bp+di]	; get next 'int' from stack
	inc	di
	inc	di
	jmp short got_width
not_varwidth:
;	mov	bx,10 ;(BX still 10 from above)
get_width_loop:
	cmp	al,'0'
	jb	got_width
	cmp	al,'9'
	ja	got_width
	and	ax,000Fh		; extract digit from ASCII char
	xchg	cx,ax			; CX <- new digit, AX <- prev width
	mul	bx			; previous width * 10
	add	ax,cx			; plus new digit
	mov	cx,ax			; store new width into CX
	lodsb_es			; used up digit, so get next char
	jmp	get_width_loop
got_width:
	test	@flags,FLG_MINUS
	jz	got_width2
	neg	cx			; if '-' flag given, negate width
got_width2:
	mov	@width,cx
	xor	cx,cx			; assume zero (default) precision
	cmp	al,'.'
	jne	got_precision
	lodsb_es			; used up period, so get next char
	cmp	al,'*'
	jne	not_varprecis
	lodsb_es			; used up asterisk, so get next char
	mov	cx,word ptr [bp+di]	; get next 'int' from stack
	inc	di
	inc	di
	jmp short got_precision
not_varprecis:
;	mov	bx,10 ;(BX still 10 from above)
get_precis_loop:
	cmp	al,'0'
	jb	got_precision
	cmp	al,'9'
	ja	got_precision
	and	ax,000Fh		; extract digit from ASCII char
	xchg	cx,ax			; CX <- new digit, AX <- prev width
	mul	bx			; previous width * 10
	add	ax,cx			; plus new digit
	mov	cx,ax			; store new width into CX
	lodsb_es			; used up digit, so get next char
	jmp	get_precis_loop
got_precision:
	mov	@precis,cx
	mov	@size,0			; assume no size modifier
	cmp	al,'h'
	je	has_sizemod
	cmp	al,'l'
	je	has_sizemod
	cmp	al,'N'
	je	has_sizemod
	cmp	al,'F'
	jne	got_sizemod
has_sizemod:
	mov	@size,al
	lodsb_es			; used up modifier, so get next char
got_sizemod:
	mov	@lowcase,20h		; assume lowercase letters in hex numbers
	mov	cl,10			; radix 10
	lea	bx,@ascbuf		; where to store converted number
	cmp	al,'d'
	je	print_integer
	cmp	al,'i'
	je	print_integer
	cmp	al,'D'
	je	print_long
	cmp	al,'I'
	je	print_long
	cmp	al,'u'
	je	print_unsigned
	cmp	al,'U'
	je	print_ulong
	mov	cl,8			; octal
	cmp	al,'o'
	je	print_unsigned
	cmp	al,'O'
	je	print_ulong
	mov	cl,16			; hexadecimal
	cmp	al,'x'
	je	print_unsigned
	mov	@lowcase,0		; uppercase letters in hex number
	cmp	al,'X'
	je	print_unsigned
	mov	cl,2			; binary
	cmp	al,'b'
	je	print_unsigned
	cmp	al,'B'
	je	print_ulong
	jmp	not_integer

print_integer:
	cmp	@size,'l'		; ld, lo, etc. print a DWORD, everything
	je	print_long		;   else prints a WORD
print_short:
	mov	ax,[bp+di]		; get next 'int' from stack
	cwd				; sign-extend to 32-bits
	jmp short print_int

print_long:
	mov	ax,[bp+di]		; get next 'long' from stack
	inc	di
	inc	di			; adjust for second word of argument
	mov	dx,[bp+di]
	jmp short print_int

print_unsigned:
	cmp	@size,'l'		; lu prints a DWORD, u & hu print a WORD
	je	print_ulong
print_ushort:
	mov	ax,[bp+di]		; get next 'int' from stack
	xor	dx,dx			; zero-extend to 32 bits
	jmp short print_uns_common

print_ulong:
	mov	ax,[bp+di]		; get next 'long' from stack
	inc	di
	inc	di			; adjust for second word of argument
	mov	dx,[bp+di]
print_uns_common:
	cmp	cl,10			; # ignored for decimal numbers
	je	print_pos_int
	test	@flags,FLG_SHARP
	jz	print_pos_int
	cmp	cl,8			; octal puts on prefix only if nonzero
	jne	print_uns_radix16
	or	dx,dx
	jnz	print_pos_int
	or	ax,ax
	jnz	print_pos_int
	mov	byte ptr SS_[bx],'0'
	inc	bx
	jmp short print_pos_int

print_uns_radix16:
	mov	word ptr SS_[bx],'0X'
	inc	bx
	mov	ch,@lowcase
	or	byte ptr SS_[bx],ch
	inc	bx
	cmp	cl,2
	jne	print_pos_int
	mov	byte ptr SS_[bx-1],'b'
	jmp short print_pos_int

print_int:
	or	dx,dx			; negative number?
	js	print_neg_int
	test	@flags,FLG_PLUS		; precede positive numbers with a plus?
	jz	print_int_blank
	mov	byte ptr SS_[bx],'+'
	inc	bx
	jmp short print_pos_int

print_int_blank:
	test	@flags,FLG_BLANK	; precede positive numbers with a blank?
	jz	print_pos_int
	mov	byte ptr SS_[bx],' '
	inc	bx
	jmp short print_pos_int

print_neg_int:
	neg	dx			; negate the number
	neg	ax
	sbb	dx,0
	mov	byte ptr SS_[bx],'-'
	inc	bx
print_pos_int:
	inc	di			; adjust for one word of arguments
	inc	di
	push	si
	push	bx			; remember start address
	mov	si,bx
	mov	bx,dx			; BX:AX <- number to convert
	mov	word ptr SS_[si],'0'	; default
	mov	ch,0			; zero-extend radix
int_loop:
	or	ax,ax
	jnz	int_convert
	or	bx,bx
	jz	int_loop_done
int_convert:
	xchg	ax,bx			; put aside low word of number
	xor	dx,dx			; DX:AX <- high word of number
	div	cx			; AX = high/divis, DX = rem(high/div)
	xchg	ax,bx			; get back low word of number
	div	cx			; AX = low/divis, DX = rem(high/div)
	push	ax
	mov	ax,dx
	add	al,90h			; convert low nybble to hex digit
	daa
	adc	al,40h
	daa
	or	al,@lowcase		; optionally force lowercase
	mov	ah,0
	mov	SS_[si],ax		; and store digit
	pop	ax			; retrieve low word of interim result
	inc	si
	jmp	int_loop
int_loop_done:
	pop	bx			; get back start address of buffer
	dec	si
reverse_loop:
	cmp	bx,si
	jae	reverse_done
	mov	al,SS_[bx]
	xchg	al,SS_[si]
	mov	SS_[bx],al
	inc	bx
	dec	si
	jmp	reverse_loop
reverse_done:
	pop	si
	test	@flags,FLG_ZERO		; did user request zero-padding?
	jz	print_number_string
	mov	@pad,'0'		; pad with zeros on left
	jmp short print_number_string

not_integer:
	cmp	al,'c'
	jne	not_char
	mov	al,[bp+di]		; get the argument
	inc	di			; and discard it
	inc	di
	mov	ah,0
	mov	word ptr @ascbuf,ax
print_number_string:
print_pointer_string:
	lea	ax,@ascbuf
	mov	dx,ss
	jmp short print_string

not_char:
	cmp	al,'s'
	je	is_string
	jmp	not_string

is_string:
	mov	ax,[bp+di]		; get next 'char*' off stack
	inc	di
	inc	di			; used up a word of arguments
	mov	dx,ds			; assume near string
IF LDATA
	cmp	@size,'N'
	je	print_near_string
ELSE
	cmp	@size,'F'
	jne	print_near_string
ENDIF
print_far_string:
	mov	dx,[bp+di]
	inc	di
	inc	di			; used up another word of arguments
print_near_string:
print_string:
;	int length = strlen(str) ;
;	if ( precis > 0  && precis < length) 
;		 length = precis ;
;	if ( width > length )
;	    repchar(win,padchar,width-length) ;
;	win_write(win,str,length) ;
;	if ( width < 0 )
;	    repchar(win,padchar,-width-length) ;
	pushm	dx,ax			; remember address of string
	call	$DVG$STRLEN_DXAX
	;; don't adjust stack, still need stacked args
	mov	bx,@precis
	or	bx,bx
	jle	ps_def_length
	cmp	bx,ax			; precision < length ?
	jae	ps_def_length
	mov	ax,bx			; length <- precision
ps_def_length:
	mov	@length,ax
	cmp	ax,@width
	jge	no_left_pad
	PUSHMEM32 @win
	mov	bl,@pad
	push	bx
	sub	ax,@width
	neg	ax			; adjust for doing sub the wrong way
	push	ax
	add	@count,ax		; accumulate total # chars displayed
	call	DVWIN_REPCHAR@
no_left_pad:
	popm	ax,dx			; get back address of string
	pushm	es,di			; store ES & DI, which are mod by SEND_N
	pushm	dx,ax			; address of string to display
	xor	bx,bx
	mov	ax,@length
	add	@count,ax		; accumulate total # chars displayed
	pushm	bx,ax			; length of string to display
	SEND_N	WRITE_MSG,TOS,ME,@win	; DVwin_write
	popm	di,es			; retrieve ES and DI
	mov	ax,@width
	or	ax,ax
	jns	no_right_pad
	neg	ax			; -width
	sub	ax,@length		; -width-length
	jz	no_right_pad
	PUSHMEM32 @win
	mov	bl,' '			; always right-pad with blanks
	push	bx			; char to repeat
	push	ax			; repeat count
	add	@count,ax		; accumulate total # chars displayed
	call	DVWIN_REPCHAR@
no_right_pad:
	jmp	printf_loop

not_string:
	cmp	al,'p'
	jne	not_pointer
	mov	ax,[bp+di]		; get next pointer off stack
	inc	di
	inc	di			; adjust stack index for ofs 2B printed
	lea	bx,@ascbuf
IF LDATA
	cmp	@size,'N'
	je	print_near_pointer
ELSE
	cmp	@size,'F'
	jne	print_near_pointer
ENDIF
print_far_pointer:
	push	ax			; remember offset of pointer
	mov	ax,[bp+di]		; get pointer's segment from stack
	call	$DVG$HEX_WORD
	inc	di
	inc	di			; adjust stack index for seg just printed
	mov	byte ptr SS_[bx],':'
	inc	bx
	pop	ax			; retrieve offset of pointer
print_near_pointer:
	call	$DVG$HEX_WORD
	xor	ax,ax
	mov	byte ptr SS_[bx],al	; NUL-terminate string
	mov	@precis,ax		; don't truncate string
	jmp	print_pointer_string

not_pointer:
	cmp	al,'e'			; e,f,g are floating-point formats
	jb	not_float
	cmp	al,'g'
	jbe	is_float
	cmp	al,'E'			; as is E
	je	is_float
	cmp	al,'G'			; and G
	jne	not_float
is_float:
	mov	ah,12h
	mov	bx,0001h		; get our window handle
	int	15h
	pop	cx			; discard offset of handle
	pop	dx			; get handle's segment
	mov	ax,101Fh
	mov	bx,8000h+(0 shl 13)+no_floats_len
	mov	ch,no_floats_len	; width
	mov	cl,1			; height
;	pushm	es,di
	push	ds
	pop	es			; ES <- DS
	mov	di,offset DGROUP:no_floats
	int	15h
;	popm	di,es
	jmp	printf_done

not_float:
	cmp	al,'n'
	jne	not_get_count
	mov	ax,@count
	mov	bx,[bp+di]		; get offset of variable
	inc	di
	inc	di			; used up a word of arguments
IF LDATA
	cmp	@size,'N'
	je	get_count_near
ELSE
	cmp	@size,'F'
	jne	get_count_near
ENDIF
get_count_far:
	push	es
	mov	es,[bp+di]		; get segment of variable
	inc	di
	inc	di			; used up a word of arguments
	mov	es:[bx],ax		; store count in variable
	pop	es
	jmp	printf_loop
get_count_near:
	mov	[bx],ax			; store count in variable
	jmp	printf_loop

not_get_count:
	jmp	print_char		; output the unknown format specifier
EndProc@ DVprintf,__CDECL__

CSegEnd@

;========================================================================

	END
