/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1993 Ralf Brown			*/
/*			All Rights Reserved.				*/
/*									*/
/*	File UIFORM.C	Build, display, and process an input form	*/
/*									*/
/************************************************************************/
/* LastEdit: 1/10/93							*/

#include "dvglue.h"
#include "dvstream.h"
#include "dvgui.h"

/*======================================================================*/

typedef struct
   {
   DVFORM form ;
   OBJECT window ;
   OBJECT kbd ;
   
   } FORM_DATA ;
   
/*======================================================================*/

int pascal UIform_process(void *form_data)
{
   
/* for now */
   free(form_data) ;
   return FE_OK ;
}

/*======================================================================*/

int pascal UIform(DVFORM *form,OBJECT window,int parallel,void **form_data)
{
   int num_fields ;
   DVFORM_FIELD *field ;
   int readsize ;
   char *readbuf ;
   FORM_DATA *formdata_ptr ;
   
   if (parallel & !form_data)
      return FE_INVALID ;
   num_fields = readsize = 0 ;
   for (field = form->fields ; field->action != F_END ; field++)
      if (field->action != F_IGNORE)
	 {
	 num_fields++ ;
	 readsize += (field->width * field->height) ;
	 }
   if (num_fields > 255)
      return FE_TOOBIG ;
   if ((formdata = (FORM_DATA *)malloc(sizeof FORM_DATA)) == NULL)
      return FE_NOMEM ;
   formdata->form = *form ;
   formdata->window = window ;
   if ((readbuf = (char *)malloc(readsize)) == NULL)
      {
      free(formdata) ;
      return FE_NOMEM ;
      }
   
   if (parallel)
      {
      *form_data = formdata ;
      return FE_MORE ;
      }
   else
      {
      int retval ;
      
      while ((retval = UIform_process(formdata)) == FE_MORE)
	 ;
      return retval ;
      }
}

/* End of file UIFORM.C */
