/************************************************************************/
/*									*/
/*	DV-GLUE		DESQview and DESQview/X Function Library	*/
/*			(c) Copyright 1988, 1992 Ralf Brown		*/
/*			All Rights Reserved.				*/
/*									*/
/*	File UIWOPEN.C	Allow user to position and size a new window	*/
/*									*/
/************************************************************************/
/* LastEdit: 12/31/92							*/

#include <bios.h>
#include "dvglue.h"
#include "dvstream.h"
#include "dvgui.h"


#define OPEN_HEIGHT 15
#define OPEN_WIDTH  30

/*================================================*/
/*================================================*/

BYTE create_sizwin_stream[] = { S_WINDOW(14),
			        WS_NEWWIN(OPEN_HEIGHT,OPEN_WIDTH),
				WS_NOFRAME,
				WS_LOGATTR,
				WS_WINPOS(0,0),
				WS_LSIZE(OPEN_HEIGHT,OPEN_WIDTH),
				WS_WINSIZE(OPEN_HEIGHT,OPEN_WIDTH)
			      } ;

BYTE erase_ulc_stream[] = { S_WINDOW(11),
			    WS_CHARS(2),0,0,
			    WS_RELCURS(1,-2),
			    WS_CHARS(1),0,
			    WS_RELCURS(-1,-1)
			  } ;


/*================================================*/
/*================================================*/

static void pascal near set_kmouse(int state)
{
   if (DVqry_kmouse())
      DVapi_kmouse(state) ;
}

/*================================================*/
/*================================================*/

void static pascal near resize_window(OBJECT w,int rows,int cols)
{
   int new_rows = rows+5 ;
   int new_cols = cols+9 ;
   BYTE stream[] = { S_WINDOW(30),
		     WS_CURSPOS(0,0),
		     WS_SETCOLOR(9),
		     WS_CHARS(2),201,205,   /* dbl ul corner, dbl horiz line */
		     WS_SETCURSCOL(0),		/* patch later */
		     WS_CHARS(1),187,		/* dup ur corner */
		     WS_CURSPOS(1,0),
		     WS_CHARS(1),186,	        /* dbl vert line */
		     WS_CURSPOS(0,0),		/* patch row later */
		     WS_CHARS(1),200,		/* dbl ll corner */
		     WS_SETCURSCOL(0),		/* patch later */
	             WS_CHARS(1),188,		/* dbl lr corner */
		     WS_CURSPOS(0,0),
		     WS_REDRAW
		   } ;

   DVwin_lsize(w,new_rows,new_cols) ;
   DVwin_resize(w,new_rows,new_cols) ;
   DVwin_fill(w,0) ;  /* fill window with transparent blanks */
   stream[13] = stream[27] = cols+1 ;
   stream[22] = rows+1 ;
   DVwin_stream(w,stream) ;
}

/*================================================*/
/*================================================*/

void static pascal near draw_ul_corner(OBJECT w,int row,int col)
{
   BYTE stream[] = { S_WINDOW(19),
	            WS_CURSPOS(0,0),
		    WS_SETCOLOR(9),
		    WS_CHARS(2),201,205,   /* dbl ul corner, dbl horiz line */
		    WS_RELCURS(1,-2),
		    WS_CHARS(1),186,	   /* dbl vert line */
		    WS_SETCOLOR(1),
		    WS_RELCURS(-1,-1),
		    WS_REDRAW
                  } ;

   stream[5] = row ;
   stream[6] = col ;
   DVwin_stream(w,stream) ;
}

/*================================================*/
/*================================================*/

void static pascal near erase_ul_corner(OBJECT w)
{
   DVwin_stream(w,erase_ulc_stream) ;
}

/*================================================*/
/* UIwin_open  allow user to choose size and loc  */
/*             of a window which is to be opened  */
/*================================================*/

OBJECT pascal UIwin_open(OBJECT parent,int minrows,int mincols,
                         int maxrows,int maxcols, int defrows,int defcols)
{
   OBJECT p, w, mw ;
   int physrows, physcols ;
   int row, col ;
   int rows, cols ;
   POINTER_MSG msg ;
   int new_message, do_move ;
   int logattr = DVqry_logattr(parent) ;
   
   if (minrows < 0) minrows = 0 ;
   if (mincols < 0) mincols = 0 ;
   if (defrows < minrows) defrows = minrows ;
   if (defcols < mincols) defcols = mincols ;
   if ((w = DVwin_stream(parent,create_sizwin_stream)) == NIL)
      return NIL ;
   if ((p = DVptr_new()) == NIL)
      {
      DVwin_free(w) ;
      return NIL ;
      }
   if ((mw = DVwin_new(parent,1,32)) != NIL)
      {
      DVwin_title(mw,"Open Window") ;
      DVwin_move(mw,1,1) ;
      DVwin_cursor(mw,0,0) ;
      DVwin_swrite(mw,"Drag window to desired position") ;
      DVwin_topsys(mw) ;
      }
   DVwin_fill(w,0) ;  /* fill window with transparent blanks */
   draw_ul_corner(w,0,0) ;
   DVwin_topsys(w) ;
   DVptr_open(p,w) ;
   set_kmouse(TRUE) ;
   DVptr_setflags(p,PTR_RELEASE | PTR_HIDDEN | PTR_ABSOLUTE) ;
   if (_dvversion >= 0x0217) /* v2.23+ */
      DVptr_setflags(p,PTR_LEAVE) ;
   DVptr_goto(p,0,0) ;
   row = col = 0 ;   /* we start in upper left corner of display */
   do_move = FALSE ;
   physrows = DVphys_screen_height() ;
   physcols = DVphys_screen_width() ;
   new_message = FALSE ;
   do {
      do {
	 DVptr_read(p,&msg) ;
	 if (msg.button_state & 0x80)  /* either button pressed? */
	    break ;
	 } while (DVptr_messages(p)) ;
      if (msg.button_state == 0x82)  /* right button pressed? */
	 {
	 DVwin_free(mw) ;
	 DVwin_free(w) ;
	 DVptr_free(p) ;
	 set_kmouse(FALSE) ;
	 return NIL ;
         }
      if (msg.row == -1 && msg.column == -1)
	 {
	 int crow, ccol ;
	 
	 DVqry_cursor(w,&crow,&ccol) ;
	 DVptr_goto(p,row+crow,col+ccol) ;
	 continue ;
	 }
      if (msg.row < row+(OPEN_HEIGHT/4) && row > 0)
	 {
	 row = msg.row - OPEN_HEIGHT/2 ;
	 if (row < 0)
	    row = 0 ;
	 do_move = TRUE ;
	 }
      else if (msg.row > row+(3*OPEN_HEIGHT/4) && row < physrows-OPEN_HEIGHT)
	 {
	 row = msg.row - OPEN_HEIGHT/2 ;
	 if (row > physrows-OPEN_HEIGHT)
	    row = physrows-OPEN_HEIGHT ;
	 do_move = TRUE ;
	 }
      else if (msg.row > physrows-2)	/* keep window visible */
	 msg.row = physrows-2 ;
      if (msg.column < col+(OPEN_WIDTH/4) && col > 0)
	 {
	 col = msg.column - OPEN_WIDTH/2 ;
	 do_move = TRUE ;
	 }
      else if (msg.column > col+(3*OPEN_WIDTH/4) && col < physcols-OPEN_WIDTH)
	 {
	 col = msg.column - OPEN_WIDTH/2 ;
	 if (col > physcols-OPEN_WIDTH)
	    col = physcols-OPEN_WIDTH ;
	 do_move = TRUE ;
	 }
      else if (msg.column > physcols-2)	/* keep window visible */
	 msg.column = physcols-2 ;
      erase_ul_corner(w) ;
      if (do_move)
	 {
	 DVwin_move(w,row,col) ;
	 do_move = FALSE ;
	 if (!new_message && mw)
	    {
	    new_message = TRUE ;
	    DVwin_cursor(mw,0,0) ;
	    DVwin_swrite(mw,"Left button: done Right: cancel") ;
	    DVwin_redraw(mw) ;
	    }
	 }
      draw_ul_corner(w,msg.row-row,msg.column-col) ;
      } while (msg.button_state != 0x81) ; /* until left button pressed */
   row = msg.row ;
   col = msg.column ;
   rows = defrows ;
   cols = defcols ;
   if (mw)
      {
      DVwin_cursor(mw,0,0) ;
      DVwin_swrite(mw,"Size window and release button ") ;
      DVwin_redraw(mw) ;
      }
   DVptr_goto(p,row+rows,col+cols) ;
   DVwin_move(w,row,col) ;
   resize_window(w,rows,cols) ;
   do {
      do {
	 DVptr_read(p,&msg) ;
	 if (msg.button_state & 0x40) /* quit if a button is released */
	    break ;
	 } while (DVptr_messages(p)) ;
      if (msg.row == -1 && msg.column == -1)
	 DVptr_goto(p,row+rows+1,col+cols+1) ;
      else
	 {
	 rows = msg.row-row ;
	 cols = msg.column-col ;
	 }
      if (rows > maxrows)
	 rows = maxrows ;
      else if (rows < minrows)
	 rows = minrows ;
      if (cols > maxcols)
	 cols = maxcols ;
      else if (cols < mincols)
	 cols = mincols ;
      resize_window(w,rows,cols) ;
      } while ((msg.button_state & 0x41) != 0x41) ; /* until left button is released */
   DVwin_clear(w) ;
   DVwin_lsize(w,rows,cols) ;
   DVwin_resize(w,rows,cols) ;
   DVwin_move(w,row,col) ;
   DVwin_frame(w,TRUE) ;
   DVwin_logattr(w,logattr) ;
   DVwin_frattr(w,logattr?1:7) ;
   set_kmouse(FALSE) ;
   DVptr_free(p) ;
   DVwin_free(mw) ;
   return w ;
}

/* End of UIWOPEN.C */
