;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File XDIDVEOP.ASM	Funcs to access DVeop API		*
;*									*
;************************************************************************
;LastEdit: 12/20/92

	INCLUDE	API.INC
	MIN_VERSION 2,26

	Header@

;========================================================================

CSeg@

ExtProc@ XDIINIT,__PASCAL__

;------------------------------------------------------------------------
; entry: nothing
; exit:  CX = version
;	 DX:AX -> entrypoint
;
DVeop_entrypoint proc near
	call	XDIinit@
	push	es
	jz	no_entrypt		; no DVeop if no XDI handler at all
	mov	ah,al			; set multiplex number
	mov	al,1
	mov	bx,5242h		; "RB"
	mov	cx,656Fh		; "eo"
	mov	dx,7000h		; "p",0
	int	2Fh
no_entrypt:
	xor	dx,dx			; default ptr if not installed = NULL
	cmp	ax,5242h		; DVeop installed?
	mov	ax,dx
	jne	entrypt_done
	mov	dx,es
	mov	ax,bx
entrypt_done:
	mov	bx,ax
	or	bx,dx			; set ZF for easier testing by caller
	pop	es
	ret
DVeop_entrypoint endp

;------------------------------------------------------------------------
; int pascal DVeop_installed(void) ;
; returns DVeop version number or 0000h if not installed
;
PubProc@ DVEOP_INSTALLED,__PASCAL__
	call	DVeop_entrypoint
	jz	instchk_done
	mov	ax,cx
instchk_done:
	ret
EndProc@ DVEOP_INSTALLED,__PASCAL__

;------------------------------------------------------------------------
; return: DX:AX = previous callback address (0000:0000 if none, FFFF:FFFF on error)
;
PubProc@ DVEOP_CALLBACK,__PASCAL__
@callback = dword ptr [bp+6+cPtrSize]
	pushm	es,di
	push	bp
	mov	bp,sp
	call	DVeop_entrypoint
	jz	callback_error
	mov	bx,offset __TEXT:callback_result
	push	cs			; stack return address
	push	bx
	push	dx			; stack address of entry point
	push	ax
	les	di,@callback
set_callback proc far
	ret				; branch to entry point
set_callback endp
callback_result:
	cmp	ax,1
	jne	callback_error
	mov	ax,di
	mov	dx,es
callback_done:
	pop	bp
	popm	di,es
	ret	4

callback_error:
	mov	ax,-1
	mov	dx,ax
	jmp	callback_done
EndProc@ DVEOP_CALLBACK,__PASCAL__

CSegEnd@

	END
