;**************************************************************************
;*									  *
;*  DVPTAME	  Tame keyboard polls by patching .DVP			  *
;*  Donated to the Public Domain by Ralf Brown, 4/27/91 		  *
;*									  *
;*  (This is a modified and expanded version of the DVPWIDTH program	  *
;*	   distributed with RBcomm)					  *
;*									  *
;**************************************************************************

code	segment
	assume	cs:code,ds:code,es:code,ss:code
	org	80h
cmdline_len db	?
cmdline     db	127 dup (?)

        org     100h

dvptame:
	mov	cl,cmdline_len
	xor	ch,ch
	mov	si,offset cmdline
	mov	dx,offset usage_msg
	jcxz	exit_with_msg
	call	skip_whitespace
	cmp	al,'='                 ; display current setting only?
	je	number_done	       ; if yes, skip parsing the number
	mov	display_only,0
; collect the digits of the number
number_loop:
	sub	al,'0'
	jb	exit_with_msg
	cmp	al,9
	ja	exit_with_msg
	cbw			       ; zero AH
	mov	bx,ax
	mov	al,10
	mul	polls
	add	ax,bx
	mov	polls,ax
	lodsb
	dec	cx
	jcxz	exit_with_msg
	cmp	al,' '
	je	number_done
	cmp	al,9
	jne	number_loop
number_done:
; scan off leading whitespace
	call	skip_whitespace
; skip to end of filename and terminate with NUL
	mov	dx,si
	dec	dx			; DS:DX -> start of filename
	push	dx			; remember filename pointer
filename_loop:
	lodsb
	dec	cx
	jcxz	terminate_filename
	or	al,al
	je	terminate_filename
	cmp	al,' '
	ja	filename_loop
	dec	si			; we went one character too far
terminate_filename:
	mov	byte ptr [si],0
	pop	si			; get back ptr to start of filename
; try to open file for reading
	mov	al,00h			; mode is read
	call	open_file		; SI -> filename, ret BX = handle
	call	display_curr_polls
        cmp     display_only,0
	jne	exit
; finally, try to open file for writing
	mov	al,01h
	call	open_file
; if seek successful, write the new word
	mov	ah,40h
	mov	cx,2			; write two bytes
	mov	dx,offset polls
	int	21h
	mov	dx,offset write_error_msg
	jc	exit_with_msg
; close file
	mov	ah,3Eh
	int	21h
; give success message
	mov	dx,offset success_msg
exit_with_msg:
	mov	ah,9
	int	21h
exit:
	mov	ax,4C00h
	int	21h

open_file proc near
        mov     dx,si                   ; DS:DX -> filename
	mov	ah,3Dh
	int	21h
	mov	dx,offset open_error_msg
	jc	exit_with_msg
	mov	bx,ax
; if open successful, seek to offset 175h (max_polls)
	mov	ax,4200h
	xor	cx,cx
	mov	dx,0175h
	int	21h
	mov	dx,offset seek_error_msg
        jc      exit_with_msg
	ret
open_file endp

skip_whitespace proc near
	lodsb
	dec	cx			; have we run out of input?
	jcxz	exit_with_msg		; DX still points at usage_msg
        or      al,al
	je	exit_with_msg
	cmp	al,13
	je	exit_with_msg
	cmp	al,' '
	je	skip_whitespace
	cmp	al,9
	je	skip_whitespace
	ret
skip_whitespace endp

display_curr_polls proc near
	push	bx			; preserve file handle
        mov     ax,4200h
	xor	cx,cx
	mov	dx,0175h		; seek to "tame" word in .DVP
	int	21h
	mov	cx,2			; read a word
	mov	dx,offset curr_polls
	mov	ah,3Fh
	int	21h
	mov	ax,curr_polls
	mov	bx,offset number_buf
	xor	di,di
        mov     cx,10
itoa_loop:
	xor	dx,dx
	idiv	cx
	add	dl,'0'
	mov	[bx+di],dl
	inc	di
	or	ax,ax
	jne	itoa_loop
	mov	cx,di
	shr	cx,1
	jcxz	itoa_done
        dec     di
	push	si
	xor	si,si
itoa_rev:
	mov	al,[bx+si]
	xchg	al,[bx+di]
	mov	[bx+si],al
	inc	si
	dec	di
	loop	itoa_rev
	pop	si
itoa_done:
	pop	bx			; recover file handle
	mov	ah,3Eh			; close file
	int	21h
	mov	dx,offset max_polls_msg
	mov	ah,9
	int	21h
	ret
display_curr_polls endp

polls		dw 0
curr_polls	dw ?
display_only	db 1
usage_msg	db "DVPTAME",9,9,"Tame keyboard polls via .DVP",13,10
		db "Donated to the Public Domain by Ralf Brown",13,10,10
		db "Usage:  DVPTAME polls dvp-file",13,10
		db 9,"where 'polls' is a number indicating how many keyboard",13,10
		db 9,"polls to allow in one clock tick (0 = infinite)",13,10
		db "$"
max_polls_msg	db "Current maximum polls = "
number_buf	db "     "
		db 13,10,"$"
success_msg     db "Maximum polls set",13,10,"$"
open_error_msg	db "Error opening .DVP file",13,10,"$"
seek_error_msg	db "Seek on .DVP file failed",13,10,"$"
write_error_msg db "Write to .DVP file failed",13,10,"$"

code ends
     end dvptame

