Quarterdeck Technical Note

Patching QEMM.SYS, QRAM.SYS, MFT.EXE, XDV.COM, DV.COM, and 
DVHERC.COM to prevent video confusion on Hercules dual monitor 
systems

Background: Various Quarterdeck programs - QEMM.SYS (QEMM-386) 
dated 1-11-90 or earlier, QRAM.SYS (QRAM) dated 1-11-90 or 
earlier, MFT.EXE (Manifest) dated 1-11-90, XDV.COM and DV.COM 
(DESQview or DESQview 386) dated 3-9-90 or earlier, and 
DVHERC.COM (DESQview or DESQview 386) dated 3-9-90 or earlier - 
make a call to Hercules and Hercules compatible video cards that 
enables the second page of Hercules graphics.  The Hercules card 
uses the B800-BFFF area for its second graphics page; this area 
is also used by CGA, EGA, MCGA, and VGA cards for color text 
display.  As a result, both the Hercules card and the color card 
on dual monitor systems use the B800-BFFF area, with 
unpredictable video results.  The usual symptom is either a 
blanked-out or a garbaged screen on the color monitor shortly 
after the product in question loads.  The problem has no 
consequences other than video confusion, and, if the screen 
restores with a CLS or a MODE CO80 command, should not recur 
until a cold boot or a reset.  As a result, users who see this 
problem after QEMM.SYS loads may simply wish to put a CLS 
statement at the beginning of their AUTOEXEC.BAT instead of 
patching all of the above programs.

The following procedure, which is intended to prevent this video 
confusion on Hercules dual monitor systems, must be followed for 
each of the above Quarterdeck programs that are in use.  We will 
use MFT.EXE as an example in the following procedure, but the 
process should be repeated for QEMM.SYS, QRAM.SYS, XDV.COM, 
DV.COM, and DVHERC.COM as well. (XDV.COM and DV.COM are 
identical; you need only patch one file, then copy the patched 
file on top of the other file.)

-------------------------------------------------

1) Make a copy of the file in question, as you are about to use 
DOS DEBUG to alter the file.  

2) If the file you are working on is MFT.EXE, rename it, as DOS 
DEBUG behaves differently with .EXE files.  You need not rename 
any of the other Quarterdeck programs, as they are not .EXE 
files, but it will do no harm if you do rename them.

     REN MFT.EXE MFT.XXX

3) Go into DEBUG, passing MFT.XXX to it as a parameter.

     DEBUG MFT.XXX

If you get a "file not found" message, give the full path names 
to DEBUG and MFT.XXX.

After you hit the Enter key, you should the the DEBUG prompt, which is a 
hyphen.

4) At the DEBUG prompt, type:

          S 100 L F000 B0 3 EE

Hit the Enter key; DEBUG should return a segment address and an 
offset:

          xxxx:yyyy

...or, if you are working on Manifest, two pairs of segment 
addresses and offsets:

          xxxx:yyyy
          xxxx:yyyy

5) At the DEBUG prompt again, use the address and offset that was 
just returned (or, in the case of Manifest, one of the two pairs 
of segment offsets and addresses) to give the DEBUG command:

          E xxxx:yyyy 90 90 90

The address that DEBUG returned in step 4 should be used in place 
of the address xxxx:yyyy, which we use as an example.  Hit the 
Enter key; the DEBUG prompt should return in a moment.

6) If the file you are working on is the Manifest file, repeat 
step 5 with the other segment offset and address, so that the 
data at both addresses has been changed.

7) At the DEBUG prompt, type

          W

Hit the Enter key; DEBUG will announce that it is writing a 
certain number of bytes, then it will return the DEBUG prompt.

8) At the DEBUG prompt, type

          Q

Hit the Enter key to exit DEBUG and return to DOS.

9) If the file you are working on is the Manifest file, rename it 
back to its original name:

          REN MFT.XXX MFT.EXE

--------------------------------------------------

If the file you were working on does not perform properly after 
you do this patch, you should restore the copy of the file that 
you made earlier and delete the file that you altered. You may 
then wish to try the above procedure again, in case a mistake was 
made.


             * * *   E N D   O F   F I L E    * * *
