/*  mdisk.c   -- Display a disk's physical attributes */
/*  Copyright 1991, Steven W. Harrold - All rights reserved */
/*  $Header: MDISK.C_V 1.2 91/03/22 07:54:13 SWH Exp $ */

#include    <stdio.h>
#include    <stdlib.h>
#include    <ctype.h>
#include    <stddef.h>
#include    "mfs.h"
#include    "dev.h"

DEVINIT


/*==================================================================*/
int main(argc, argv)
int     argc ;
char    *argv[] ;
{
    char            drive_id ;
    int             drive ;
    int             sides = 0 ;
    struct devdata  *dp ;

    printf ("**** Displays physical attributes of a disk/drive ****\n") ;
    printf ("\n") ;

/*  Does he want help?
 */
    if ((argc >= 2) && (argv[1][0] == '-') && (argv[1][1] == '?'))
    {
printf ("Copyright 1988,1991 Steven W. Harrold - All rights reserved\n") ;
        printf ("Version %s\n", VERSION) ;
        printf ("Usage:   %s  [[drid] sides]\n", argv[0]) ;
        printf ("'drid' is a letter from the set [a-z], default: 'a'\n") ;
        printf ("'sides' is number of heads for single sided floppy\n");
        exit (0) ;
    }

/*  Obtain the floppy identifier (if alphabetic) or hard drive
**  identifier (if numeric).  Default is A:.
*/
    if (argc == 1)
        drive_id = 'A' ;
    else
    {
        drive_id = argv[1][0] ;
        drive_id = toupper(drive_id) ;
    }

    if (isalpha(drive_id))
        drive = drive_id - 'A' ;
    else if (isdigit(drive_id))
        drive = 0x80 + (drive_id - '0') ;
    else
    {
        printf ("Drive '%c' must be alphanumeric\n", drive_id) ;
        return -1 ;
    }

/*  Obtain the sides count, if supplied
*/
    if (argc > 2)
        sides = atoi (argv[2]) ;

/*  Initialize the device data block
*/
    printf ("Using drive=0x%02X and sides=%d\n", drive, sides) ;

    dp = devinit (drive, sides) ;
    if (!dp)
    {
        printf ("The devdata block was not allocated; Dstatus=%d\n",
                Dstatus) ;
        return -1 ;
    }
    printf ("Status from devinit() = %d\n", dp->d_status) ;
    if (dp->d_status)
        return dp->d_status ;

/*  Display the results
*/
    printf ("Tracks............ %d\n",   dp->d_tracks    ) ;
    printf ("Heads............. %d\n",   dp->d_heads     ) ;
    printf ("Sectors........... %d\n",   dp->d_sectors   ) ;
    printf ("Interleave........ %d:1\n", dp->d_interleave) ;
    printf ("Partition offset.. %d\n",   dp->d_partoff   ) ;

    if ((dp->d_heads==1) && (dp->d_tracks==40) && (dp->d_sectors== 8))
        printf ("160KB  SSSD/8 5.25\" disk\n") ;
    if ((dp->d_heads==2) && (dp->d_tracks==40) && (dp->d_sectors== 8))
        printf ("320KB  DSSD/8 5.25\" disk\n") ;
    if ((dp->d_heads==2) && (dp->d_tracks==40) && (dp->d_sectors== 9))
        printf ("360KB  DSSD 5.25\" disk\n") ;
    if ((dp->d_heads==2) && (dp->d_tracks==80) && (dp->d_sectors== 9))
        printf ("720KB  DSSD/80 5.25\" disk\n") ;
    if ((dp->d_heads==2) && (dp->d_tracks==80) && (dp->d_sectors==15))
        printf ("1.2MB  DSDD 5.25\" disk\n") ;
    if ((dp->d_heads==2) && (dp->d_tracks==80) && (dp->d_sectors== 9))
        printf ("720KB  DSSD 3.5\" disk\n") ;
    if ((dp->d_heads==2) && (dp->d_tracks==80) && (dp->d_sectors==18))
        printf ("1.4KB  DSDD 3.5\" disk\n") ;

    return 0 ;

} /* main() */


/*---eof---*/
