#ifndef _NPX_H_
#define _NPX_H_

void emu_install();

extern int modrm;

extern unsigned eax;
extern unsigned ebx;
extern unsigned ecx;
extern unsigned edx;
extern unsigned esi;
extern unsigned edi;
extern unsigned ebp;
extern unsigned esp;
extern unsigned char *eip;

struct reg {
  char sign;
  char tag;
  short exp;
  unsigned sigl;
  unsigned sigh;
};

#define EXP_BIAS 16383
#define EXP_MAX 32766

#define SIGN_POS	0
#define SIGN_NEG	1

#define TW_V	0	// valid
#define TW_Z	1	// zero
#define TW_S	2	// special
#define TW_E	3	// empty

#define EX_SO	0x02C1	// stack overflow
#define EX_SU	0x00C1	// stack underflow
#define EX_P	0x00A0	// loss of precision
#define EX_U	0x0090	// underflow
#define EX_O	0x0088	// overflow
#define EX_Z	0x0084	// divide by zero
#define EX_D	0x0082	// denormalized operand
#define EX_I	0x0081	// invalid operation

#define SW_B	0x8000	// backward compatibility (=ES)
#define SW_C3	0x4000	// condition bit 3
#define SW_TOP	0x3800	// top of stack
#define SW_TOPS 0x0800	// scale for TOS
#define SW_C2	0x0400	// condition bit 2
#define SW_C1	0x0200	// condition bit 1
#define SW_C0	0x0100	// condition bit 0
#define SW_ES	0x0080	// exception summary
#define SW_SF	0x0040	// stack fault
#define SW_PE	0x0020	// loss of precision
#define SW_UE	0x0010	// underflow
#define SW_OE	0x0008	// overflow
#define SW_ZE	0x0004	// divide by zero
#define SW_DE	0x0002	// denormalized operand
#define SW_IE	0x0001	// invalid operation

#define CW_RC	0x0C00	// rounding control
#define CW_PC	0x0300	// precision control
#define CW_PM	0x0020	// precision mask
#define CW_UM	0x0010	// underflow mask
#define CW_OM	0x0008	// overflow mask
#define CW_ZM	0x0004	// divide by zero mask
#define CW_DM	0x0002	// denormalized operand mask
#define CW_IM	0x0001	// invalid operation mask
#define CW_EXM	0x007f	// all masks

#define RC_RND	0x0000
#define RC_DOWN	0x0400
#define RC_UP	0x0800
#define RC_CHOP	0x0C00

/*
** THE NPX ENVIRONMENT
*/

extern int status_word;
extern int control_word;
extern reg regs[8];
extern int top;

/*
** UTILITY FUNCTIONS
*/

extern void *get_modrm();
inline reg& st(int which=0) { return regs[(top+which)&7]; }
extern void emu_printall();
extern void exception(int which); // returns 1 if unmasked
extern void setcc(int cc);
extern int full(); // returns 1 if exception, handles exception
extern int empty(int i=0); // returns 1 if exception, handles exception

typedef void (*FUNC)();

void emu_bad();

void r_add(reg& a, reg& b, reg& s); // a + b -> s
void r_sub(reg& a, reg& b, reg& d); // a - b -> d
void r_mul(reg& a, reg& b, reg& p); // a * b -> p
void r_div(reg& a, reg& b, reg& q); // a / b -> q

void r_mov(reg& s, reg& d);

int val_same(reg& a, reg& b);
int mag_same(reg& a, reg& b);

void emu_00();
void emu_01();
void emu_02();
void emu_03();
void emu_04();
void emu_05();
void emu_06();
void emu_07();
void emu_10();
void emu_11();
void emu_12();
void emu_13();
void emu_14();
void emu_15();
void emu_16();
void emu_17();
void emu_20();
void emu_21();
void emu_22();
void emu_23();
void emu_24();
void emu_25();
void emu_26();
void emu_27();
void emu_30();
void emu_31();
void emu_32();
void emu_33();
void emu_34();
void emu_35();
void emu_36();
void emu_37();
void emu_40();
void emu_41();
void emu_42();
void emu_43();
void emu_44();
void emu_45();
void emu_46();
void emu_47();
void emu_50();
void emu_51();
void emu_52();
void emu_53();
void emu_54();
void emu_55();
void emu_56();
void emu_57();
void emu_60();
void emu_61();
void emu_62();
void emu_63();
void emu_64();
void emu_65();
void emu_66();
void emu_67();
void emu_70();
void emu_71();
void emu_72();
void emu_73();
void emu_74();
void emu_75();
void emu_76();
void emu_77();

#endif
