/* This is file ATAN2.S */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/*
 * Modified by Dieter Buerssner to return NaN (not a number)
 * for atan2(0,0). (fpatan would yield 0.0 with no exceptions set)
 */

.data
	.align	2
nan:
	.long	0xffffffff
	.byte	0xff
	.byte	0xff
	.byte	0xff
	.byte	0x7f

.text
	.globl	_atan2
_atan2:
	fldl	4(%esp)
	fldl	12(%esp)
	ftst
	fnstsw	%ax
	sahf
	jne	doit
	fxch	%st(1)
	ftst
	fnstsw	%ax
	sahf
	je	isanan
	fxch	%st(1)
doit:
	fpatan
	ret
isanan:
	movl	$33,_errno
	fstp	%st(0)
	fstp	%st(0)
	fldl	nan
	ret

