#include <stdio.h>

char *skips[] = {
  "Onindy.c",
  "nindy.c",
  "ttyflush.c",
  "xdr_ld.c",
  "xdr_ptrace.c",
  "xdr_rdb.c",
  "udr.c",
  "udip2soc.c",
  "udi2go32.c",
  "version.c",
  "c-exp.tab.c",
  "c-exp-tab.c",
  "m2-exp.tab.c",
  "m2-exp-tab.c",
  "ch-exp.tab.c",
  "ch-exp-tab.c",
  0
};

main(int argc, char **argv)
{
  FILE *init = fopen("init.c", "w");
  int i, j;
  FILE *f;

  fprintf(init, "/* Do not modify this file.  It is created by getinit */\n");
  fprintf(init, "void initialize_all_files() {\n");
  for (i=1; i<argc; i++)
  {
    int skip=0;
    char *suf = argv[i]+strlen(argv[i])-2;
    if (strcmp(suf, ".o"))
      continue;
    suf[1] = 'c';
    for (j=0; skips[j]; j++)
      if (strcmp(argv[i], skips[j]) == 0)
      {
	skip = 1;
	break;
      }
    if (skip)
      continue;
    f = fopen(argv[i], "r");
    if (f)
    {
      char buf[1000];
      while (fgets(buf, 1000, f))
      {
        if (strncmp(buf, "_initialize", 11) == 0)
        {
          char *e;
          for (e=buf; *e && *e!=' ' && *e!='('; e++)
            ;
          *e = 0;
          fprintf(init, " { extern void %s (); %s();}\n", buf, buf);
        }
      }
      fclose(f);
    }
  }
  fprintf(init, "}\n");
  fclose(init);
  return 0;
}
