From:	IN%"lenoil@APPLE.COM"  "Robert Lenoil"  9-DEC-1988 16:15
To:	p150bk19@VB.CC.CMU.EDU
Subj:	VISBELL.E

Received: from apple.com by VB.CC.CMU.EDU; Fri, 9 Dec 88 16:13 EST
Received: by apple.com (5.59/25-eef) id AA17256; Fri, 9 Dec 88 13:10:56 PST
Date: Fri, 9 Dec 88 13:10:56 PST
From: Robert Lenoil <lenoil@APPLE.COM>
Subject: VISBELL.E
To: p150bk19@VB.CC.CMU.EDU
Message-Id: <8812092110.AA17256@apple.com>

/* The following copyright and trademark notice applies to some of the code
 * herein; all other material is Copyright (c) 1986, 1987 by Robert Lenoil,
 * with free copying allowed for any purpose, provided that this copyright
 * notice is included.
 */

/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*                                                                       *
*     Copyright (C) 1985 Lugaru Software Ltd.  All rights reserved.     *
*                                                                       *
* Limited permission is hereby granted to reproduce and modify this     *
* copyrighted material provided that the resulting code is used only in *
* conjunction with Lugaru products and that this notice is retained in  *
* any such reproduction or modification.                                *
************************************************************************/

/*
 * A visible bell for Epsilon
 */

#include <eel.h>

/* This file modifies the following Epsilon commands/procedures:
COMMAND              SOURCE FROM VERSION
maybe_ding              3.1

   And adds the following commands/procedures:
COMMAND           WRITTEN FOR VERSION
flash                   3.1
visible_bell            3.1

   And defines the following globals:
GLOBAL            WRITTEN FOR VERSION
bell_type               3.1
*/

/* Implement visible bell feature */
#define VISIBLE 1
int bell_type = !VISIBLE;

command visible_bell()
{  bell_type = (has_arg? (iter != 0) : !bell_type);
   say("Bell type is %s", bell_type? "visible" : "audible");
   iter = 1;
}

maybe_ding()
{
   if (want_bell)
      if (bell_type == VISIBLE)
         flash();
      else
         ding();
}

flash()
{  int tmp;

   tmp = normcolor;
   normcolor = revcolor;
   refresh();
   normcolor = tmp;
   refresh();
}
