unit FHRPRINT;

 {Warning: this unit only works for EPSON compatible printers! All other
  printers go bezerk if they get these codes.}

interface

uses printer,graph;

var FHRX,FHRY : word;
    FHRa,FHRb,FHRc : byte;
    tel,tel2       : word;

Procedure PrintScr(Maxx,Maxy:Word;Mode:byte;Shrink:boolean);

{Maxx and Maxy have to be the graphical screen sizes you want to print 
 (in dots), usually that will be GetMaxX and GetMaxY.

 Mode is the print density of the printer:
 1     = Double-Density 120 dots per inch
 2     = High-Speed Double Density 240 dots per inch
 3     = Quadruple-Density 240 dots per inch
 0,4,5 = 80 dots per inch
 6     = 90 dots per inch

 Densities may vary from printer to printer; check your manual.
 Pre-EPSON FX and Pre-STAR LC10 series should only use mode 1
 
 Shrink changes the way the screen is read:
 Shrink := false : All dots of the screen are sent.
 Shrink := true  : If one dot of four is present, only one point is sent
                   otherwise not.
                   
 Please sent any comment to:                  
 f.h.reincke@chemail.chem.ruu.nl}

implementation

Procedure PrintScr(Maxx,Maxy:Word;Mode:byte;Shrink:boolean);

var MaxX2 : word;
    Times : byte;

 Function PointPresent(XX,YY:word):boolean;

 begin
  if (GetPixel(XX,YY)+
      GetPixel(XX+1,YY)+
      GetPixel(XX,YY+1)+
      GetPixel(XX+1,YY+1)) > 0 then
  PointPresent := true
  else
  PointPresent := false;
 end;

begin
 write(lst,chr(27),'3',chr(25));
 FHRY := 0;
 if Shrink then
 begin
  while FHRY <= MaxY do
  begin
   MaxX2 := Maxx div 2;
   Times := ((Maxx2-(Maxx2 mod 265)) div 256) +1;
   Write(lst,chr(27),'*',chr(Mode),chr(0),chr(Times));
   for tel := 1 to Times*256 do
   begin
    FHRc := 0;
    tel2 := tel*2-2;
    if tel2 <= Maxx then
    begin
     if PointPresent(tel2,FHRY) then FHRc := FHRc+128;
     if PointPresent(tel2,FHRY+2) then FHRc := FHRc+64;
     if PointPresent(tel2,FHRY+4) then FHRc := FHRc+32;
     if PointPresent(tel2,FHRY+6) then FHRc := FHRc+16;
     if PointPresent(tel2,FHRY+8) then FHRc := FHRc+8;
     if PointPresent(tel2,FHRY+10) then FHRc := FHRc+4;
     if PointPresent(tel2,FHRY+12) then FHRc := FHRc+2;
     if PointPresent(tel2,FHRY+14) then FHRc := FHRc+1;
    end;
    write(lst,chr(FHRc));
   end;
   FHRY := FHRY+16;
   writeln(lst,'');
  end;
 end
 else
 begin
  while FHRY <= MaxY do
  begin
   Times := ((Maxx-(Maxx Mod 256)) div 256) +1;
   Write(lst,chr(27),'*',chr(Mode),chr(0),chr(Times));
   for tel := 1 to Times*256 do
   begin
    FHRc := 0;
    tel2 := tel-1;
    if tel2 <= Maxx then
    begin
     if GetPixel(tel2,FHRY) > 0 then FHRc := FHRc+128;
     if GetPixel(tel2,FHRY+1) > 0 then FHRc := FHRc+64;
     if GetPixel(tel2,FHRY+2) > 0 then FHRc := FHRc+32;
     if GetPixel(tel2,FHRY+3) > 0 then FHRc := FHRc+16;
     if GetPixel(tel2,FHRY+4) > 0 then FHRc := FHRc+8;
     if GetPixel(tel2,FHRY+5) > 0 then FHRc := FHRc+4;
     if GetPixel(tel2,FHRY+6) > 0 then FHRc := FHRc+2;
     if GetPixel(tel2,FHRY+7) > 0 then FHRc := FHRc+1;
    end;
    write(lst,chr(FHRc));
   end;
   FHRY := FHRY+8;
   writeln(lst,'');
  end;
 end;
 Writeln(lst,chr(27),'0');
end;

end.
