/*
 * File: rwinrsc.r
 *  X-Icon Window resource module
 *
 * Resources are allocated through a layer of internal management
 * routines in order to handle aliasing and resource sharing.
 */
#ifdef XIcon

/*
 * global variables.
 */

#ifndef PresentationManager
wdisplay *wdsplys;
#else					/* PresentationManager */
LONG NumWindows = 0;
#endif					/* PresentationManager */

wcontext *wcntxts = NULL;
wstate   *wstates = NULL;
wbinding *wbndngs = NULL;

#ifndef PresentationManager
/*
 * Lookup an r,g,b for string s.  No allocation is done here.
 * Returns 0 on failure.  Adds decimal literals to XParseColor.
 */
int lookup_color(w,s,clr)
wbp w;
char *s;
XColor *clr;
   {
   STDLOCALS(w);

   if (isdigit(*s)) {	/* comma-separated r,g,b literal */
      clr->flags = DoRed | DoGreen | DoBlue;
#if VMS
      if (sscanf(s, "%d,%d,%d", &(clr->red), &(clr->green), &(clr->blue))
#else						/* VMS */
      if (sscanf(s, "%hu,%hu,%hu", &(clr->red), &(clr->green), &(clr->blue))
#endif						/* VMS */

	  != 3)
	 return 0;
      }
   else if (!XParseColor(stddpy, wd->cmap, s, clr))
      return 0;
   return 1;
   }

/*
 * Allocate an r,g,b color.  Colors are shared on a per-display basis,
 * but they are often freed on a per-window basis, so they are remembered
 * in two structures.
 */
wclrp alc_rgb(w,s,r,g,b)
wbp w;
char *s;
unsigned int r,g,b;
   {
   XColor color;
   int i;
   STDLOCALS(w);

   /*
    * handle black and white specially (no allocation)
    */
   if ((r == 0) && (g == 0) && (b == 0)) {
      return &(wd->colors[0]);
      }
   if ((r == 65535) && (g == 65535) && (b == 65535)) {
      return &(wd->colors[1]);
      }

   /*
    * Search for the color in w's display
    */
   for (i = 2; i < wd->numColors; i++) {
      if (wd->colors[i].refcount>0 &&
	  wd->colors[i].type == SHARED &&
	  r == wd->colors[i].r &&
	  g == wd->colors[i].g &&
	  b == wd->colors[i].b)
         break;
      }

   if (i >= wd->numColors) {
      int j;
      /* color not found, must allocate */
      color.red = r;
      color.green = g;
      color.blue = b;

      if (!XAllocColor(stddpy, wd->cmap, &color)) {
	 /* try again with a virtual colormap */
	 if (!go_virtual(w) || !XAllocColor(stddpy, wd->cmap, &color))
            return NULL;
         }

      j = alc_centry(wd);
      if (j == 0)
	 return &(wd->colors[0]);
      strcpy(wd->colors[j].name, s);
      /*
       * Store in color table as what they asked for, not what they got.
       * This is arguable, so feel free to argue.
       */
      wd->colors[j].r = r;
      wd->colors[j].g = g;
      wd->colors[j].b = b;
      wd->colors[j].c = color.pixel;
      wd->colors[j].type = SHARED;
      if (w->window->numColors == WMAXCOLORS) {
	 /* "no room in window color table!\n" */
	 return NULL;
         }
      else {
	 w->window->theColors[w->window->numColors++] = j;
         }
      return &(wd->colors[j]);
      }
   else {
      /* color is found, alias it and put it in the window color table */
      int k;
      for(k=0;k<w->window->numColors;k++){
         if (w->window->theColors[k] == i) {
	    /* already there, no further action needed */
	    return &(wd->colors[i]);
            }
         }
      wd->colors[i].refcount++;
      w->window->theColors[w->window->numColors++] = i;
      return &(wd->colors[i]);
      }
   }

/*
 * allocate a color entry, return index (or 0 if table is full)
 */
int alc_centry(wd)
wdp wd;
{
   int j;

   for (j = 2; j < DMAXCOLORS; j++)
      if (wd->colors[j].refcount == 0)
	 break;
   if (j == DMAXCOLORS)
      return 0;
   if (j == wd->numColors)
      wd->numColors++;
   else if (j > wd->numColors)
      return 0;		/* internal confusion */

   wd->colors[j].refcount = 1;
   return j;
}

#if 0
/*
 * allocate from internal r,g,b (was used by rxgifload) and return X pixel
 */
unsigned long get_color(w,r,g,b)
wbp w;
unsigned short r,g,b;
   {
   char s[24];
   wclrp wc;
   sprintf(s,"%d,%d,%d",r,g,b);
   Protect(wc = alc_rgb(w,s,r,g,b), wc = &(w->window->display->colors[0]));
   return wc->c;
   }
#endif					/* 0 */
/*
 * allocate by named color and return Icon color pointer
 */
wclrp alc_color(w,s)
wbp w;
char *s;
   {
   wclrp rv;
   XColor colr;

   /*
    * convert color to an r,g,b triple
    */
   if (!lookup_color(w,s,&colr)) return 0;

   /*
    * return Icon color structure, allocated in display
    */
   Protect(rv = alc_rgb(w,s,colr.red,colr.green,colr.blue), return 0);
   return rv;
   }

/*
 * free a single color allocated by a given window
 */
novalue free_color(w,c)
wbp w;
unsigned long c;
   {
   int i;
   STDLOCALS(w);

   for (i = 0; i < ws->numColors; i++) {
      if (wd->colors[ws->theColors[i]].c == c) break;
      }
   if (i >= ws->numColors) {
      /* "free_color couldn't find the color in the window\n" */
      }
   else {
      if (--(wd->colors[ws->theColors[i]].refcount) ==0){
	 XFreeColors(stddpy, wd->cmap, &c, 1, 0);
	 ws->numColors--;
	 if (ws->numColors != i) {
	    ws->theColors[i] =
	      ws->theColors[ws->numColors];
	    }
         }
      }
   }
/*
 * free the colors allocated by a given window, except black, white,
 * fg, bg, and wbg.
 */
novalue free_colors(w)
wbp w;
   {
   int i;
   unsigned long toFree[DMAXCOLORS];
   int freed = 0;
   STDLOCALS(w);

   for (i = w->window->numColors-1; i >= 0; i--) {
      int j = w->window->theColors[i];
      /*
       * don't free black, white, fg, bg, or wbg
       */
      if ((j<2) ||
	  (&(wd->colors[j]) == w->context->fg) ||
	  (&(wd->colors[j]) == w->context->bg) ||
	  (&(wd->colors[j]) == w->window->winbg)) continue;

      if (--(wd->colors[j].refcount) == 0) {
	 toFree[freed++] = wd->colors[j].c;
         }
      }
   if (freed>0)
      XFreeColors(stddpy, wd->cmap, toFree, freed,0);
   ws->numColors = 0;
   }

/*
 * Allocate a virtual colormap with all colors used by the client copied from
 * the default colormap to new colormap, and set all windows to use this new
 * colormap.  Returns 0 on failure.
 */
int go_virtual(w)
wbp w;
{
   wsp win;
   STDLOCALS(w);

   if (wd->cmap != DefaultColormap(stddpy,wd->screen))
      return 0;    /* already using a virtual colormap */

   wd->cmap = XCopyColormapAndFree(stddpy,wd->cmap);

   /* set the colormap for all the windows to the new colormap */

   for (win = wstates; win; win = win->next)
      if (win->display->display == stddpy)
         XSetWindowColormap(stddpy, win->win, wd->cmap);

   return 1;
}

/*
 * allocate a display on machine s
 */
wdp alc_display(s)
char *s;
   {
   int i;
   wdp wd;
   XColor color;

   if (s == NULL) s = "";
   for(wd = wdsplys; wd; wd = wd->next)
      if (!strcmp(wd->name,s)) {
         wd->refcount++;
	 return wd;
         }

   wd = (struct wdisplay *)malloc(sizeof(struct wdisplay));
   if (wd == NULL) return NULL;

   wd->refcount++;
   strcpy(wd->name,s);
   wd->display = XOpenDisplay((*s=='\0') ? NULL : s);
   if (wd->display == NULL) {
      wd->refcount = 0;
      free(wd);
      return NULL;
      }
   wd->screen = DefaultScreen(wd->display);
   wd->cmap = DefaultColormap(wd->display, wd->screen);

   /*
    * Color slots 0 and 1 are permanently reserved for black and white
    * respectively.  Allocate them explicitly so that they're preserved
    * if we later switch to a virtual colormap.
    */
   strcpy(wd->colors[0].name,"black");
   wd->colors[0].refcount = 1;
   wd->colors[0].type = SHARED;
   wd->colors[0].r = wd->colors[0].g = wd->colors[0].b = 0;
   color.red = color.green = color.blue = 0;
   if (XAllocColor(wd->display, wd->cmap, &color))
      wd->colors[0].c = color.pixel;
   else
      wd->colors[0].c = BlackPixel(wd->display,wd->screen);

   strcpy(wd->colors[1].name,"white");
   wd->colors[1].refcount = 1;
   wd->colors[1].type = SHARED;
   wd->colors[1].r = wd->colors[1].g = wd->colors[1].b = 65535;
   color.red = color.green = color.blue = 65535;
   if (XAllocColor(wd->display, wd->cmap, &color))
      wd->colors[1].c = color.pixel;
   else
      wd->colors[1].c = WhitePixel(wd->display,wd->screen);

   wd->numColors = 2;
   for (i=2; i < DMAXCOLORS; i++) wd->colors[i].refcount = 0;

   wd->numFonts = 1;
   wd->fonts = (wfp)malloc(sizeof(struct wfont));
   wd->fonts->refcount = 1;
   wd->fonts->next = wd->fonts->previous = NULL;
   wd->fonts->name = malloc(6);
   strcpy(wd->fonts->name,"fixed");
   wd->fonts->fsp = XLoadQueryFont(wd->display, "fixed");
   if (wd->fonts->fsp == NULL) { /* couldn't load "fixed"! */
      free(wd);
      return NULL;
      }

   {
   XGCValues gcv;
   Display *stddpy = wd->display;
   gcv.font = wd->fonts->fsp->fid;
   gcv.foreground = wd->colors[0].c;
   gcv.background = wd->colors[1].c;
   gcv.fill_style = FillSolid;
   wd->icongc = XCreateGC(stddpy, DefaultRootWindow(stddpy),
			  GCFont | GCForeground | GCBackground | GCFillStyle,
			  &gcv);
   if (wd->icongc == NULL) {
      free(wd);
      return NULL;
      }
   }

   wd->fonts->height = wd->fonts->fsp->ascent + wd->fonts->fsp->descent;
   wd->fonts->leading = wd->fonts->height;
   wd->next = wdsplys;
   wd->previous = NULL;
   if (wdsplys) {
      wdsplys->previous = wd;
      }
   wdsplys = wd;
   return wd;
   }

/*
 * allocate font s in the display attached to w
 */
wfp alc_font(w,s)
wbp w;
char **s;
   {
   int i;
   wfp rv;
   wdp wd = w->window->display;
   /*
    * see if the font is already loaded on this display
    */
   for(rv = wd->fonts; rv != NULL; rv = rv->next) {
      if (!strcmp(*s,rv->name)) break;
      }
   if (rv != NULL) {
      rv->refcount++;
      return rv;
      }

   /*
    * load a new font
    */
   rv = (struct wfont *)malloc(sizeof(struct wfont));
   if (!rv) return NULL;
   rv->refcount = 1;
   rv->name = malloc(strlen(*s)+1);
   strcpy(rv->name,*s);
   rv->fsp = XLoadQueryFont(wd->display, rv->name);
   if (rv->fsp == NULL){
      rv->refcount = 0;
      return 0;
      }
   rv->height = rv->fsp->ascent + rv->fsp->descent;
   rv->leading = rv->height;

   /*
    * link the font into this displays fontlist (but not at the head!)
    */
   rv->next = wd->fonts->next;
   rv->previous = wd->fonts;
   if (wd->fonts->next) wd->fonts->next->previous = rv;
   wd->fonts->next = rv;
   return rv;
   }
#endif					/* PresentationManager */

/*
 * allocate a context.  Can't be called until w has a display and window.
 */
wcp alc_context(w)
wbp w;
   {
   int i;
#ifndef PresentationManager
   wdp wd = w->window->display;
#endif					/* PresentationManager */
   wcp wc;

   /* calloc to make sure uninit'd entries are zeroed. */
   if (wc = (struct wcontext *)calloc(1, sizeof(struct wcontext))) {
     wc->refcount=1;
#ifndef PresentationManager  
     wc->display = wd;
     wd->refcount++;
     wc->fg = &(wd->colors[0]);
     wc->bg = &(wd->colors[1]);
     wc->font = wd->fonts;
     wc->drawop    = GXcopy;
#else					/* PresentationManager */
     /* need to make the dependant list */
     if (!(wc->depWindows = calloc(INITDEPS, sizeof(wstate *)))) {
       free(wc);
       return NULL;
       } /* End of if - allocation failed */
     /* size of table */
     wc->maxDeps = INITDEPS;
#endif					/* PresentationManager */

     wc->next = wcntxts;
     wc->previous = NULL;
     if (wcntxts) wcntxts->previous = wc;
     wcntxts = wc;
     } /* End of if - calloc success */
   return wc;
   }

/*
 * allocate a context, cloning attributes from an existing context
 */
wcp clone_context(w)
wbp w;
   {
#ifndef PresentationManager
   wcp wc, rv;
   XGCValues gcv;
   int gcmask = GCFont | GCForeground | GCBackground |
		GCFillStyle | GCLineWidth | GCLineStyle;

   wc = w->context;
   Protect(rv = alc_context(w), return NULL);

   rv->dx = wc->dx;
   rv->dy = wc->dy;
   rv->clipx = wc->clipx;
   rv->clipy = wc->clipy;
   rv->clipw = wc->clipw;
   rv->cliph = wc->cliph;
   rv->fg = wc->fg;
   rv->fg->refcount++;
   rv->bg = wc->bg;
   rv->bg->refcount++;
   rv->font = wc->font;
   rv->font->refcount++;
   rv->fillstyle = wc->fillstyle;
   rv->linestyle = wc->linestyle;
   rv->linewidth = wc->linewidth;
   rv->drawop = wc->drawop;
   rv->bits = wc->bits;

   gcv.foreground = rv->fg->c;
   gcv.background = rv->bg->c;
   gcv.font       = rv->font->fsp->fid;
   gcv.line_style = rv->linestyle;
   gcv.line_width = rv->linewidth;
   gcv.fill_style = rv->fillstyle;
   rv->gc = XCreateGC(w->window->display->display,w->window->pix,gcmask,&gcv);
   return rv;
#else					/* PresentationManager */
  wcontext *wc, *wc2;

  wc2 = w->context;
  Protect(wc = alc_context(w), return NULL);
  /* copy over some stuff */
  wc->charBundle = wc2->charBundle;
  wc->areaBundle = wc2->areaBundle;
  wc->lineBundle = wc2->lineBundle;
  wc->fntLeading = wc2->fntLeading;
  wc->font = wc2->font;
  wc->dx = wc2->dx; wc->dy = wc2->dy;
  wc->drawop = wc2->drawop;
  wc->bits = wc2->bits;
  /* bump up reference counts on colors */
  AddColorDependant(wc->charBundle.lColor);
  AddColorDependant(wc->charBundle.lBackColor);
  /* have to bump up reference count on pattern and font, if not default */
  wc->currPattern = wc2->currPattern;
  AddPatternDependant(wc->currPattern);
  /* font .. */
  AddFontDependant(wc->charBundle.usSet);
  /* copy the clipping region */
  wc->clipx = wc2->clipx;
  wc->clipy = wc2->clipy;
  wc->clipw = wc2->clipw;
  wc->cliph = wc2->cliph;
  return wc;
#endif					/* PresentationManager */
}

int win_highwater = -1;
/*
 * allocate a window state structure
 */
wsp alc_winstate()
   {
   int i;
   wsp ws;
   
   if (ws = (struct wstate *)calloc(1, sizeof(struct wstate))) {
     ws->refcount = 1;
     ws->bits = 1024;				/* echo ON; others OFF */
     ws->filep = nulldesc;
     ws->listp = nulldesc;
#ifndef PresentationManager
     ws->theCursor = -1;
     ws->iconic = NormalState;
     ws->posx = ws->posy = -1;
#else					/* PresentationManager */
     /* make the dependant list */
     if (!(ws->depContexts = calloc(INITDEPS, sizeof(wcontext *)))) {
       free(ws);
       return NULL;
       } /* End of if - allocation failed */
     ws->maxDeps = INITDEPS;
     /* make a mutex semaphore */
     DosCreateMutexSem(NULL, &(ws->mutex), 0, FALSE);
     /* we now have one more window */
     NumWindows++;
#endif					/* PresentationManager */
     ws->next = wstates;
     ws->previous = NULL;
     if (wstates) wstates->previous = ws;
     wstates = ws;
     } /* End of if - calloc success */
   return ws;
   }
/*
 * allocate a window binding structure
 */
wbp alc_wbinding()
   {
   int i;
   wbp wb;

   wb = (struct wbinding *) malloc(sizeof(struct wbinding));
   if (!wb) return NULL;
   wb->refcount++;

   wb->next = wbndngs;
   wb->previous = NULL;
   if (wbndngs)
      wbndngs->previous = wb;
   wbndngs = wb;
   return wb;
   }

/*
 * free a window binding.
 */
free_binding(w)
wbp w;
   {
   w->refcount--;
   if(w->refcount == 0) {
      if (w->window) free_window(w->window);
      if (w->context) free_context(w->context);
      if (w->previous) w->previous->next = w->next;
      else wbndngs = w->next;
      if (w->next) w->next->previous = w->previous;
      free(w);
      }
   }

/*
 * free a window state
 */
free_window(ws)
wsp ws;
   {
   ws->refcount--;
   if(ws->refcount == 0) {
#ifndef PresentationManager
      ws->bits |= 1;			/* SETZOMBIE */
      if (ws->win == (Window) NULL) {
#else					/* PresentationManager */
      HRGN hscrap;
      wcontext *wc;
      int i, j;

      /* remove this window from the context dependencies */
      for (i = 0; i < ws->maxDeps && ws->numDeps > 0; i++)
        if (wc = ws->depContexts[i]) {
          for (j = 0; j < wc->maxDeps; j++)
            if (wc->depWindows[j] == ws) {
              wc->depWindows[j] = NULL;
              wc->numDeps--;
              break;
              } /* End of if - found the mapping */
            ws->numDeps--;
            } /* End of if - found a valid dep */

      /* free the dependant list */
      free(ws->depContexts);
      /* remove the clip regions - if present */
      GpiSetClipRegion(ws->hpsBitmap, NULLHANDLE, &hscrap);
      if (ws->hpsWin)
        GpiSetClipRegion(ws->hpsWin, NULLHANDLE, &hscrap);
      /* kill the window - if this was done previously, there
         is no harm in calling this again */
      DestroyWindow(ws);
      /* now time to kill the bitmap stuff */
      GpiAssociate(ws->hpsBitmap, NULLHANDLE);
      GpiDestroyPS(ws->hpsBitmap);
      GpiDeleteBitmap(ws->hBitmap);
      DevCloseDC(ws->hdcBitmap);
      /* close the mutex semaphore */
      DosCloseMutexSem(ws->mutex);
      /* release the window background color */
      ReleaseColor(ws->winbg);
      /* destroy the initial bitmap */
      if (ws->hInitialBitmap)
        GpiDeleteBitmap(ws->hInitialBitmap);
      /* we are losing this puppy */
      NumWindows--;
#endif					/* PresentationManager */
	 if (ws->previous) ws->previous->next = ws->next;
	 else wstates = ws->next;
	 if (ws->next) ws->next->previous = ws->previous;
	 free(ws);
#ifndef PresentationManager
         }
#endif					/* PresentationManager */
      }
   }

/*
 * free a window context
 */
free_context(wc)
wcp wc;
   {
   wc->refcount--;
   if(wc->refcount == 0) {
#ifndef PresentationManager
      free_display(wc->display);
#else					/* PresentationManager */
      wstate *ws;
      int i, j;
      LONG tmp;

      /* free the pattern */
      ReleasePattern(wc->currPattern);
      /* free the font */
      ReleaseFont(wc->charBundle.usSet);
      /* release the foreground and background colors */
      tmp = (ISXORREVERSEW(wc)) ? wc->charBundle.lColor ^ wc->charBundle.lBackColor :
                                  wc->charBundle.lColor;
      ReleaseColor(tmp);
      ReleaseColor(wc->charBundle.lBackColor);

      /* remove this context from the window's dependencies */
      for (i = 0; i < wc->maxDeps && wc->numDeps > 0; i++)
        if (ws = wc->depWindows[i]) {
          if (ws->charContext == wc) ws->charContext = NULL;
          if (ws->areaContext == wc) ws->areaContext = NULL;
          if (ws->lineContext == wc) ws->lineContext = NULL;
          if (ws->imageContext == wc) ws->imageContext = NULL;
          if (ws->clipContext == wc) ws->clipContext = NULL;
          for (j = 0; j < ws->maxDeps; j++)
            if (ws->depContexts[j] == wc) {
              ws->depContexts[j] = NULL;
              ws->numDeps--;
              break;
              } /* End of if - found the mapping */
          wc->numDeps--;
          } /* End of if - a valid window pointer */
      /* free the dependant list */
      free(wc->depWindows);
#endif					/* PresentationManager */
      if (wc->previous) wc->previous->next = wc->next;
      else wcntxts = wc->next;
      if (wc->next) wc->next->previous = wc->previous;
      free(wc);
      }
   }

#ifndef PresentationManager
/*
 * free a display
 */
free_display(wd)
wdp wd;
   {
   wd->refcount--;
   if(wd->refcount == 0) {
      if (wd->cmap != DefaultColormap(wd->display, wd->screen))
	 XFreeColormap(wd->display, wd->cmap);
      XCloseDisplay(wd->display);
      if (wd->previous) wd->previous->next = wd->next;
      else wdsplys = wd->next;
      if (wd->next) wd->next->previous = wd->previous;
      free(wd);
      }
   }
#endif					/* PresentationManager */

/*
 * the next section consists of code to deal with string-integer
 * (stringint) symbols.  See xwindow.h.
 */

/*
 * string-integer comparison, for qsearch()
 */
int scmp(sip1,sip2)
siptr sip1, sip2;
{
  return strcmp(sip1->s,sip2->s);
}

/*
 * string-integer lookup function: given a string, return its integer
 */
int si_s2i(sip,s)
siptr sip;
char *s;
{
  stringint key;
  siptr p;
  key.s = s;
  p = (siptr)qsearch((char *)&key,(char *)(sip+1),sip[0].i,sizeof(key),scmp);
  if (p) return p->i;
  return -1;
}

/*
 * string-integer inverse function: given an integer, return its string
 */
char *si_i2s(sip,i)
siptr sip;
int i;
{
  register siptr sip2 = sip+1;
  for(;sip2<=sip+sip[0].i;sip2++) if (sip2->i == i) return sip2->s;
  return NULL;
}


/*
 * And now, the stringint data.
 * Convention: the 0'th element of a stringint array contains the
 * NULL string, and an integer count of the # of elements in the array.
 */

stringint attribs[] = {
   { 0,			NUMATTRIBS},
   {"ascent",		A_ASCENT},
   {"batch",		A_BATCH},
   {"bg",		A_BG},
   {"cliph",		A_CLIPH},
   {"clipw",		A_CLIPW},
   {"clipx",		A_CLIPX},
   {"clipy",		A_CLIPY},
   {"ceol",		A_CEOL},
   {"col",		A_COL},
   {"columns",		A_COLUMNS},
   {"cursor",		A_CURSOR},
   {"depth",		A_DEPTH},
   {"descent",		A_DESCENT},
   {"display",		A_DISPLAY},
   {"displayheight",	A_DISPLAYHEIGHT},
   {"displaywidth",	A_DISPLAYWIDTH},
   {"drawop",		A_DRAWOP},
   {"dx",		A_DX},
   {"dy",		A_DY},
   {"echo",		A_ECHO},
   {"fg",		A_FG},
   {"fheight",		A_FHEIGHT},
   {"fillstyle",	A_FILLSTYLE},
   {"font",		A_FONT},
   {"fwidth",		A_FWIDTH},
   {"geometry",		A_GEOMETRY},
   {"height",		A_HEIGHT},
   {"iconic",		A_ICONIC},
   {"iconimage",	A_ICONIMAGE},
   {"iconlabel",	A_ICONLABEL},
   {"iconpos",		A_ICONPOS},
   {"image",		A_IMAGE},
   {"leading",		A_LEADING},
   {"lines",		A_LINES},
   {"linestyle",	A_LINESTYLE},
   {"linewidth",	A_LINEWIDTH},
   {"pointer",		A_POINTER},
   {"pointercol",	A_POINTERCOL},
   {"pointerrow",	A_POINTERROW},
   {"pointerx",		A_POINTERX},
   {"pointery",		A_POINTERY},
   {"pos",		A_POS},
   {"posx",		A_POSX},
   {"posy",		A_POSY},
   {"reverse",		A_REVERSE},
   {"row",		A_ROW},
   {"textwidth:",	A_TEXTWIDTH},
   {"visual",		A_VISUAL},
   {"width",		A_WIDTH},
   {"windowlabel",	A_WINDOWLABEL},
   {"x",		A_X},
   {"y",		A_Y},
};

/*
 * There are more, X-specific stringint arrays in ../common/xwindow.c
 */

#else					/* XIcon */
static char x;			/* avoid empty module */
#endif					/* XIcon */

