/*
 * lnklist.c -- functions for handling file linking.
 */

#include "../h/gsupport.h"
#include "tproto.h"
#include "trans.h"
#include "lfile.h"

/*
 * Prototype.
 */
hidden	struct lfile *alclfile	Params((char *name));

struct lfile *lfiles;

/*
 * Dummy function to satisfy restriction on the length of the name of
 *  the first function in a file ... on a certain system.  Needs to
 *  be handled in a better fashion.
 */

/*
 * One of the developers of ... a certain system ... urges everyone to
 *  lighten up, and not take warning messages so seriously (and to
 *  look into the SName compilation option).
 */

novalue dummyda()
   {
   }

/*
 * alclfile allocates an lfile structure for the named file, fills
 *  in the name and returns a pointer to it.
 */
static struct lfile *alclfile(name)
char *name;
   {
   struct lfile *p;
   
   p = (struct lfile *) alloc(sizeof(struct lfile));
   if (!p)
      tsyserr("not enough memory for file list");
   p->lf_link = NULL;
   p->lf_name = salloc(name);
   return p;
   }

/*
 * addlfile creates an lfile structure for the named file and add it to the
 *  end of the list of files (lfiles) to generate link instructions for.
 */
novalue addlfile(name)
char *name;
{
   struct lfile *nlf, *p;
   
   nlf = alclfile(name);
   if (lfiles == NULL) {
      lfiles = nlf;
      }
   else {
      p = lfiles;
      while (p->lf_link != NULL) {
         p = p->lf_link;
         }
      p->lf_link = nlf;
      }
}
