/*----------------------------------------
   CLRCUBE.C -- Windows Color Cube
                (c) Charles Petzold, 1990
  ----------------------------------------*/

#include <windows.h>
#include "clrcube.h"

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG) ;

char szAppName [] = "ClrCube" ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     HWND     hwnd ;
     MSG      msg ;
     WNDCLASS wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "Color Cube",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

void DrawRect (HDC hdc, RECT *prc, COLORREF cr, WORD wType)
     {
     HBRUSH hBrush ;

     if (wType == IDM_PURE)
          cr = GetNearestColor (hdc, cr) ;

     hBrush = CreateSolidBrush (cr) ;

     FillRect (hdc, prc, hBrush) ;
     DeleteObject (hBrush) ;
     }

void DrawColorCube (HDC hdc, short cxClient, short cyClient, WORD wType)
     {
     COLORREF cr ;
     LONG     x, y ;
     RECT     rc ;

          // UL: Black, UR: Blue, LL: Green, LR: Cyan

     for (y = 0 ; y <= 16 ; y++)
          for (x = 0 ; x <= 16 ; x++)
               {
               rc.left   = (short) ( x      * cxClient / 68) ;
               rc.top    = (short) ( y      * cyClient / 51) ;
               rc.right  = (short) ((x + 1) * cxClient / 68) ;
               rc.bottom = (short) ((y + 1) * cyClient / 51) ;

               cr = RGB (0, min (255, 16 * y), min (255, 16 * x)) ;

               DrawRect (hdc, &rc, cr, wType) ;
               }

          // UL: Green, UR: Cyan, LL: Yellow, LR: White

     for (y = 0 ; y <= 16 ; y++)
          for (x = 0 ; x <= 16 ; x++)
               {
               rc.left   = (short) ( x       * cxClient / 68) ;
               rc.top    = (short) ((y + 17) * cyClient / 51) ;
               rc.right  = (short) ((x +  1) * cxClient / 68) ;
               rc.bottom = (short) ((y + 18) * cyClient / 51) ;

               cr = RGB (min (255, 16 * y), 255, min (255, 16 * x)) ;

               DrawRect (hdc, &rc, cr, wType) ;
               }

          // UL: Yellow, UR: White, LL: Red, LR: Magenta

     for (y = 0 ; y <= 16 ; y++)
          for (x = 0 ; x <= 16 ; x++)
               {
               rc.left   = (short) ( x       * cxClient / 68) ;
               rc.top    = (short) ((y + 34) * cyClient / 51) ;
               rc.right  = (short) ((x +  1) * cxClient / 68) ;
               rc.bottom = (short) ((y + 35) * cyClient / 51) ;

               cr = RGB (255, max (0, 255 - 16 * y), min (255, 16 * x)) ;

               DrawRect (hdc, &rc, cr, wType) ;
               }

          // UL: Cyan, UR: Blue, LL: White, LR: Magenta

     for (y = 0 ; y <= 16 ; y++)
          for (x = 0 ; x <= 16 ; x++)
               {
               rc.left   = (short) ((x + 17) * cxClient / 68) ;
               rc.top    = (short) ((y + 17) * cyClient / 51) ;
               rc.right  = (short) ((x + 18) * cxClient / 68) ;
               rc.bottom = (short) ((y + 18) * cyClient / 51) ;

               cr = RGB (min (255, 16 * y), max (0, 255 - 16 * x), 255) ;

               DrawRect (hdc, &rc, cr, wType) ;
               }

          // UL: Blue, UR: Black, LL: Magenta, LR: Red

     for (y = 0 ; y <= 16 ; y++)
          for (x = 0 ; x <= 16 ; x++)
               {
               rc.left   = (short) ((x + 34) * cxClient / 68) ;
               rc.top    = (short) ((y + 17) * cyClient / 51) ;
               rc.right  = (short) ((x + 35) * cxClient / 68) ;
               rc.bottom = (short) ((y + 18) * cyClient / 51) ;

               cr = RGB (min (255, 16 * y), 0, max (0, 255 - 16 * x)) ;

               DrawRect (hdc, &rc, cr, wType) ;
               }

          // UL: Black, UR: Green, LL: Red, LR: Yellow

     for (y = 0 ; y <= 16 ; y++)
          for (x = 0 ; x <= 16 ; x++)
               {
               rc.left   = (short) ((x + 51) * cxClient / 68) ;
               rc.top    = (short) ((y + 17) * cyClient / 51) ;
               rc.right  = (short) ((x + 52) * cxClient / 68) ;
               rc.bottom = (short) ((y + 18) * cyClient / 51) ;

               cr = RGB (min (255, 16 * y), min (255, 16 * x), 0) ;

               DrawRect (hdc, &rc, cr, wType) ;
               }

          // UL: Yellow, UR: White, LL: Blue, LR: Black

     for (y = 0 ; y <= 16 ; y++)
          for (x = 0 ; x <= 16 ; x++)
               {
               rc.left   = (short) ((x + 34) * cxClient / 68) ;
               rc.top    = (short) ( y       * cyClient / 51) ;
               rc.right  = (short) ((x + 35) * cxClient / 68) ;
               rc.bottom = (short) ((y +  1) * cyClient / 51) ;

               cr = RGB (max (0, 255 - 16 * y), max (0, 255 - 16 * y),
                         min (255, 16 * x + 16 * y - 2 * x * y)) ;

               DrawRect (hdc, &rc, cr, wType) ;
               }

          // UL: Magenta, UR: Red, LL: Green, LR: Cyan

     for (y = 0 ; y <= 16 ; y++)
          for (x = 0 ; x <= 16 ; x++)
               {
               rc.left   = (short) ((x + 34) * cxClient / 68) ;
               rc.top    = (short) ((y + 34) * cyClient / 51) ;
               rc.right  = (short) ((x + 35) * cxClient / 68) ;
               rc.bottom = (short) ((y + 35) * cyClient / 51) ;

               cr = RGB (max (0, 255 - 16 * y), min (255, 16 * y),
                         max (0, 255 - 16 * x - 16 * y + 2 * x * y)) ;

               DrawRect (hdc, &rc, cr, wType) ;
               }
     }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static short cxClient, cyClient ;
     static WORD  wType = IDM_DITHERED ;
     HDC          hdc ;
     HMENU        hMenu ;
     PAINTSTRUCT  ps ;

     switch (message)
          {
          case WM_COMMAND:
               hMenu = GetMenu (hwnd) ;

               switch (wParam)
                    {
                    case IDM_PURE:
                    case IDM_DITHERED:
                         CheckMenuItem (hMenu, wType, MF_UNCHECKED) ;
                         wType = wParam ;
                         CheckMenuItem (hMenu, wType, MF_CHECKED) ;

                         InvalidateRect (hwnd, NULL, TRUE) ;
                         return 0 ;
                    }

               break ;

          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               DrawColorCube (hdc, cxClient, cyClient, wType) ;

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY :
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
