PROGRAM iskind;
TYPE
  Pt = ^base;
  GrandAP = ^GrandA;
  GrandBP = ^GrandB;

  base = object
    CONSTRUCTOR Init;
    DESTRUCTOR Done;
    FUNCTION IsKindOf(T:Pointer):boolean; virtual;
    FUNCTION IsA:pointer;
  END;

  ChildA = object(base)
    CONSTRUCTOR Init;
    FUNCTION IsKindOf(T:Pointer):boolean; virtual;
    PROCEDURE WhoAreYou; virtual;
  END;

  ChildB = object(base)
    CONSTRUCTOR Init;
    FUNCTION IsKindOf(T:Pointer):boolean; virtual;
  END;

  GrandA = object(ChildA)
    CONSTRUCTOR Init;
    FUNCTION IsKindOf(T:Pointer):boolean; virtual;
    PROCEDURE WhoAreYou; virtual;
  END;

  GrandB = object(ChildB)
    CONSTRUCTOR Init;
    FUNCTION IsKindOf(T:Pointer):boolean; virtual;
  END;

(**** All the constructors and the destructor: ***)
  DESTRUCTOR Base.Done; BEGIN END;

  CONSTRUCTOR Base.Init; BEGIN END;
  CONSTRUCTOR ChildA.Init; BEGIN END;
  CONSTRUCTOR ChildB.Init; BEGIN END;
  CONSTRUCTOR GrandA.Init; BEGIN END;
  CONSTRUCTOR GrandB.Init; BEGIN END;

(**** The IsA method, used by all objects in the hierarchy: ****)
  FUNCTION base.IsA:pointer; BEGIN IsA:= TypeOf(self); END;

(**** All the IsKindOf methods: ****)
  FUNCTION base.IsKindOf(T:Pointer):boolean;
  BEGIN IsKindOf := (T=TypeOf(base)); END;

  FUNCTION ChildA.IsKindOf(T:Pointer):boolean;
  BEGIN IsKindOf := (T=TypeOf(ChildA)) OR base.IsKindOf(T); END;

  FUNCTION ChildB.IsKindOf(T:Pointer):boolean;
  BEGIN IsKindOf := (T=TypeOf(ChildB)) OR base.IsKindOf(T); END;

  FUNCTION GrandA.IsKindOf(T:Pointer):boolean;
  BEGIN IsKindOf := (T=TypeOf(GrandA)) OR ChildA.IsKindOf(T); END;

  FUNCTION GrandB.IsKindOf(T:Pointer):boolean;
  BEGIN IsKindOf := (T=TypeOf(GrandB)) OR ChildB.IsKindOf(T); END;

(**** WhoAreYou methods, for the objects that have them: ***)
  PROCEDURE ChildA.WhoAreYou; BEGIN WriteLn('I am a ChildA'); END;

  PROCEDURE GrandA.WhoAreYou; BEGIN WriteLn('I am a GrandA'); END;

  PROCEDURE Test(B1:Base; VAR B2 : base);
  BEGIN
    Write('The variable passed by reference SEEMS to be a ');
    IF B1.IsA = TypeOf(base) THEN WriteLn('base type');
    IF B1.IsA = TypeOf(ChildA) THEN WriteLn('ChildA type');
    IF B1.IsA = TypeOf(GrandA) THEN WriteLn('GrandA type');
    Write('The variable passed by value is a ');
    IF B2.IsA = TypeOf(base) THEN WriteLn('base type');
    IF B2.IsA = TypeOf(ChildA) THEN WriteLn('ChildA type');
    IF B2.IsA = TypeOf(GrandA) THEN WriteLn('GrandA type');
  END;

VAR P : Pt;
BEGIN
  P := New(GrandAP, Init);
  Test(P^, P^);

  If P^.IsKindOf(TypeOf(ChildA)) THEN
    BEGIN
      Write('The object says --> ');
      ChildA(P^).WhoAreYou;
    END
  ELSE WriteLn('The object does not have a "WhoAreYou" method.');
  Dispose(P,done);

  P := New(GrandBP, Init);
  If P^.IsKindOf(TypeOf(ChildA)) THEN
    BEGIN
      Write('The object says --> ');
      ChildA(P^).WhoAreYou;
    END
  ELSE WriteLn('The object does not have a "WhoAreYou" method.');
  Dispose(P,done);

  (* ChildA(P^).WhoAreYou;} *)(*This line will crash your system*)
END.
