#include <windows.h>
#include <qtw.h>

MovieFile mfMovie;
RECT rcMovie;
Movie mMovie;
MovieController mcController;

long FAR PASCAL __export WndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
    
    PAINTSTRUCT ps;

    // Drive the movie controller
    if (MCIsPlayerMessage (mcController, hWnd, message, wParam, lParam))
        return 0;

    // Process the windows message
    switch (message) {
        case WM_PAINT:
            if (!BeginPaint (hWnd, &ps))
                return 0;
            EndPaint (hWnd, &ps);
            return 0;
        case WM_DESTROY:
            PostQuitMessage (0);
            return 0;
    }

    // Return to Windows
    return DefWindowProc (hWnd, message, wParam, lParam);
}

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpszCmd, int nCmdShow) {

    HWND hWnd;
    MSG msg;
    WNDCLASS wndclass;
    
    static char szAppName[] = "QuickTime API";

    // Initialize QuickTime
    QTInitialize (NULL);
    EnterMovies ();

    // Register and create main window
    if (!hPrev) {
        wndclass.style = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon (NULL,IDI_APPLICATION);
        wndclass.hCursor = LoadCursor (NULL, IDC_ARROW);
        wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
        wndclass.lpszMenuName = NULL;
        wndclass.lpszClassName = szAppName;
        RegisterClass (&wndclass);
    }

    hWnd = CreateWindow (szAppName, szAppName, WS_CAPTION | WS_SYSMENU |
      WS_CLIPCHILDREN | WS_OVERLAPPED, CW_USEDEFAULT, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

    // Instantiate the movie and its controller
    OpenMovieFile ("SAMPLE.MOV", &mfMovie, OF_READ);
    NewMovieFromFile (&mMovie, mfMovie, NULL, NULL, newMovieActive, NULL);
    CloseMovieFile (mfMovie);
    GetMovieBox (mMovie, &rcMovie);
    OffsetRect(&rcMovie, -rcMovie.left, -rcMovie.top);
    mcController = NewMovieController (mMovie, &rcMovie, mcTopLeftMovie + mcScaleMovieToFit, hWnd);

    // Make the frame just big enough for the movie
    MCGetControllerBoundsRect (mcController, &rcMovie);
    AdjustWindowRect (&rcMovie, WS_CAPTION | WS_OVERLAPPED, FALSE);
    OffsetRect (&rcMovie, -rcMovie.left, -rcMovie.top);
    SetWindowPos (hWnd, 0, 0, 0, rcMovie.right, rcMovie.bottom, SWP_NOMOVE | SWP_NOZORDER);
    ShowWindow (hWnd, nCmdShow);
    UpdateWindow (hWnd);

    // Play the movie
    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    // Clean up
    DisposeMovieController (mcController);
    DisposeMovie (mMovie);
    ExitMovies ();
    QTTerminate ();

    // Return to Windows
    return msg.wParam;
}

