/*

Plot3d -- graph.c, the graphics code

By Adrian Mariano -- adrian@milton.u.washington.edu


Copyright (c) 1991 by Adrian Mariano

You may use and distribute this program as much as you like so long as you do 
not charge for this service.  I am not liable for failure of this program to 
perform in any way.  

*/


#include <graphics.h>
#include <conio.h>
#include <dos.h>


int returnmode, maxx, maxy, mode;

/* This function should return to text mode from graphics mode */

void backtotext()
{
   restorecrtmode();
   textmode(returnmode);
}


/* Enter graphics mode from text mode */

void entergraphics()
{
   setgraphmode(mode);
   cleardevice();
   setfillstyle(1, 0);		/* Sections will be black filled */
}


/* Do graphics initialization, including setting maxx and maxy to the
   maximum x and y values */

void initgraphics()
{
   int mm, driver = DETECT;
   char *path;
   struct text_info ti;
   gettextinfo(&ti);
   if (ti.screenheight == 50 || ti.screenheight == 43)
      returnmode = C4350;
   else
      returnmode = C80;
   path = "";
   detectgraph((int far *) (&driver), (int far *) (&mode));
   initgraph((int far *) (&driver), (int far *) (&mode), (char far *) (path));
   if ((mm = graphresult()) != grOk) {
      printf("Error: %d\n", mm);
      exit(0);
   }
   maxx = getmaxx();
   maxy = getmaxy();
   backtotext();
}


/* Draw the quadrilateral specified by the four coordinate pairs, filled
   in with a different color than the boundaries are drawn in */

#pragma argsused

void fill(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4)
{
   fillpoly(4, MK_FP(_SS, &x1));
}

/* Draw a line */

void drawline(int x1, int x2, int x3, int x4)
{
   line(x1, x2, x3, x4);
}
