/*
 * Initialization module for PMAUX
 *
 * Written by William S. Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define INCL_PM
#include <os2.h>
#include <stddef.h>
#include <ttycls.h>
#include "pmaux.h"

BOOL FAR InitProgram(int argc, char *argv[])
{

    char szTitle[50];
    ULONG ctldata;

  /* get anchor block handle and message queue handles */
    if ((hAB = WinInitialize(NULL)) == NULL)
	return FALSE;

    if ((hmqMsgQ = WinCreateMsgQueue(hAB,0)) == NULL)
        return FALSE;

  /* get handle to the local heap so we can use it later */
    if ((hHeap = WinCreateHeap(0, 0, 0, 0, 0, 0)) == NULL)
	return FALSE;

  /* This string is needed to register the Window */
    WinLoadString(hAB,NULL, IDS_APPNAME, sizeof(szAppName), (PSZ)szAppName);

  /* register window */
    if (!WinRegisterClass(hAB, 			/* anchor block handle */
			  (PCH)szAppName, 	/* class name */
			  (PFNWP)MainWndProc,	/* window procedure for class */
			  CS_SIZEREDRAW,   	/* class styles */
			  0))			/* no extra data needed */
	return FALSE;

  /* This string is needed to create the frame window */
    WinLoadString(hAB, NULL, IDS_TITLE, sizeof(szTitle), (PSZ)szTitle);

    ctldata = FCF_STANDARD;

  /* create window */
    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,	/* parent */
				   WS_VISIBLE,
				   &ctldata,
                                   (PCH)szAppName,	/* class */
                                   (PCH)szTitle,	/* window title */
                                   0L,			/*default client style*/
                                   (HMODULE)NULL,	/* resources in .EXE */
                                   ID_RESOURCE,
                                   (HWND FAR *)&MWnd.hWnd);
							/* handle to client */

  /* fail if creation of either window or video buffer fails */
    if ((hwndFrame == NULL) || (MWnd.pVidBuf == NULL))
	return FALSE;

  /* show the window */
    WinShowWindow(hwndFrame, TRUE);

  /* set the handle into OS2.ini */
    if (!SetOS2Ini(MWnd.hWnd))
        return FALSE;

    return TRUE;
}

/* called when client is created */
void FAR WndCreate(HWND hWnd)
{

    FONTMETRICS FM;
    HPS hPS;
    short width, height, cwidth, cheight;

  /* get the size of an icon */
    xIconsize = WinQuerySysValue(HWND_DESKTOP, SV_CXICON);
    yIconsize = WinQuerySysValue(HWND_DESKTOP, SV_CYICON);

  /* load the icon string */
    WinLoadString(hAB, NULL, IDS_ICON, (USHORT)sizeof(szIcon), (PSZ)szIcon);

  /* get the system font character metrics */
    hPS = WinGetPS(hWnd);
    GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &FM);
    cwidth = (short)(FM.lMaxBaselineExt + FM.lExternalLeading);
    cheight = (short)FM.lAveCharWidth;
    WinReleasePS (hPS);

  /* get other parameters */
    width = (SHORT)WinQuerySysValue(HWND_DESKTOP, SV_CXFULLSCREEN);
    height = (SHORT)WinQuerySysValue(HWND_DESKTOP, SV_CYFULLSCREEN);

  /* create the video buffer with the following parameters */
    InitTTYWindow(&MWnd,0,0,width,height,cwidth,cheight,FALSE,TRUE,TRUE,0xff);
}
