/* LISTING 1 */

/*   This Btrieve-required structure holds information about one key 
 *   (or one segment of a key if the key is segmented). 
 *   It needs to be defined before the file structure
 *   since it will be included.
 */


struct keyspec         /* key segment structure specification */
{     int  key_pos;    /* start position in record for key segment */
      int  key_len;    /* length of key segment */
      int  key_flag;   /* a vector of bit flags describing
                          attributes of the key */
      long key_tot;    /* unique key count (no dups, nulls)
                          returned by STATUS operation */
      char key_type;   /* a vector of bit flags used to define
                          the data type */
      char null_char;  /* define value of null key (0 or space) */
      char reserve1[4];
};



/*   This Btrieve-required structure holds information about one file. 
 *   It also includes the key structure dimensioned to the maximum 
 *    number of keyed fields within a record.
 */

#define MAX_KEYS  12      /* max indices per file */
#define MAX_KEY_SEGS  22  /* max indices (count segments) per file */


struct filespec               /* file structure specification */
{       int  recl;            /* record length */
        int  page_size;
        int  index_count;     /* number of indexes */
        long tot_recs;        /* total active (non-deleted)
                                 records returned by STATUS operation */
        int  file_flags;      /* a vector of bit flags describing
                                 file attributes (see manual) */
        char reserve2[2];     /* (unused) */
        int  pre_alloc_pages; /* if file is to be pre-allocated assign # 
                                 of pages */


        /* Note that Btrieve deals with this struct only to this point.
         * We have appended the key structures for our own convenience.
         */


        struct keyspec keybuf[ MAX_KEY_SEGS ]; /* see above */
};


/* LISTING 2 */

struct btfhand
{    char fname[30];          /* file name */
     char pos_blk[128];       /* position block for Btrieve's use */
     long max_var_recl;       /* longest variable recl allowed */
     char owner[25];          /* file owner name */
     int owner_mode;          /* a vector of bit flags used
                                 to set owner lock, data decryption */
};

struct btfkey                      /* key information for one file */
{    int  totsegs;                 /* how many key segments in the file */
     int  num_segs[ MAX_KEYS ];    /* number of segments for this key */
     int  start_seg[ MAX_KEYS ];   /* starting segment for each key */
     char *name[ MAX_KEYS ];       /* what users call this access path */
};


/* LISTING 3 */

/*   ---------- Btrieve loaded into memory -----------
**    Btrieve puts 033H in interrupt vector 7BH when loaded.


**    Peek at address 7B x 4  = 1ECH
*    -----------------------------------------------------------
*/


void check_bt_loaded()
{
     unsigned resident;

     /* Peek at the interrupt vector */
     if (( resident = peekb(0,0x1EC)) != 0x33)
          puts("MEMORY RESIDENT BTRIEVE NEEDS TO BE LOADED." );
     return;
}


/* LISTING 4 */

void btinit0()       /* initialize TABLE file -- file zero */
{
     /* Initialize Btrieve required Structures */
     btstruct[ O ].recl    = 100;         /* init record length */
     btstruct[ 0 ].page_size = 1024;
     btstruct[ 0 ].index_count = 2;       /* not segments */
     btstruct[ 0 ].file_flags = 0;    /* fixed length */


     /* First Index, first segment */
     btstruct[ TABLEF ].keybuf[0].key_pos = 0;
     btstruct[ TABLEF ].keybuf[0].key_len = 2;
     btstruct[ TABLEF ].keybuf[0].key_flag = MOD | SEG | EXT_TYPE ;
     btstruct[ TABLEF ].keybuf[0].key_type = 1;     /* integer */


     /*  key is modifiable, segmented (with segments to follow), */
     /*  extend data type is integer */


     /* First Index, second (and last) segment */
     btstruct[ 0 ].keybuf[1].key_pos  = 50;
     btstruct[ 0 ].keybuf[1].key_len  = 2;
     btstruct[ 0 ].keybuf[1].key_flag = DUP | OK_NULL ;
     btstruct[ 0 ].keybuf[0].key_type = 0;     /* ascii string */
     btstruct[ 0 ].keybuf[1].null_char = 0x20; /* SPACE */


     /*  key has duplicates, null keys allowed */
     /*  null key is defined as space */


     /* Initialize other structures as needed */


     strcpy( fh[0].fname, "TABLE.DAT");  /* assign file name */
     fkey[0].totsegs     = 4;            /* total segments for the file */
     fkey[0].name[0] = "WOOD";           /* name of index 0 */


     /* continue required initialization */

     return;
}


/* LISTING 5 */

/*   Call bt_file() when the file structure is required 
 *      in the data buffer argument.
 *   Operations:  create(14), stat(15)
 */


int bt_file( opcode, fn )
int opcode;         /* Btrieve operation code */
int fn;             /* file number */
{
struct filespec *fptr = &btstruct[fn];   /* ptr to the file struct */
int buflen=sizeof( struct filespec );
int btstat;
char ext_fname[64];      /* name of file extended across a disk partition */
int in=0;                /* index */


  if (opcode==B_STAT)  {
     btstat = BTRV(opcode, fh[fn].pos_blk, fptr, &buflen, ext_fname, in);
     if (btstat)  {
          /* error handling */
     }
     else 
        printf("%s%s %ld", "Record count for ",fh[fn].fname, fptr->recl);
  }

  else  {
     btstat = BTRV(opcode, fh[fn].pos_blk, fptr, &buflen, fh[fn].fname,in);


     if ( btstat == 20 )  printf("\nBtrieve needs to be loaded.\n");
  }
  return( btstat );
}
/*    Call bt_openclose() to open or close a Btrieve file.
 *    All of the file locking is handled here.
 *        ---file locking---
 *        -1 = accelerated mode
 *        -2 = user has r/o access, others have normal access.
 *        -4 = exclusive lock - no one else can open it
 *
 *    Operations:  open(0), extend(16), close(1)
 */


int bt_openclose( opcode, fn, lock )
int opcode;         /* Btrieve operation code */
int fn;             /* our file number */
int lock;           /* locking information switch */
{
int buflen,btstat;


     buflen = strlen( fh[fn].owner );


     btstat = BTRV(opcode, fh[fn].pos_blk, fh[fn].owner, &buflen,
                    fh[fn].fname, lock);


     if (btstat)  {
          /* Place error function call here */
     }
     return( btstat );
}


/* LISTING 6 */

#define bt_open(fn,lock)   bt_openclose(0,fn,lock)
#define bt_close(fn)       bt_openclose(1,fn,0)
#define bt_extend(fn)      bt_openclose(16,fn,0)


/* LISTING 7 */

/*   Call bt_read() when data is to be retrieved.
 *
 *   Operations:
 *   get_pos(22)     Get record position # in databuf
 *   get_direct(23)  Get data by sending the record position
 *                   (returned from get_pos()) in data buffer
 *   get_equal(5)    The key buffer must be padded or
 *                   formatted to match exactly.
 *
 *   version(26), step_direct(24), unlock(27)
 *
 *   These operations will return duplicates:
 *   get_first(12), get_next(6), get_prev(7), get_last(13)
 *
 *   These operations won't return duplicates:
 *   get_greater(8), get_less(10), get_gr_eql(9), get_less_eq(11)
 */

int bt_read(op_code, fn, in, databuf, keyval, lock )
int opcode;         /* Btrieve operation code */
int fn;             /* file number */
int in;             /* index number */
char *databuf;      /* data record buffer */
char *keyval;       /* key value */
int lock;           /* application dependant locking # */
{
int buflen;


     opcode += lock;               /* add optional locking */
     buflen = btstruct[fn].recl;
     btstat = BTRV( opcode, fh[fn].pos_blk, databuf, &buflen, keyval, in);
     if ( btstat )  {
          /* Place error function call here */
     }
     return( btstat ) ;
}

/*    Pass bt_write() a valid data record.
 *
 *    Operations:  insert(2), update(3), delete(4), unlock(27)
 */


int bt_write( opcode, fn, in, databuf, keyval )
int opcode;         /* Btrieve operation code */
int fn;             /* our file number */
int in;             /* number of index to be used for this operation */
char *databuf;      /* data buffer */
char *keyval;       /* key value */
{
int buflen = btstruct[fn].recl;


     btstat = BTRV(op_code, fh[fn].pos_blk, databuf, &buflen, keyval, in);


     if ( btstat )  {
        /* Place error function call here. */
     }
     return( btstat ) ;
}

/*    Call bt_getkey() for a fast key lookup.
 *
 *    Operations:  Getkey(50+) for opcodes 5-13.
 */


/* LISTING 8

int bt_getkey( op_code, fn, in, keyval )
int op_code, fn, in;        /* as before */
char *keyval;
{
int btstat;
int buflen=4;
char dummybuf[4];


     btstat = BTRV(op_code, fh[fn].pos_blk, dummybuf, &buflen, keyval, in);


     if (btstat)  {
               /* Place error function call here. */
     }
     return( btstat ) ;
}
/*   Call bt_spec() as a general purpose function which needs
 *                  and/or returns the key buffer at best.
 *
 *   Operations:  reset(28), stop(25),
 *                begin_trans(19), end_trans(20), abort_trans(21)
 *
 *   get_dir(18)  Directory information is sent or returned
 *   set_dir(17)  in the key buffer for these operations.
 */


int bt_spec( op_code, fn, in, keyval )
int op_code, fn, in;
char *keyval;
{
int buflen=4;
char dummybuf[4];
int btstat;


   btstat = BTRV(op_code, fh[fn].pos_blk, dummybuf, &buflen, keyval, in);
   if (btstat)  {
               /* error handling */
   }
   return( btstat ) ;
