PAGE 56,132
TITLE SLBox.ASM - QBasic bin file for Single Line boxes 
;
; SLBox.ASM - (C)1991 by Brent Ashley
; draws single line box - called from QBasic 
; Parameters: Top, Left, Bot, Rgt, Attr, Shad
; Returns: nothing
;
; written with Microsoft QC/QuickAssembler v2.51
;

; equates for box characters
ULC = 218
URC = 191
LLC = 192
LRC = 217
HOR = 196
VER = 179
SPC = 32

; macros
LoadParmB MACRO Parm,Dest
  mov bx,Parm
  mov al,[bx]
  mov Dest,al
ENDM

SetCur MACRO Row,Col
  ; set cursor position
  push dx
  mov ah,02
  sub bh,bh
  mov dh,Row
  mov dl,Col
  int 10h
  pop dx
ENDM

PutChar MACRO Row,Col,Char,Colr,Count
  SetCur Row,Col
  ; print char using BIOS
  mov ah,09h
  mov al,Char
  sub bh,bh
  mov bl,Colr
  xor cx,cx
  mov cl,Count
  int 10h
ENDM

ShadowChar MACRO
  ; get current char
  mov ah,08
  sub bh,bh
  int 10h
  ; rewrite it in shadow colour
  mov ah,09h
  mov bx,0008h
  mov cx,1
  int 10h
ENDM

; procedure
.MODEL  medium, BASIC
.CODE

SLBox  PROC  _Top:PTR BYTE, _Lft:PTR BYTE, \
             _Bot:PTR BYTE, _Rgt:PTR BYTE, \
             _Attr:PTR BYTE, _Shad:PTR BYTE

Local Wid:BYTE, Mid:BYTE, \
      Top:BYTE, Lft:BYTE, \
      Bot:BYTE, Rgt:BYTE, \
      Attr:BYTE, Shad:BYTE, \
      CurRow:BYTE

  ; load coordinates and attribute into stack vars
  LoadParmB _Top,Top
  dec Top                ; adjust for 0-based BIOS cursor positions
  LoadParmB _Lft,Lft
  dec Lft
  LoadParmB _Lft,Mid      ; mid is position to print middle (lft+1) 
  LoadParmB _Bot,Bot
  dec Bot
  LoadParmB _Rgt,Rgt
  dec Rgt
  LoadParmB _Attr,Attr
  LoadParmB _Shad,Shad

  ; calc width
  mov al,Rgt
  sub al,Lft
  dec al
  jnz StoreWid 
  inc al                ; if width is 0, make it 1
StoreWid:
  mov Wid,al

  ; init current row
  mov al,Top
  mov CurRow,al

TopLine:
  PutChar CurRow,Lft,ULC,Attr,1
  PutChar CurRow,Mid,HOR,Attr,Wid
  PutChar CurRow,Rgt,URC,Attr,1

Middle:
  inc CurRow            ; next row
  mov al,Bot            ; at bottom?
  cmp CurRow,al
  jne MidLine           ; no - print middle line  
  jmp BottomLine        ; yes - jump to bottomline

MidLine:
  PutChar CurRow,Lft,VER,Attr,1
  PutChar CurRow,Mid,SPC,Attr,Wid
  PutChar CurRow,Rgt,VER,Attr,1
  jmp Middle            ; go to do next line

BottomLine:
  PutChar CurRow,Lft,LLC,Attr,1
  PutChar CurRow,Mid,HOR,Attr,Wid
  PutChar CurRow,Rgt,LRC,Attr,1

  cmp Shad,0            ; is shadow requested?
  jne Shadow            ; yes - do it
  jmp ByeBye            ; no - bye

Shadow:  
  inc Bot               ; shadow offset
  inc Lft     
ShadowBottom:
  inc Lft
  SetCur Bot,Lft
  ShadowChar
  mov al,Lft
  sub al,2
  cmp al,Rgt            ; end of line?
  jl ShadowBottom       ; no - shadow more chars

  inc Rgt               ; shadow offset
  mov al,Top
  mov CurRow,al
  mov dl,Rgt            ; save Rgt 
ShadowRight:
  mov Rgt,dl
  inc CurRow
  SetCur CurRow,Rgt     ; shadow rgt
  ShadowChar
  inc Rgt
  SetCur CurRow,Rgt     ; shadow rgt+1
  ShadowChar
  mov al,CurRow
  cmp al,Bot            ; at bottom?
  jl ShadowRight        ; no - shadow more

ByeBye:
  ret


SLBox ENDP

END

