#!/bin/sh
# The shell command to remove <CR>'s from this file are:
# $ tr -d "\015" < pc2unix.sh > xx
# $ mv xx pc2unix.sh
# Or, you may use vi or any other editor.

BACKSLASH='\\'
echo "NOTE: YOU HAVE TO FIRST REMOVE THE <CR> CHARACTERS IN THIS FILE"
echo "PC2UNIX.SH BY HAND --- USE vi OR THE FOLLOWING SHELL COMMANDS::"
echo "$ tr -d \"${BACKSLASH}015\" < pc2unix.sh > xx"
echo "$ mv xx pc2unix.sh"
echo
echo "Only then will this program work...."

#
# Run this command to remove the <CR> character from the pair <CR><LF>
# inserted in text files on the PC.
# Used to make the PC files palatable to a UNIX system.
# This program also moves the font files around, since they are handled
# diferently on an UNIX system (mainly because file name's
# on an UNIX system may be longer than on PC systems......)

FILES="./changes
./copyrt
./doc/dvnc.itx
./doc/dvng.itx
./doc/dvnc.ps
./doc/dvng.ps
./doc/flag.ips
./doc/idoc.itx
./doc/idoc.ps
./doc/nehru.itx
./doc/vnehru.itx
./doc/readme
./doc/s1.ips
./doc/s1.itx
./doc/s2.ips
./doc/s2.itx
./doc/tamil.itx
./doc/tamil.ps
./doc/tech.tex
./install.pc
./install.unx
./lib/devnac.afm
./lib/dvnc.ifm
./lib/mdvnc.ifm
./lib/dvng.ifm
./lib/dvpn10.mf
./lib/mdvng.ifm
./lib/devnac.ps
./lib/dvipsrc
./lib/itrans.pro
./lib/psfonts.map
./lib/readme
./lib/shenv
./lib/tamil.mf
./lib/tamilmax.mf
./lib/wntamil.mf
./lib/wntml.ifm
./lib/wntml10.mf
./lib/wntml12.mf
./lib/wntml17.mf
./readme
./src/deansify.c
./src/dodeans
./src/font.c
./src/ichar.c
./src/ifm.h
./src/ilex.l
./src/imap.h
./src/itops.c
./src/itotex.c
./src/itrans.1
./src/itrans.c
./src/itrans.h
./src/iyacc.y
./src/lang.c
./src/lexyyc
./src/makefile
./src/makefile.tcc
./src/makefile.gcc
./src/makefile.unx
./src/pifm.c
./src/prips
./src/prips.1
./src/utils.c
./src/ytabc
./src/ytabh
./version.h"

echo "Removing the CR character in these files..."
for i in $FILES
do
    echo File: $i
    chmod +rw $i
    tr -d "\015" < $i > xxx.xxx
    mv xxx.xxx $i
done

echo Moving the wntmlpk files to lib from lib/300dpi
echo "(This is the Tamil font.)"

mv lib/300dpi/wntml10.pk lib/wntml10.300pk
mv lib/300dpi/wntml12.pk lib/wntml12.300pk
mv lib/300dpi/wntml17.pk lib/wntml17.300pk
rmdir lib/300dpi

echo "pc2unix: All done"
exit 0
