/*
 *========================================================================== 
 * Copyright 1991 Avinash Chopde, All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Avinash Chopde not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * Avinash Chopde makes no representations about the suitability of this
 * software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Avinash Chopde, 1991
 *	    C2 Colonial Drive #4, Andover, MA 01810, USA.
 *
 */

static char S_RCSID[] = "$Header: e:/itrans/src/rcs/itops.c 1.3 91/10/13 16:50:43 avinash Exp $";

#include "itrans.h"

/* =================================================================== */
/* =================================================================== */
int cus_to_ps(comp_unit_t* cus, /* chain of PostScript Chars to output */
	      int fsize,
	      char pscomm[]) /* the postscript commands returned here */
{
    int dx, dy, pcode;

    strcpy(pscomm, "(");
    pscomm += strlen(pscomm); /* point to start to next segment */

    while (cus) {
	dx = cus->deltax;
	dy = cus->deltay;
	pcode = cus->u_pschar;

#ifdef DEBUG
fprintf(stderr, "tops: constructing char: dx %d dy %d pcode %d\n", dx, dy, pcode);
#endif /*DEBUG*/

	if (dx != 0 || dy != 0) {
	    if (*(pscomm - 1) == '(') *--pscomm = '\0';
	    else {
		sprintf(pscomm, ") show ");
		pscomm += strlen(pscomm);
	    }

	    sprintf(pscomm, "%.3f %s %.3f %s rmoveto (",
			dx / 1000.0, EMTOPS, dy / 1000.0, EMTOPS);
	    pscomm += strlen(pscomm);
	    
	}

	if (pcode != NO_PSCHAR) {
	    if (isprint(pcode)) *pscomm++ = pcode;
	    else { 
		sprintf(pscomm, "\\%03o", pcode);
		pscomm += strlen(pscomm);
	    }
	}
	
	/* if any Y movement was made, restore back the correct
	 * Y coordinate (the baseline)
	 */
	if (dy != 0) {
	    if (*(pscomm - 1) == '(') *--pscomm = '\0';
	    else {
		sprintf(pscomm, ") show ");
		pscomm += strlen(pscomm);
	    }

	    sprintf(pscomm, "%.3f %s %.3f %s rmoveto (",
			0.0, EMTOPS, - dy / 1000.0, EMTOPS);
	    pscomm += strlen(pscomm);
	}


	cus = cus->next;
    } /* while cus */

    if (*(pscomm - 1) == '(') *--pscomm = '\0';
    else {
	sprintf(pscomm, ") show ");
	pscomm += strlen(pscomm);
    }
    strcpy(pscomm, "\n");
    return TRUE;
}
/* =================================================================== */
int outps_start(int fsize)
{
    printf("/%s %d def /endy endy %s sub def 50 endy moveto\n",
			EMSIZE, fsize, EMSIZE);
    return TRUE;
}
int outps_end()
{
    printf("\nshowpage\n");
    return TRUE;
}
/* ============================^ itops.c ^ =========================== */
