/*
 *========================================================================== 
 * Copyright 1991 Avinash Chopde, All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Avinash Chopde not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * Avinash Chopde makes no representations about the suitability of this
 * software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Avinash Chopde, 1991
 *
 */

static char S_RCSID[] = "$Header: e:/itrans/src/rcs/itrans.c 1.9 91/10/14 20:18:06 avinash Exp $";

#include "itrans.h"
#include "ifm.h"

static char S_copyright[] = "\
%%\n\
%% ----------------------------------------------------------------\n\
%% Output from:\n\
%% itrans %s, Copyright 1991 Avinash Chopde, All Rights Reserved.\n\
%% ----------------------------------------------------------------\n\
%%\n\
";

/* =================================================================== */
#ifdef TCC
/* Under Turbo-C++, declare the stacklen to be larger */
extern unsigned _stklen = 7000U;
#endif
/* =================================================================== */

int G_verbose;

int G_currfontsize;
int G_psout; /* if TRUE produce PostScript output, else TeX output */

static allfonts_t	S_allfonts;
static lang_t		S_langs[LANGS_MAX];

font_t*			G_current_font=NULL; /*GLOBAL*/


static void S_usage(FILE*);

/* =================================================================== */
void cc_toany(letter_t dlet, font_t* mfontptr, char* comm, int* wid)
{
    int i, x, y;
    static comp_unit_t	cus[100]; /* static just to over the PC's 
		* stack size limits...!
		*/

    i = make_letter(mfontptr, dlet, cus, 100, &x, &y, wid);

    if (i > 0) {

	if (G_psout) cus_to_ps(cus, G_currfontsize, comm);
	else cus_to_tex(cus, G_currfontsize, comm);

    }

} /* cc_toany() */

/* =================================================================== */

process_letter(letter_t in)
{
    static char comm[CONVWORD_LEN];
    /* must be large enough to store one word -
     * which in TeX can get very large..what with raise boxes, \char defs etc
     * made it static since it is currently 8K bytes, and on the PC stack
     * space is at a premium...
     */

    int c1, c2, v, wid;
    /* Check for output validity */
    if (G_psout && G_current_font->prop == TEX_FONT) {
	fprintf(stderr, "Font %s is for TeX output only - cannot do PostScript out\n", G_current_font->fname);

	/***** EXITS HERE *****/
	exit(1);
	/* return FALSE; */
    }

    /*
    fprintf(stderr, ":offset is %d in.v %d, in.c1 %d, in.c2 %d\n", OFFSET_TOK,
    			in.v, in.c1, in.c2);
    */

    if (in.v < OFFSET_TOK && in.v != HALF_FORM && in.v != IMPLICIT_FORM) {
        fprintf(stderr,"illegal vowel val (c[0] is %d) - will use 'a' form\n", in.cons[0]);
    }


    switch(in.type) {
    case VOWEL_TYPE:
	v = _I_(in.v);
#ifdef DEBUG
fprintf(stderr, "process_letter: vowel %d\n", v);
#endif /*DEBUG*/
	cc_toany(in, G_current_font, comm, &wid);

	break;
    case SPECIAL_TYPE:
	c1 = _I_(in.cons[0]);
	in.v = IMPLICIT_FORM; /* all specials printed in implicit form */

#ifdef DEBUG
fprintf(stderr, "process_letter: special %d\n", c1);
#endif /*DEBUG*/
	
	cc_toany(in, G_current_font, comm, &wid);

	break;
    case CONSONANT_SINGLE_TYPE:
	c1 = _I_(in.cons[0]);
	v = _I_(in.v);
#ifdef DEBUG
fprintf(stderr, "process_letter: cons single %d vowel %d\n", c1, v);
#endif /*DEBUG*/
	
	cc_toany(in, G_current_font, comm, &wid);

	break;

    case CONSONANT_DOUBLE_TYPE:
	c1 = _I_(in.cons[0]);
	c2 = _I_(in.cons[1]);
	v = _I_(in.v);

#ifdef DEBUG
fprintf(stderr, "process_letter: cons double %d %d vowel %d\n", c1, c2, v);
#endif /*DEBUG*/
	cc_toany(in, G_current_font, comm, &wid);

	break;

    case CONSONANT_MANY_TYPE:
	c1 = _I_(in.cons[0]);
	c2 = _I_(in.cons[1]);
	v = _I_(in.v);

#ifdef DEBUG
fprintf(stderr, "process_letter: cons many %d %d vowel %d\n", c1, c2, v);
#endif /*DEBUG*/
	cc_toany(in, G_current_font, comm, &wid);

	break;
    }

    fputs(comm, stdout);

    if (G_psout) printf("\n");

    return TRUE;
}

/* =================================================================== */
int main(int argc, char *argv[])
{
    static char ifmfname[NAMELEN];
    static char ifmcmd[NAMELEN];
		/* static just to overcome the PC's stack size limitations */

    extern int yydebug;
    int ch;
    int psout;
    extern char * optarg;
    
#ifdef sgi
    mallopt(M_DEBUG, TRUE);
#endif

    for (ch = 0; ch < FONTS_MAX; ch++) S_allfonts[ch] = NULL;

    ifmfname[0] = '\0';
    G_currfontsize = 30;
    G_verbose = 0;
    psout = FALSE; /* by default, produce TeX output */

	/* --- Collect Args */
    strcpy(ifmfname, DEVN_IFM_FILE);

    while ((ch = getopt(argc, argv, "hHPI:f:o:i:v")) != EOF) {
	switch (ch) {
	case 'h':
	case 'H':
	   S_usage(stderr);
	   exit(0);
	   break;
	case 'v':
	   G_verbose++;
	   break;
	case 'P':
	   psout = TRUE;
	   break;
	case 'I':
	   strcpy(ifmfname, optarg);
	   break;
	case 'f':
	   sscanf(optarg, "%d", &G_currfontsize);
	   break;
	case 'i':
	   if (!freopen(optarg, "r", stdin)) {
	       fprintf(stderr,"Error: Could not open %s for reading\n", optarg);
	       exit(1);
	   }
	   break;
	case 'o':
	   if (!freopen(optarg, "w", stdout)) {
	       fprintf(stderr,"Error: Could not open %s for writing\n", optarg);
	       exit(1);
	   }
	   break;
	default:
	   S_usage(stderr);
	   break;
	} /* switch */
    }
    
    G_psout = psout;

    for (ch = 0; ch < FONTS_MAX; ch++) {
	S_allfonts[ch] = NULL;
    }
    init_langs(S_langs, LANGS_MAX);

    /* construct a line with a ifm command, so that
     * the find_load_ifm function in lang.c can handle the loading...
     */
    sprintf(ifmcmd, "\\indianifm=%s", ifmfname);

    /* load in the default ifm file... */

    if (!find_load_ifm(&S_langs[0], S_allfonts, ifmcmd)) {
	 fprintf(stderr, "Warning: could not load default IFM %s (hope you don't need it..ERROR otherwise..)\n", ifmfname);
    }

    G_current_font = S_langs[0].curr_font; /* default font */

    /* dump_font(S_allfonts[0], stderr); */

    yydebug = 0;
    if (psout) {
	printf("%%!PS\n%% *** Need files devnac.ps and itrans.pro before this line..\n");
	fprintf(stderr, "** itrans, version %s (PostScript Interface)\n", ITRANS_VER);
    } else {
	fprintf(stderr, "** itrans, version %s (TeX Interface)\n", ITRANS_VER);
    }

    printf(S_copyright, ITRANS_VER);

    if (psout) {
	outps_start(G_currfontsize);
	printf("/DevnacPlain findfont %s scalefont setfont\n", EMSIZE);
	printf("/BASEFONTNAME /DevnacPlain def\n");
    } else {
	outtex_start();
    }

    yyparse();

    if (psout) outps_end();
    else outtex_end();

    return 0;
}
/* =================================================================== */
process_newline()
{
    if (G_psout) printf("%%\nnewline\n");
    else printf("\n");
    return TRUE;
}
/* =================================================================== */
process_space()
{
    if (G_psout) printf("( ) show ");
    else printf(" ");
    return TRUE;
}
/* =================================================================== */
process_otherchar(int c)
{
    if (G_psout) {
	if (c != '{' && c != '}') printf("(%c) show ", c);
    }
    else putchar(c);

    if (!ispunct(c) && !isdigit(c) && !isspace(c))  {
        fprintf(stderr, "Note (around line %d): character <%c> (dec %d) unrecognized by lexer, echoing to output\n", G_lineno, c, c);
    }
    return TRUE;
}
/* =================================================================== */
process_init_word(char* word)
{
    printf("%% previous word:<%s>\n", word);
    return TRUE;
}
/* =================================================================== */
process_end_word(char* word)
{
    /*
    Can't print a comment here, since in TeX everything following 
    also becomes a comment, even on the next line.
    And, since the space following the word may not have been
    seen yet, it gets eaten up if a comment is printed here,
    therefore, the word is printed in the function process_init_word()
    instead..clumsy..

    printf("%%\n%% Just saw word <%s>\n", word);
    */
    word[0] = word[0]; /* to prevent unused warning ... */
    return TRUE;
}
/* =================================================================== */
process_command(char in[])
{
    char com[1024], *cptr;
    float amt;

    strcpy(com, in);

    if (!G_psout) printf("\\%s", in); /* TeX, just copy commands */
    else { /* is postscript out */

        if (!strncmp(com, "kern", 4)) { /* check if kern command */
	    cptr = &com[4];
	    if (sscanf(cptr, "%f", &amt) != 1) {
	        fprintf(stderr, "illegal kern amount <%f>\n", amt);
	        return FALSE;
	    }
	    printf("%s %.3f mul 0.0 rmoveto %% output of a kern command\n",
			    EMSIZE, -amt);
        } else {
            fprintf(stderr, "PostScript out: command not implemented yet %s\n", in);
        }
    } /* else: is postscript out*/

    return TRUE;

}
/* =================================================================== */
void process_istart(int lang_tok)
{

    int i = lang_tok - ILANG_TOK;

    if (!G_psout) printf("{"); /* provide an enclosing scope for indian
    				* language text stuff for TeX output
				*/

    /* set the correct IFM file, and echo out font settings, if any.. */
    G_current_font = S_langs[i].curr_font;
    if (!G_current_font) {
	if (G_verbose)  {
	    fprintf(stderr, "Warning: No IFM file specified for language %s (line %d)\n", 
			S_langs[i].name, G_lineno);
	    fprintf(stderr, "Warning: Will use the default IFM file\n");
	}

	i = 0;
	G_current_font = S_langs[i].curr_font;
    	if (!G_current_font) {
	    fprintf(stderr, "Error: Could not load even the default IFM file!\n");
	    exit(10);
    	}
    }

    /* echo out font settings */
    if (S_langs[i].curr_fontcmd) printf("%s", S_langs[i].curr_fontcmd);
}
/* =================================================================== */
void process_iend()
{
    if (!G_psout) printf("}"); /* close the enclosing scope for indian
    				* language text stuff for TeX output
				* (see process_istart())
				*/

    printf("%% End of Indian Language\n");
}
/* =================================================================== */
int setifm(int lang_tok, char* ifmtok)
{
    int i = lang_tok - ILANG_TOK;
#ifdef DEBUG
    fprintf(stderr, "loading in language %d at line %d %s\n", lang_tok,
    		G_lineno, ifmtok);
#endif /*DEBUG*/

    if (!find_load_ifm(&S_langs[i], S_allfonts, ifmtok)) {
	 fprintf(stderr, "Warning: could not load in IFM file (line %d, %s) (hope you don't need it..ERROR otherwise..)\n", G_lineno, ifmtok);
	 return FALSE;
    }

    return TRUE;
}
/* =================================================================== */
int setfontcmd(int lang_tok, char ifmtok[])
{
    int i = lang_tok - ILANG_TOK;
    char* eqp;

#ifdef DEBUG
    fprintf(stderr, "setting font for language %d at line %d %s\n", lang_tok,
    		G_lineno, ifmtok);
#endif /*DEBUG*/

    if (S_langs[i].curr_fontcmd) free(S_langs[i].curr_fontcmd);
    S_langs[i].curr_fontcmd = NULL;

    eqp = strchr(ifmtok, '=');
    if (eqp == NULL) {
        fprintf(stderr, "Illegal Indian Font name line: %s (line %d) \n",
			ifmtok, G_lineno);
        return FALSE;
    }

    eqp ++;

    if (strlen(eqp) > 0) {
        S_langs[i].curr_fontcmd = (char*) malloc(sizeof(char)*(strlen(eqp)+1));

		/* eat up all white space around it..*/
        sprintf(S_langs[i].curr_fontcmd, "%s", eqp);

	if (G_verbose > 1)
          fprintf(stderr,"Set font command to: (%s)\n",S_langs[i].curr_fontcmd);

	/* in TeX mode, inhibit hyphenation... */
	if (!G_psout) printf(
	 "\\hyphenchar%s=-1 %% itrans:do not hyphenate words using this font\n",
			 S_langs[i].curr_fontcmd);

    }

    return TRUE;
}
/* =================================================================== */
static void S_usage(FILE *fp)
{
    fprintf(fp,"Usage: itrans [-P [-f <fontsize>]] [-I <ind.ifm>] [-i <infile>] [-o <outfile>] [-h|H]\n");
    fprintf(fp,"            -P for PostScript output, TeX output by default\n");
    fprintf(fp,"            -I specifies the Indian Metrics (IFM) file name\n");
    fprintf(fp,"            -i input file name, stdin by default\n");
    fprintf(fp,"            -o output file name, stdout by default\n");
    fprintf(fp,"            -h|H for this message\n");
}
/* =================================================================== */
