/*
 *========================================================================== 
 * Copyright 1991 Avinash Chopde, All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Avinash Chopde not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * Avinash Chopde makes no representations about the suitability of this
 * software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Avinash Chopde, 1991
 *	    C2 Colonial Drive #4, Andover, MA 01810, USA.
 *
 */

static char S_RCSID[] = "$Header: e:/itrans/src/rcs/pifm.c 1.5 91/10/07 23:27:42 avinash Exp $";

#include "itrans.h"
#include "ifm.h"

#define IFMLINELEN_MAX		1024
#define IFMLINE_STR		"Comment -I-"
#define IFMCOMMENT_STR		"Comment"
#define IFMCOMMENT_CHR		'%'
#define CCS_STR			"CCS"
#define CC_STR			"CC"
#define CCADD_STR		"CCADD"
#define PCC_STR			"PCC"
#define FONT_STR		"FONT"
#define PROP_STR		"PROP"
#define NONE_STR		"none"
#define IMPLICIT_STR		"implicit"
#define STARTI_STR		"StartINDIAN"
#define ENDI_STR		"EndINDIAN"

int G_ifm_lineno = 0;

/* ==================================================================== */
/* extract a word from the given char pointer, and increment the pointer.
 * The char pointer is assumed to point to a string as returned
 * by fgets() - terminated by "\n\0"
 */

static int xtract_word(char** cptr, char word[])
{
    int ch, i;

    if (!*cptr)	return FALSE; /* error, NULL pointer */

    if (**cptr == '\n' || **cptr == '\0') return FALSE; /* eoln */

    /* skip spaces */
    ch = *(*cptr)++;
    while (ch == ' ' || ch == '	' || ch == ';') { /* space, tab, semicolon */
	ch = **cptr;
        if (ch == '\n' || ch == '\0')	return FALSE; /* eoln */
	(*cptr)++;
    }

    /* extract word */
    i = 0;
    while (ch != '\n' && ch != ' ' && ch != '	' && ch != ';') {
			/* nl, space, tab, semicolon */
	word[i++] = ch;
	ch = *(*cptr)++;
    }

    word[i] = '\0';
    return i;
}

/* ==================================================================== */
static int get_next_ifm_line(char* iline, int n, FILE* fp)
{
     G_ifm_lineno++;
     if (!fgets(iline, n, fp)) return FALSE; /* EOF */

     /* check for valid line - starts with "Comment -I-" */
     while (strncmp(iline, IFMLINE_STR, strlen(IFMLINE_STR))) {
         G_ifm_lineno++;
         if (!fgets(iline, n, fp)) return FALSE; /* EOF */
     }

     return TRUE;
}

/* ==================================================================== */
/* externally visible function, returns the next IFM token in word, and
 * does some pattern matching
 * Returns the TAG depending on the word (CC, CCS, etc) -see ifm.h
 */
static char S_line[IFMLINELEN_MAX] = "\0";
static char* S_cptr = &S_line[0];

int get_ifm_token(FILE* fp, char* word)
{
    int s;

    s = xtract_word(&S_cptr, word);
    if (!s) {
	do {
	    if (!get_next_ifm_line(S_line, IFMLINELEN_MAX, fp))
		return FALSE; /* EOF */
	    S_cptr = &S_line[strlen(IFMLINE_STR) + 1];
	    word[0] = '\0';
	    s = xtract_word(&S_cptr, word);
	} while (!s);
    }

    /* decipher word */
    if (	   !strcmp(word, STARTI_STR)
		|| !strcmp(word, ENDI_STR)
        	|| !strcmp(word, IFMCOMMENT_STR)
		|| (word[0] == IFMCOMMENT_CHR)) {
		/* dump the rest of the line, is a comment */

	S_line[0] = '\0';
	S_cptr = &S_line[0];
	return COMMENT_IFMTAG;
    }

    if (!strcmp(word, CCS_STR))		return CCS_IFMTAG;
    if (!strcmp(word, CC_STR))		return CC_IFMTAG;
    if (!strcmp(word, CCADD_STR))	return CCADD_IFMTAG;
    if (!strcmp(word, PCC_STR))		return PCC_IFMTAG;
    if (!strcmp(word, FONT_STR))	return FONT_IFMTAG;
    if (!strcmp(word, PROP_STR))	return PROP_IFMTAG;
    if (!strcmp(word, NONE_STR))	return NONE_IFMTAG;
    if (!strcmp(word, IMPLICIT_STR))	return IMPLICIT_IFMTAG;

    /* now, check for it being a number "+-digits" or "s+-digits" */
    if (isdigit(word[0]))		return NUMBER_IFMTAG;
    if (isdigit(word[1]) && (word[0] == '+' || word[0] == '-'))
	return NUMBER_IFMTAG;
    if (isdigit(word[1]) && word[0] == 's')	return DELTAS_IFMTAG;
    if (isdigit(word[2]) && word[0] == 's' &&
					(word[1] == '+' || word[1] == '-'))
	return DELTAS_IFMTAG;

    /* finally, must be a DNAME_IFMTAG [*-.a-zA-Z0-9]* */

    return DNAME_IFMTAG;
}
/* ==================================================================== */
void reset_pifm()
{
    G_ifm_lineno = 0;
    S_line[0] = '\0';
    S_cptr = &S_line[0];
}
/* ===========================^ pifm.c ^ ============================== */
