%TITLE "Exchange two variables proc"

                .MODEL  TPascal

                .CODE

                PUBLIC  Exchange

;-----------------------------------------------------------------------;
;--                                                                   --;
;-- PURPOSE :    This assembly PROC will exchange the contents of any --;
;--              two variables.  This routine was copied out of the   --;
;--              Turbo Assembler User's Guide with changes to make    --;
;--              it follow the TPascal MODEL.                         --;
;--                                                                   --;
;--              THIS CODE IS NOT MINE and all creative credit        --;
;--              belongs to Borland Personnel.                        --;
;--                                                                   --;
;-- AUTHOR  :  Borland International, Inc.                            --;
;--                                                                   --;
;-----------------------------------------------------------------------;

%NEWPAGE

;---------------------------------------------------------------;
;--  PROCEDURE Exchange ( VAR var1               ;            --;
;--                       VAR var2               ;            --;
;--                           count              : WORD ) ;   --;
;--                                                           --;
;---------------------------------------------------------------;
;--                                                           --;
;--   INPUT :                                                 --;
;--             var1    :  POINTER                            --;
;--                        - any VAR name                     --;
;--             var2    :  POINTER                            --;
;--                        - any VAR name                     --;
;--             count   :  WORD                               --;
;--                        -  a non-zero value indicating the --;
;--                           number of bytes to Exchange     --;
;--                                                           --;
;---------------------------------------------------------------;
;--                                                           --;
;--  EXAMPLE CALL FROM PASCAL:                                --;
;--                                                           --;
;--  Exchange ( rec1 , rec2 , SizeOf ( RecType ) ) ;          --;
;--                                                           --;
;---------------------------------------------------------------;

Exchange  PROC FAR var1:DWORD,var2:DWORD,count:WORD

                LOCALS  @@

                cld                        ;exchange goes upward

                mov     dx,ds              ;save DS

                lds     si,var1            ;get first address
                les     di,var2            ;get second address

                mov     cx,count           ;get number of bytes to move

                shr     cx,1               ;get word count (low bit -> carry)
                jnc     ExchangeWords      ;if no odd byte, enter loop

                mov     al,es:[di]         ;read odd byte from var2
                movsb                      ;move a byte from var1 to var2
                mov     [si-1],al          ;write var2 byte to var1

                jz      Finis              ;done if only one byte to exchange

ExchangeWords:
                mov     bx,-2              ;BX is a handy place to keep -2

ExchangeLoop:
                mov     ax,es:[di]         ;read a word from var2
                movsw                      ;do a move from var1 to var2
                mov     [bx][si],ax        ;write var2 word to var1
                loop    ExchangeLoop       ;repeat "count div 2" times

Finis:
                mov     ds,dx              ;get back Turbo's DS

                ret

ENDP            Exchange

ENDS            CODE

                END                        ; END OF SOURCE
