program Job_Pointers;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ This program illustrates the use of Pointers and Records.               }
{ It also illustrates Variable Typecasts, so that the value of a pointer  }
{ variable can be evaluated and hence the segment and offset of the       }
{ variable pointed to can be found. The functions 'seg' and 'ofs' are     }
{ also used for this purpose. Then by changing to the OS shell, the user  }
{ can enter DEBUG and display (d Seg:Ofs) to check the location of the    }
{ records in memory. Note the apparent multiple storage with a 16-bit     }
{ machine with 1 Mbyte of memory and explain this paradox.                }
{ It is based on a program in the Turbo Pascal version 3 Manual, with     }
{ additional declarations and statements by Ron Shaw.                     }
{                                                                         }
{ POINTERS.PAS  ->  POINTERS.EXE    R Shaw      20.1.90 & 7.2.91          }
{_________________________________________________________________________}

uses Crt, hex;                    { Unit Crt for clear screen procedure    }
                                  { Unit hex for decimal to hex conversion }

type
   PersonPointer = ^PersonRecord;                { Pointer type declaration }

   { Read as 'PersonPointer is a pointer to the record called PersonRecord' }

   PersonRecord = record                          { Record type declaration }
                    Name : string[50];
                    Job  : string[50];
                    Next : PersonPointer;         { Pointer to next record  }
                  end;

   PtrRec       = record                       { Record type declaration to }
                    ofs,seg : word;            { allow variable typecasting }
                  end;

Var
  HeapTop                                       : ^Integer;
  FirstPerson, LastPerson, NewPerson            : PersonPointer;
  Name                                          : string[50];
  PersonLastSeg, PersonLastOfs                  : word;
  HeapTopSeg, HeapTopOfs, HeapSeg, HeapOfs      : word;
  SegmentAddress, OffsetAddress                 : array [1..10] of word;
  SegmentAddressX, OffsetAddressX               : array [1..10] of string;
  i,j                                           : integer;
  PersonLastSegX, PersonLastOfsX                : string;
  HeapSegX, HeapOfsX, HeapTopSegX, HeapTopOfsX  : string;
  reply                                         : char;

begin
  ClrScr;                                { Clear screen from Crt Unit       }
  FirstPerson := nil;                    { First pointer initialized to nil }
  Mark(HeapTop);
  HeapSeg := seg(HeapTop^);              { Function seg - see Ref. Guide }
  HeapOfs := ofs(HeapTop^);              { Function ofs - see Ref. Guide }
  i := 1;
  writeln('Please enter names and professions of between 3 and 7 persons');
  writeln('and just press ENTER for a name to end entry');
  writeln;
  repeat
    write('Enter name:       ');
    readln(Name);









    if Name <> '' then
                  begin
                     New(NewPerson);      { Standard procedure 'New' for    }
                                          { allocating new 'Heap' variables }
                     SegmentAddress[i] := seg(NewPerson^);  { Function seg  }
                     OffsetAddress[i] := ofs(NewPerson^);   { Function ofs  }
                     NewPerson^.Name := Name;
                     write('Enter profession: ');
                     readln(NewPerson^.Job);
                     writeln;
                     if FirstPerson = nil then   { First entry by a pointer }
                        FirstPerson := NewPerson    { to pointer assignment }
                     else
                        LastPerson^.Next := NewPerson; { Subsequent entries }
                     LastPerson := NewPerson;
                     LastPerson^.Next := nil;  { Last pointer assigned 'nil'}
                     i := i + 1;
                   end;
    until Name='';
    ClrScr;
    writeln;
    while FirstPerson <> nil do
    with FirstPerson^ do            { With record pointed to by FirstPerson }
    begin
       writeln(Name,' is a ',Job);
       FirstPerson := Next;          { Pointer reassignment for next record }
    end;
    writeln;
    writeln('Press any key to continue');
    reply := readkey;


{  The remaining code is used to show the pointer and HeapTop values }

    writeln;
    PersonLastSeg  := PtrRec(LastPerson).seg;        { Variable typecasting }
    PersonLastOfs  := PtrRec(LastPerson).ofs;
    HeapTopSeg     := PtrRec(HeapTop).seg;
    HeapTopOfs     := PtrRec(HeapTop).ofs;          { End variable typecast }

    dec2hex(PersonLastSeg,PersonLastSegX);          { Decimal to hexadecimal}
    dec2hex(PersonLastOfs,PersonLastOfsX);          { conversions using the }
    dec2hex(HeapTopSeg,HeapTopSegX);                { unit HEX.TPU written  }
    dec2hex(HeapTopOfs,HeapTopOfsX);                { by R. Shaw            }
    if HeapTopOfsX = '' then HeapTopOfsX := '0';    { Should alter HEX.TPU }

    writeln;
    writeln('--------------------------------------------- ');
    writeln;
    writeln('Last person segment ',PersonLastSegX,' and offset ',PersonLastOfsX);
    writeln;
    writeln('Heap top segment ',HeapTopSegX,' and offset ',HeapTopOfsX);
















{ Segment and offset locations found by seg and ofs functions  }

    writeln;
    writeln('---------------------------------------------  ');
    writeln;
    dec2hex(HeapSeg,HeapSegX);                 { Uses the unit HEX.TPU      }
    dec2hex(HeapOfs,HeapOfsX);                 { written by R. Shaw         }
    if HeapOfsX = '' then HeapOfsX := '0';
    writeln('Heap top segment ',HeapSegX,'  and offset ',HeapOfsX,' -  check');
    writeln;
    writeln('No.  Segment   Offset');
    writeln;
    for j := 1 to i - 1 do
        begin
           dec2hex(SegmentAddress[j],SegmentAddressX[j]);    { Uses HEX.TPU }
           dec2hex(OffsetAddress[j],OffsetAddressX[j]);      { to convert   }
           if OffsetAddressX[j] = '' then OffsetAddressX[j] := '0';
           writeln(j,'     ',SegmentAddressX[j],'       ',OffsetAddressX[j]);
        end;
    writeln;
    writeln;
    Release(HeapTop);
    write('Press any key to continue..');
    reply := readkey;
end.
