{$F+} { Compiler Directive: Force far procedures calls: On } { Do not change! }
{$O+} { Compiler Directive: Generate overlay code: On }

(*****************************************************************************

  Core
    Version 2.22

    This unit holds several low level routines that are used by the more
      advanced units based upon it.

    Purpose:
      This unit is not intended to be used as a stand alone unit.

    Features:
      Several procedures in this unit are order dependent.

    Limitations:
      Error checking code is severely limited for speedy execution.

    Versions:
      1.3 - Reduced the amount of allocated memory necessary.
      1.35 - Fixed several bugs in the screen mode system.
      1.4 - Corrected errors for the storage routines.
      1.5 - Updated the window framing routines.
      2.0 - Reconstructed the window framing routines.
      2.1 - Updated the system to use the screen file instead of standard IO.
      2.11 - Enhanced the system to work with larger screens.
      2.2 - Added the TextAttr manupulation procedures.
      2.21 - Added the Window width function.
      2.22 - Added code to compile under Speed Pascal/2.

    Copyright 1989, 1993, 1996, All rights reserved.
      Paul R. Renaud

    Compiler:
      Turbo Pascal versions 4.0 to 6.0
      Speed Pascal/2 version 1.5

    Systems:
      MS-DOS, MDOS, OS/2

*****************************************************************************)

Unit Core;

  Interface

    Uses
      CRT,
     {$IFDEF OS2}
      OS2Supp,
     {$ENDIF}
      DOS;

    Const

     { These frame styles are defined for Set_Window_Frame. }

      No_Frame = 0;
      Frame_1 = 1;
      Frame_2 = 2;
      Frame_3 = 3;
      Frame_4 = 4;
      Frame_5 = 5;
      Frame_6 = 6;
      Frame_7 = 7;
      Frame_8 = 8;

     { These values were added for Version 2.1 }

      Frame_9 = 9;
      Frame_10 = 10;
      Frame_11 = 11;
      Frame_12 = 12;
      Frame_13 = 13;
      Frame_14 = 14;
      Frame_15 = 15;
      Frame_16 = 16;
      Frame_17 = 17;
      Frame_18 = 18;
      Frame_19 = 19;
      Frame_20 = 20;
      Frame_21 = 21;
      Frame_22 = 22;
      Frame_23 = 23;
      Frame_24 = 24;

    Type

     { Frame definition is for the window drawing procedures. }

      Frame_Type = Record
                     Attribute: Byte;
                     Data: Array[ 1 .. 9 ] of Char;
                   End;

     { This structure is for screen window management. }

      Storage_Record = Record
                         Attribute,
                         Row_Length,
                         Cursor_Row,
                         Column_Length,
                         Cursor_Column: Byte;
                         Amount: Word;
                         Location: Pointer;
                       End;

     { This structure defines a single cell of screen text information. }

      Cell_Type = Record
                    Character: Char;
                    Attribute: Byte;
                  End;

     { This is the standard type used for access of screen information. }

      Area_Type = Array[ 1 .. 255 ] of Cell_Type;
      Area_Type_Pointer = ^Area_Type;

    Var

     { This file is opened for the output of the descendent units. }

      Screen: Text;

     { These variables are set by the Get_The_Mode procedure. }

      The_Mode,
      Screen_Row_Limit,
      Screen_Column_Limit: Byte;

     { These are pointers to WindMin & WindMax of CRT }

      Top_Of_Window,
      Left_Of_Window,
      Right_Of_Window,
      Bottom_Of_Window: ^Byte;

     { These allow linking between other descendant units. }

     {$IFNDEF VER40}
      Up_Routine,
      Down_Routine,
      Left_Routine,
      Right_Routine,
      Expand_Width_Routine,
      Expand_Height_Routine,
      Reduce_Width_Routine,
      Reduce_Height_Routine: Function: Boolean;
      Lock_Routine: Procedure;
     {$ENDIF}

(***********************************************************

  Procedure: Get the screen mode.

    This procedure sets The_Mode to the current video mode.
    It sets the video pointer to point to beginning of video
    buffer.  It sets DirectVideo to false if Screen_Mode is
    graphic.

***********************************************************)

    Procedure Get_The_Mode;

(***********************************************************

  Procedure: Put character on monitor screen.

    This procedure puts the character on the monitor screen
    with the specified attribute using either Move_Screen or
    the Basic Input/Output System (BIOS) depending on what
    The_Mode is.  The location of character is determined by
    Column and Row.

***********************************************************)

    Procedure Put_Character_On_Screen( Column, Row: Byte; Character: Char; Attribute: Byte );

(***********************************************************

  Procedure: Write data.

    This procedure puts the character and attributes on the
    monitor screen using either Move_Screen or the Basic
    Input/Output System (BIOS) depending on what The_Mode
    is.  The location of character is determined by Column
    and Row.

***********************************************************)

   {$IFNDEF OS2}
    Procedure Write_Data( Row, Column: Byte; Var Data; Amount: Word );
   {$ELSE}
    Procedure Write_Data( Row, Column: Byte; Data: Pointer; Amount: Word );
   {$ENDIF}

(***********************************************************

  Procedure: Get character from the monitor screen.

    This procedure gets a character and attribute from the
    current monitor screen much like
    Put_Character_On_Screen, in the fastest way possible
    depending on the value of The_Mode.

***********************************************************)

    Procedure Get_Character_from_Screen( Column, Row: Byte; Var Character: Char; Var Attribute: Byte );

(***********************************************************

  Procedure: Read data.

    This procedure gets character and attribute from the
    current monitor screen, in the fastest way possible
    depending on the value of The_Mode.

***********************************************************)

   {$IFNDEF OS2}
    Procedure Read_Data( Row, Column: Byte; Var Data; Amount: Word );
   {$ELSE}
    Procedure Read_Data( Row, Column: Byte; Data: Pointer; Amount: Word );
   {$ENDIF}

(***********************************************************

  Function: Get the address of screen buffer memory.

    This function will return a pointer to the location of
    screen buffer memory determined by Column and Row and
    the pointer set by Get_Mode.

***********************************************************)

    Function Get_Screen_Address( Column, Row: Byte ): Pointer;

(***********************************************************

  Procedure: Change attribute of text on screen.

    This procedure will change the attributes using the
    fastest way possible on the Screen buffer. The location
    is determined by Row and Column.

***********************************************************)

    Procedure Change_Screen_Attribute( Row, Column, Length, Attribute: Byte );

(***********************************************************

  Procedure: Change attribute of text in screen window.

    This procedure will change the attributes using the
    fastest way possible on the Window buffer. The location
    is determined by Row and Column.

***********************************************************)

    Procedure Change_Window_Attribute( Row, Column, Length, Attribute: Byte );

(***********************************************************

  Procedure: Dim attribute of text on screen.

    This procedure will alter the attributes using the
    fastest way possible on the Screen buffer.  The location
    is determined by Row and Column.

***********************************************************)

    Procedure Dim_Screen_Attribute( Row, Column, Length, Attribute: Byte );

(***********************************************************

  Procedure: Fill Word.

    This procedure copies the source into destination as
    many continuous times as specified by Length.
    It corresponds to FillChar in the System unit but uses
    words.

***********************************************************)

    Procedure Fill_Word( Var Destination; Length: Word; Source: Word );

(***********************************************************

  Procedure: Exchange.

    This procedure exchanges the source and destination
    using the CPU's built in code which makes it faster
    than other methods.  Length indicates the size of both
    variables in bytes.

***********************************************************)

    Procedure Exchange( Var Source, Destination; Length : Word );

(***********************************************************

  Function: Reverse.

    This function really just switches the four high bits
    and the four low bits in a byte and returns that value.

***********************************************************)

    Function Reverse( Value: Byte ): Byte;

(***********************************************************

  Function: Allocate storage space for a simulated window.

    This procedure is designed to obtain the memory amount
    specified in Storage.Amount.  The procedure may terminate
    the program if the memory is not available, otherwise
    it will return false.

***********************************************************)

    Function Allocate_Storage( Var Storage: Storage_Record ): Boolean;

(***********************************************************

  Procedure: Deallocate Storage space.

    This procedure is designed to return the memory to the
    system which was previously allocated with
    Allocate_Storage.  The value in Storage.Amount should
    not have been changed.

***********************************************************)

    Procedure Deallocate_Storage( Var Storage: Storage_Record );

(***********************************************************

  Procedure: Get from storage.

    This procedure acts like Get_Character_from_Screen,
    except that it uses the storage as a simulated screen.

***********************************************************)

    Procedure Get_From_Storage( Storage: Storage_Record; Row, Column: Byte; Var Character: Char; Var Attribute: Byte );

(***********************************************************

  Procedure: Put to storage.

    This procedure acts like Put_Character_On_Screen,
    except that it uses the storage as a simulated screen.

***********************************************************)

    Procedure Put_To_Storage( Storage: Storage_Record; Row, Column: Byte; Character: Char; Attribute: Byte );

(***********************************************************

  Function: Address Storage.

    This function acts like Get_Screen_Address,
    except that it uses the storage as a simulated screen.

***********************************************************)

    Function Address_Storage( Storage: Storage_Record; Row, Column: Byte ): Pointer;

(***********************************************************

  Procedure: Change storage attribute.

    This procedure acts like Change_Screen_Attribute,
    except that it uses the storage as a simulated screen.

***********************************************************)

    Procedure Change_Storage_Attribute( Storage: Storage_Record; Row, Column, Length, Attribute: Byte );

(***********************************************************

  These procedure clear appropriate simulated screen
  locations.

***********************************************************)

    Procedure Clear_Storage_Row( Storage: Storage_Record; Row: Byte );
    Procedure Clear_Storage_Column( Storage: Storage_Record; Column: Byte );
    Procedure Clear_Storage( Storage: Storage_Record );

(***********************************************************

  These procedures will scroll the simulated screen in the
  specified directions.

***********************************************************)

    Procedure Scroll_Storage_Down( Storage: Storage_Record );
    Procedure Scroll_Storage_Up( Storage: Storage_Record );
    Procedure Scroll_Storage_Right( Storage: Storage_Record );
    Procedure Scroll_Storage_Left( Storage: Storage_Record );

(***********************************************************

  These procedures will scroll the actual region of the
  screen in the specified direction.

***********************************************************)

    Procedure Scroll_Region_Up( Left, Top, Right, Bottom: Byte );
    Procedure Scroll_Region_Down( Left, Top, Right, Bottom: Byte );
    Procedure Scroll_Region_Left( Left, Top, Right, Bottom: Byte );
    Procedure Scroll_Region_Right( Left, Top, Right, Bottom: Byte );

(***********************************************************

  These procedures will scroll the current CRT window on the
  screen in the specified direction.

***********************************************************)

    Procedure Scroll_Window_Up;
    Procedure Scroll_Window_Down;
    Procedure Scroll_Window_Left;
    Procedure Scroll_Window_Right;

(***********************************************************

  Procedure: Set the Window Frame.

    This procedure sets the given frame to one of the
    predefined frames determined by Frame_Style.  The
    frame attribute is set to Attribute.

***********************************************************)

    Procedure Set_Window_Frame( Var Frame: Frame_Type; Attribute, Frame_Style: Byte );

(***********************************************************

  Procedure: Define the user defined window frame.

    This procedure allows the user to use other characters
    when drawing the window frame.  Set_Window_Frame or
    Define_Frame must be used to initialize the frame before
    calling Draw_Window_Frame.

***********************************************************)

    Procedure Define_Frame( Var Frame: Frame_Type; Top_Left, Top, Top_Right, Left,
                            Middle, Right, Bottom_Left, Bottom, Bottom_Right: Char; Attribute: Byte );

(***********************************************************

  Procedure: Make window frame.

    This procedure works like Define frame and allows the
    user to make other window frames by just supplying a
    little bit of data.

  (Added with Version 2.2)

***********************************************************)

    Procedure Make_Frame( Var Frame: Frame_Type; Left_Lines, Top_Lines, Right_Lines, Bottom_Lines, Attribute: Byte;
                          Corners: Boolean );

(***********************************************************

  Procedure: Draw the window frame.

    This procedure will draw a frame in the given window
    size with the given window style.

***********************************************************)

    Procedure Draw_Window_Frame( Var Frame: Frame_Type; Left, Top, Right, Bottom: Byte );

(***********************************************************

  These procedures clear lines of characters on the screen.

***********************************************************)

    Procedure Blank_Row( Row, Left, Right: Byte );

    Procedure Blank_Column( Column, Top, Bottom: Byte );

(***********************************************************

  Procedure: Write error.

    This procedure will halt the program and print out an
    error message if the value passed to it is not zero.
    This is intended to be passed on to descendent units.

***********************************************************)

    Procedure Write_Error( Result: Word; Sentence: String );

(***********************************************************

  Function: Combine.

    This function manipulates a Text Attribute, changing it
    from the Old_Colors to part of the New_Colors depending
    on which of the flags are set.  If Keep_Text is true,
    then the old text color is retains, otherwise the new
    one is used.  Likewise with the Keep_BackGround.  If
    both are true, then Combine returns Old_Colors, if
    both are false, then Combine returns New_Colors.

  ( added with version 2.2 )

***********************************************************)

    Function Combine( Old_Colors, New_Colors: Byte; Keep_Text, Keep_BackGround: Boolean ): Byte;

(***********************************************************

  Procedure: Procedure default.

    Dummy procedure used to initialize several procedure
    variables.

***********************************************************)

    Procedure Procedure_Default;

(***********************************************************

  Function: Window_Width.

    This function returns the width of the current screen
    window.

  (Added with Version 2.21)

***********************************************************)

    Function Window_Width: Byte;

{----------------------------------------------------------------------------}

  Implementation

   {$DEFINE Debug}  { Used in debugging the code. }

   {$DEFINE Quick}  { Used to allow alternate code for faster processing. }

   {$IFDEF VER60}
    {$IFDEF Quick}
     {$DEFINE Quick2}
    {$ENDIF}
   {$ENDIF}

    Var
     { Points to the current video offset. }
      Video_Offset,
     { Points to the current video segment. }
      Video_Segment: Word;
     { Holds the current video page number. }
      Page_Number,
     { Holds the original amount of rows. }
      Original_Row_Limit: Byte;
     { Multi-purpose data storage area. }
      Work_Area: Area_Type;
     { Holds OS/2 function results. }
     {$IFDEF OS2}
      Okay: LongWord;
     {$ENDIF}

{////////////////////////////////////////////////////////////////////////////}

   {$IFNDEF OS2}
    {$F+} { WARNING: Do Not Change! }
    {$L CoreCode}
   {$ENDIF}

   {$I Core2.Pas}

{////////////////////////////////////////////////////////////////////////////}

(*************************************************

  Function: Allocate storage.
    As previously defined.

*************************************************)

    Function Allocate_Storage( Var Storage: Storage_Record ): Boolean;
      Begin
        GetMem( Storage.Location, Storage.Amount );
       {$IFDEF Debug}
        FillChar( Storage.Location^, Storage.Amount, #0 );
       {$ENDIF}
        Allocate_Storage := ( Storage.Location <> Nil );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Deallocate storage.
    As previously defined.

*************************************************)

    Procedure Deallocate_Storage( Var Storage: Storage_Record );
      Begin
        If ( Storage.Location <> Nil )
          then
            Begin
              FreeMem( Storage.Location, Storage.Amount );
              Storage.Location := Nil;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get address storage.
    This procedure calculates the address of the
    given location in storage.

*************************************************)

   {$IFNDEF OS2}
    Procedure Get_Address_Storage( Var Storage: Storage_Record; Row, Column: Byte; Var Segment, Offset: Word );
      Begin
        Dec( Row );
        Dec( Column );
        Segment := Seg( Storage.Location^ );
        Offset := ( Ofs( Storage.Location^ ) + ( ( ( Row * Storage.Column_Length ) + Column ) * 2 ) );
      End;
   {$ELSE}
    Procedure Get_Address_Storage( Var Storage: Storage_Record; Row, Column: Byte; Var Where: Pointer );
      Var
        Information: LongWord absolute Where;
      Begin
        Dec( Row );
        Dec( Column );
        Where := Storage.Location;
        Information := Information + ( ( ( Row * Storage.Column_Length ) + Column ) * 2 );
      End;
   {$ENDIF}

{----------------------------------------------------------------------------}

(*************************************************

  Function: Internal address storage.
    This function returns a pointer to the
    specified memory location.

*************************************************)

    Function Internal_Address_Storage( Storage: Storage_Record; Row, Column: Byte ): Pointer;
     {$IFNDEF OS2}
      Var
        Offset,
        Segment: Word;
      Begin
        Get_Address_Storage( Storage, Row, Column, Segment, Offset );
        Internal_Address_Storage := Addr( Mem[ Segment: Offset ] );
      End;
     {$ELSE}
      Var
        Where: Pointer;
      Begin
        Get_Address_Storage( Storage, Row, Column, Where );
        Internal_Address_Storage := Where;
      End;
     {$ENDIF}

{----------------------------------------------------------------------------}

(*************************************************

  Function: Address storage.
    As previously defined.

*************************************************)

    Function Address_Storage( Storage: Storage_Record; Row, Column: Byte ): Pointer;
      Begin
        If ( Storage.Location = Nil )
          then
            Write_Error( 204, 'Address_Storage: Invalid pointer' );
        If ( ( Column < 1 ) or ( Column > Storage.Column_Length ) )
          then
            Write_Error( 201, 'Address_Storage: Column out of range' );
        If ( ( Row < 1 ) or ( Row > Storage.Row_Length ) )
          then
            Write_Error( 201, 'Address_Storage: Row out of range' );
        Address_Storage := Internal_Address_Storage( Storage, Row, Column );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get from storage.
    As previously defined.

*************************************************)

    Procedure Get_From_Storage( Storage: Storage_Record; Row, Column: Byte; Var Character: Char; Var Attribute: Byte );
      Var
       {$IFNDEF OS2}
        Offset,
        Segment: Word;
       {$ELSE}
        Where: ^Cell_Type;
       {$ENDIF}
      Begin
        If ( ( Storage.Location = Nil ) or ( Column < 1 ) or ( Row < 1 ) or
             ( Column > Storage.Column_Length ) or ( Row > Storage.Row_Length ) )
          then
            Begin
              Character := #0;
              Attribute := $0;
            End
          else
            Begin
             {$IFNDEF OS2}
              Get_Address_Storage( Storage, Row, Column, Segment, Offset );
              Character := Chr( Mem[ Segment: Offset ] );
              Attribute := Mem[ Segment: Succ( Offset ) ];
             {$ELSE}
              Get_Address_Storage( Storage, Row, Column, Where );
              Character := Where^.Character;
              Attribute := Where^.Attribute;
             {$ENDIF}
            End
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Put to storage.
    As previously defined.

*************************************************)

    Procedure Put_To_Storage( Storage: Storage_Record; Row, Column: Byte; Character: Char; Attribute: Byte );
      Var
       {$IFNDEF OS2}
        Offset,
        Segment: Word;
       {$ELSE}
        Where: ^Cell_Type;
       {$ENDIF}
      Begin
        If ( ( Storage.Location <> Nil ) and ( Column > 0 ) and ( Row > 0 ) and
             ( Column <= Storage.Column_Length ) and ( Row <= Storage.Row_Length ) )
          then
            Begin
             {$IFNDEF OS2}
              Get_Address_Storage( Storage, Row, Column, Segment, Offset );
              Mem[ Segment: Offset ] := Ord( Character );
              Mem[ Segment: Succ( Offset ) ] := Attribute;
             {$ELSE}
              Get_Address_Storage( Storage, Row, Column, Where );
              Where^.Character := Character;
              Where^.Attribute := Attribute;
             {$ENDIF}
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Clear storage row.
    This procedure clears the specified row in
    the storage window space.

*************************************************)

    Procedure Clear_Storage_Row( Storage: Storage_Record; Row: Byte );
      Var
        Data:  Cell_Type;
        Where: Pointer;
      Begin
        If ( ( Storage.Location <> Nil ) and ( Row <= Storage.Row_Length ) and ( Row > 0 ) )
          then
            Begin
              Where := Internal_Address_Storage( Storage, Row, 1 );
              Data.Character := ' ';
              Data.Attribute := Storage.Attribute;
              Fill_Word( Where^, Storage.Column_Length, Word( Data ) );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Clear storage column.
    This procedure clears the specified column in
    the storage window space.

*************************************************)

    Procedure Clear_Storage_Column( Storage: Storage_Record; Column: Byte );
      Var
        Row: Byte;
        Data: Cell_Type;
        Value: Integer;
       {$IFNDEF OS2}
        Offset,
        Segment: Word;
       {$ELSE}
        Where: ^Cell_Type;
        Information: LongWord absolute Where;
       {$ENDIF}
      Begin
        If ( ( Storage.Location <> Nil ) and ( Column <= Storage.Column_Length ) and ( Column > 0 ) )
          then
            Begin
              Value := ( Storage.Column_Length * 2 );
             {$IFNDEF OS2}
              Get_Address_Storage( Storage, 1, Column, Segment, Offset );
             {$ELSE}
              Get_Address_Storage( Storage, 1, Column, Where );
             {$ENDIF}
              Data.Character := ' ';
              Data.Attribute := Storage.Attribute;
              For Row := 1 to Storage.Row_Length do
                Begin
                 {$IFNDEF OS2}
                  MemW[ Segment: Offset ] := Word( Data );
                  Offset := ( Offset + Value );
                 {$ELSE}
                  Where^ := Data;
                  Information := ( Information + Value );
                 {$ENDIF}
                End;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Scroll storage down.
    As previously defined.

*************************************************)

    Procedure Scroll_Storage_Down( Storage: Storage_Record );
      Var
        Where1,
        Where2: Pointer;
      Begin
        If ( ( Storage.Location <> Nil ) and ( Storage.Row_Length > 1 ) )
          then
            Begin
              Where1 := Internal_Address_Storage( Storage, 1, 1 );
              Where2 := Internal_Address_Storage( Storage, 2, 1 );
              Move( Where1^, Where2^, ( ( Pred( Storage.Row_Length ) * Storage.Column_Length ) * 2 ) );
              Clear_Storage_Row( Storage, 1 );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Scroll storage up.
    As previously defined.

*************************************************)

    Procedure Scroll_Storage_Up( Storage: Storage_Record );
      Var
        Where1,
        Where2: Pointer;
      Begin
        If ( ( Storage.Location <> Nil ) and ( Storage.Row_Length > 1 ) )
          then
            Begin
              Where1 := Internal_Address_Storage( Storage, 2, 1 );
              Where2 := Internal_Address_Storage( Storage, 1, 1 );
              Move( Where1^, Where2^, ( ( Pred( Storage.Row_Length ) * Storage.Column_Length ) * 2 ) );
              Clear_Storage_Row( Storage, Storage.Row_Length );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Scroll storage right.
    As previously defined.

*************************************************)

    Procedure Scroll_Storage_Right( Storage: Storage_Record );
      Var
        Where1,
        Where2: Pointer;
      Begin
        If ( ( Storage.Location <> Nil ) and ( Storage.Column_Length > 1 ) )
          then
            Begin
              Where1 := Internal_Address_Storage( Storage, 1, 1 );
              Where2 := Internal_Address_Storage( Storage, 1, 2 );
              Move( Where1^, Where2^, ( Pred( Storage.Row_Length * Storage.Column_Length ) * 2 ) );
              Clear_Storage_Column( Storage, 1 );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Scroll storage left.
    As previously defined.

*************************************************)

    Procedure Scroll_Storage_Left( Storage: Storage_Record );
      Var
        Where1,
        Where2: Pointer;
      Begin
        If ( ( Storage.Location <> Nil ) and ( Storage.Column_Length > 1 ) )
          then
            Begin
              Where1 := Internal_Address_Storage( Storage, 1, 2 );
              Where2 := Internal_Address_Storage( Storage, 1, 1 );
              Move( Where1^, Where2^, ( Pred( Storage.Row_Length * Storage.Column_Length ) * 2 ) );
              Clear_Storage_Column( Storage, Storage.Column_Length );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Clear storage.
    As previously defined.

*************************************************)

    Procedure Clear_Storage( Storage: Storage_Record );
      Var
        Data: Cell_Type;
        Where: Pointer;
      Begin
        If ( Storage.Location <> Nil )
          then
            Begin
              Where := Internal_Address_Storage( Storage, 1, 1 );
              Data.Character := ' ';
              Data.Attribute := Storage.Attribute;
              Fill_Word( Where^, ( Storage.Column_Length * Storage.Row_Length ), Word( Data ) );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Change storage attribute.
    As previously defined.

*************************************************)

    Procedure Change_Storage_Attribute( Storage: Storage_Record; Row, Column, Length, Attribute: Byte );
      Var
        Count: Byte;
       {$IFNDEF OS2}
        Offset,
        Segment: Word;
       {$ELSE}
        Where: ^Cell_Type;
        Information: LongWord absolute Where;
       {$ENDIF}
      Begin
        If ( ( Column <= Storage.Column_Length ) and ( Row <= Storage.Row_Length ) and
             ( Column > 0 ) and ( Row > 0 ) and ( Storage.Location <> Nil ) )
          then
            Begin
             {$IFNDEF OS2}
              Get_Address_Storage( Storage, Row, Column, Segment, Offset );
              Inc( Offset );
             {$ELSE}
              Get_Address_Storage( Storage, Row, Column, Where );
             {$ENDIF}
              Count := 0;
              While ( Count < Length ) and ( Column <= Storage.Column_Length ) do
                Begin
                 {$IFNDEF OS2}
                  Mem[ Segment: Offset ] := Attribute;
                  Inc( Offset, 2 );
                 {$ELSE}
                  Where^.Attribute := Attribute;
                  Inc( Information, 2 );
                 {$ENDIF}
                  Inc( Column );
                  Inc( Count );
                End;
            End
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Make top left corner.
    This procedure finds the best corner for the
    top left hand side.

*************************************************)

    Procedure Make_Top_Left_Corner( Var Character: Char; Var Left_Lines, Top_Lines: Byte; Corners: Boolean );
      Begin
        Character := #219;
        If Corners
          then
            Case Top_Lines of
              1, 5, 6:
                Case Left_Lines of
                  1, 5, 6: Character := #218;
                  2, 7, 8: Character := #214;
                End; { Case }
              2, 7, 8:
                Case Left_Lines of
                  1, 5, 6: Character := #213;
                  2, 7, 8: Character := #201;
                End; { Case }
            End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Make top right corner.
    This procedure finds the best corner for the
    top right hand side.

*************************************************)

    Procedure Make_Top_Right_Corner( Var Character: Char; Var Right_Lines, Top_Lines: Byte; Corners: Boolean );
      Begin
        Character := #219;
        If Corners
          then
            Case Top_Lines of
              1, 5, 6:
                Case Right_Lines of
                  1, 5, 6: Character := #191;
                  2, 7, 8: Character := #183;
                End; { Case }
              2, 7, 8:
                Case Right_Lines of
                  1, 5, 6: Character := #184;
                  2, 7, 8: Character := #187;
                End; { Case }
            End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Make bottom left corner.
    This procedure finds the best corner for the
    bottom left hand side.

*************************************************)

    Procedure Make_Bottom_Left_Corner( Var Character: Char; Var Left_Lines, Bottom_Lines: Byte; Corners: Boolean );
      Begin
        Character := #219;
        If Corners
          then
            Case Bottom_Lines of
              1, 5, 6:
                Case Left_Lines of
                  1, 5, 6: Character := #192;
                  2, 7, 8: Character := #211;
                End; { Case }
              2, 7, 8:
                Case Left_Lines of
                  1, 5, 6: Character := #212;
                  2, 7, 8: Character := #200;
                End; { Case }
            End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Make bottom right corner.
    This procedure finds the best corner for the
    bottom right hand side.

*************************************************)

    Procedure Make_Bottom_Right_Corner( Var Character: Char; Var Right_Lines, Bottom_Lines: Byte; Corners: Boolean );
      Begin
        Character := #219;
        If Corners
          then
            Case Bottom_Lines of
              1, 5, 6:
                Case Right_Lines of
                  1, 5, 6: Character := #217;
                  2, 7, 8: Character := #189
                End; { Case }
              2, 7, 8:
                Case Right_Lines of
                  1, 5, 6: Character := #190;
                  2, 7, 8: Character := #188;
                End; { Case }
            End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Make window frame.
    As previously defined.

*************************************************)

    Procedure Make_Frame( Var Frame: Frame_Type; Left_Lines, Top_Lines, Right_Lines, Bottom_Lines, Attribute: Byte;
                          Corners: Boolean );
      Begin
        Make_Top_Left_Corner( Frame.Data[ 1 ], Left_Lines, Top_Lines, Corners );
        Case Top_Lines of
          1: Frame.Data[ 2 ] := #196;
          2: Frame.Data[ 2 ] := #205;
          3: Frame.Data[ 2 ] := #220;
          4: Frame.Data[ 2 ] := #219;
          5: Frame.Data[ 2 ] := #194;
          6: Frame.Data[ 2 ] := #210;
          7: Frame.Data[ 2 ] := #209;
          8: Frame.Data[ 2 ] := #203;
        End; { Case }
        Make_Top_Right_Corner( Frame.Data[ 3 ], Right_Lines, Top_Lines, Corners );
        Case Left_Lines of
          1: Frame.Data[ 4 ] := #179;
          2: Frame.Data[ 4 ] := #186;
          3: Frame.Data[ 4 ] := #222;
          4: Frame.Data[ 4 ] := #219;
          5: Frame.Data[ 4 ] := #195;
          6: Frame.Data[ 4 ] := #198;
          7: Frame.Data[ 4 ] := #199;
          8: Frame.Data[ 4 ] := #204;
        End; { Case }
        Frame.Data[ 5 ] := ' ';
        Case Right_Lines of
          1: Frame.Data[ 6 ] := #179;
          2: Frame.Data[ 6 ] := #186;
          3: Frame.Data[ 6 ] := #221;
          4: Frame.Data[ 6 ] := #219;
          5: Frame.Data[ 6 ] := #180;
          6: Frame.Data[ 6 ] := #181;
          7: Frame.Data[ 6 ] := #182;
          8: Frame.Data[ 6 ] := #185;
        End; { Case }
        Make_Bottom_Left_Corner( Frame.Data[ 7 ], Left_Lines, Bottom_Lines, Corners );
        Case Bottom_Lines of
          1: Frame.Data[ 8 ] := #196;
          2: Frame.Data[ 8 ] := #205;
          3: Frame.Data[ 8 ] := #223;
          4: Frame.Data[ 8 ] := #219;
          5: Frame.Data[ 8 ] := #193;
          6: Frame.Data[ 8 ] := #208;
          7: Frame.Data[ 8 ] := #207;
          8: Frame.Data[ 8 ] := #202;
        End; { Case }
        Make_Bottom_Right_Corner( Frame.Data[ 9 ], Right_Lines, Bottom_Lines, Corners );
        Frame.Attribute := Attribute;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set window frame.
    As previously defined.

*************************************************)

    Procedure Set_Window_Frame( Var Frame: Frame_Type; Attribute, Frame_Style: Byte );
      Begin
        Case Frame_Style of
          Frame_1: Make_Frame( Frame, 1, 1, 1, 1, Attribute, True );
          Frame_2: Make_Frame( Frame, 1, 2, 1, 1, Attribute, True );
          Frame_3: Make_Frame( Frame, 1, 1, 1, 2, Attribute, True );
          Frame_4: Make_Frame( Frame, 1, 2, 1, 2, Attribute, True );
          Frame_5: Make_Frame( Frame, 2, 1, 2, 1, Attribute, True );
          Frame_6: Make_Frame( Frame, 2, 2, 2, 1, Attribute, True );
          Frame_7: Make_Frame( Frame, 2, 1, 2, 2, Attribute, True );
          Frame_8: Make_Frame( Frame, 2, 2, 2, 2, Attribute, True );
          Frame_9: Make_Frame( Frame, 1, 1, 1, 1, Attribute, False );
          Frame_10: Make_Frame( Frame, 1, 2, 1, 1, Attribute, False );
          Frame_11: Make_Frame( Frame, 1, 1, 1, 2, Attribute, False );
          Frame_12: Make_Frame( Frame, 1, 2, 1, 2, Attribute, False );
          Frame_13: Make_Frame( Frame, 2, 1, 2, 1, Attribute, False );
          Frame_14: Make_Frame( Frame, 2, 2, 2, 1, Attribute, False );
          Frame_15: Make_Frame( Frame, 2, 1, 2, 2, Attribute, False );
          Frame_16: Make_Frame( Frame, 2, 2, 2, 2, Attribute, False );
          Frame_17: Make_Frame( Frame, 5, 5, 5, 5, Attribute, False );
          Frame_18: Make_Frame( Frame, 5, 8, 5, 8, Attribute, False );
          Frame_19: Make_Frame( Frame, 8, 5, 8, 5, Attribute, False );
          Frame_20: Make_Frame( Frame, 8, 8, 8, 8, Attribute, False );
          Frame_21: Make_Frame( Frame, 2, 8, 2, 8, Attribute, True );
          Frame_22: Make_Frame( Frame, 2, 7, 2, 7, Attribute, True );
          Frame_23: Make_Frame( Frame, 2, 6, 2, 6, Attribute, True );
          Frame_24: Make_Frame( Frame, 8, 1, 8, 1, Attribute, True );
          else Frame.Data := '         ';
        End; { Case }
        Frame.Attribute := Attribute;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Define frame.
    As previously defined.

*************************************************)

    Procedure Define_Frame( Var Frame: Frame_Type; Top_Left, Top, Top_Right, Left, Middle,
                            Right, Bottom_Left, Bottom, Bottom_Right: Char; Attribute: Byte );
      Begin
        Frame.Data[ 1 ] := Top_Left;
        Frame.Data[ 2 ] := Top;
        Frame.Data[ 3 ] := Top_Right;
        Frame.Data[ 4 ] := Left;
        Frame.Data[ 5 ] := Middle;
        Frame.Data[ 6 ] := Right;
        Frame.Data[ 7 ] := Bottom_Left;
        Frame.Data[ 8 ] := Bottom;
        Frame.Data[ 9 ] := Bottom_Right;
        Frame.Attribute := Attribute;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Draw window frame.
    As previously defined.

*************************************************)

    Procedure Draw_Window_Frame( Var Frame: Frame_Type; Left, Top, Right, Bottom: Byte );
      Var
        Hold,
        Count: Byte;
      Begin
        FillChar( Work_Area, SizeOf( Work_Area ), Frame.Attribute );
        If ( ( Top < Bottom ) and ( Left < Right ) )
          then
            Begin
              If ( Left <  Right )
                then
                  Begin
                    Hold := Succ( Right - Left );
                    Work_Area[ 1 ].Character := Frame.Data[ 1 ];
                    For Count := 2 to Pred( Hold ) do
                      Work_Area[ Count ].Character := Frame.Data[ 2 ];
                    Work_Area[ Hold ].Character := Frame.Data[ 3 ];
                   {$IFNDEF OS2}
                    Write_Data( Top, Left, Work_Area, Hold );
                   {$ELSE}
                    Write_Data( Top, LEft, Addr( Work_Area ), Hold );
                   {$ENDIF}
                    Work_Area[ 1 ].Character := Frame.Data[ 7 ];
                    For Count := 2 to Pred( Hold ) do
                      Work_Area[ Count ].Character := Frame.Data[ 8 ];
                    Work_Area[ Hold ].Character := Frame.Data[ 9 ];
                   {$IFNDEF OS2}
                    Write_Data( Bottom, Left, Work_Area, Hold );
                   {$ELSE}
                    Write_Data( Bottom, Left, Addr( Work_Area ), Hold );
                   {$ENDIF}
                  End;
              If ( Top < Bottom )
                then
                  For Count := Succ( Top ) to Pred( Bottom ) do
                    Begin
                      Put_Character_On_Screen( Left, Count, Frame.Data[ 4 ], Frame.Attribute );
                      Put_Character_On_Screen( Right, Count, Frame.Data[ 6 ], Frame.Attribute );
                    End;
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Reverse.
    As previously defined.

*************************************************)

    Function Reverse( Value: Byte ): Byte;
     {$IFDEF Quick2}
      Assembler;
      Asm
        Mov Al, Value
        Mov Cl, 4
        RoL Al, Cl
      End;
     {$ELSE}
      Begin
        Reverse := ( ( Value SHL 4 ) and $00FF ) or ( Value SHR 4 );
      End;
     {$ENDIF}

{----------------------------------------------------------------------------}

(*************************************************

  Function: Combine.
    As previously defined.

*************************************************)

    Function Combine( Old_Colors, New_Colors: Byte; Keep_Text, Keep_BackGround: Boolean ): Byte;
      Var
        Character,
        BackGround,
        Result: Byte;
      Begin
        If Keep_Text
          then
            Character := ( New_Colors and $0F )
          else
            Character := ( Old_Colors and $0F );
        If Keep_BackGround
          then
            BackGround := ( New_Colors and $F0 )
          else
            BackGround := ( Old_Colors and $F0 );
          Result := ( Character or BackGround );
          If ( Result in [ 0, 17, 34, 51, 68, 85, 110, 119, 127, 128, 145, 162, 179, 196, 213, 238, 255 ] )
            then
              Combine := 112
            else
              Combine := Result;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Substitute 1.
    Dummy function used to initialize several
    functional variables.

*************************************************)

   {$F+} { WARNING! Do not change! }
    Function Substitute1: Boolean;
      Begin
        Substitute1 := false;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Procedure default.
    As previously defined.

*************************************************)

    Procedure Procedure_Default;
      Begin
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function:  Window width.
    As previously defined.

*************************************************)

    Function Window_Width: Byte;
      Begin
        Window_Width := ( Right_Of_Window^ - Left_Of_Window^ );
      End;

(*************************************************

  Main initialization section.
    First, initialize the mode.
    Then initialize the window boundary pointers.
    Finally, initialize the binding routines.

*************************************************)

 {$IFDEF OS2}
  Var
    Top1: LongWord absolute Top_Of_Window;
    Bottom1: LongWord absolute Bottom_Of_Window;
 {$ENDIF}
  Begin
   {$IFNDEF OS2}
    Top_Of_Window := Addr( Mem[ Seg( WindMin ):Succ( Ofs( WindMin ) ) ] );
    Left_Of_Window := Addr( WindMin );
    Right_Of_Window := Addr( WindMax );
    Bottom_Of_Window := Addr( Mem[ Seg( WindMax ):Succ( Ofs( WindMax ) ) ] );
   {$ELSE}
    Top_Of_Window := Addr( WindMin );
    Left_Of_Window := Addr( WindMin );
    Right_Of_Window := Addr( WindMax );
    Bottom_Of_Window := Addr( WindMax );
    Inc( Top1 );
    Inc( Bottom1 );
   {$ENDIF}
    Original_Row_Limit := Succ( Bottom_Of_Window^ );
    Get_The_Mode;
   {$IFNDEF VER40}
    Up_Routine := Substitute1;
    Down_Routine := Substitute1;
    Left_Routine := Substitute1;
    Right_Routine := Substitute1;
    Expand_Width_Routine := Substitute1;
    Expand_Height_Routine := Substitute1;
    Reduce_Width_Routine := Substitute1;
    Reduce_Height_Routine := Substitute1;
    Lock_Routine := Procedure_Default;
   {$ENDIF}
   {$IFNDEF OS2}
    AssignCRT( Screen );
    Rewrite( Screen );
   {$ELSE}
    { Assign( Screen, 'CON:' );
    { Assign( Screen, 'CON' ); }
    Screen := Output;
    { Rewrite( Screen ); }
    { Reset( Screen ); }
   {$ENDIF}
  End.

