PROGRAM Timed_Execution_Facility;
{v1.1 Toad Hall Tweak
 - Original TEF10 at SIMTEL20 appeared to be broken: it was missing
   a big chunk of the source.
   Received a shiny new TEF10.PAS source from the author,
   and of course couldn't keep my fingers off it.
 - Very minor tweaks, no functional changes.
 - Standardized source case via CONV_P Pascal conversion utility.

}

{$M 4096,0,0}

Uses Crt,DOS;

CONST
  Off = FALSE;
  On  = TRUE;
  HaltKey = (#45);    { ScanCode for Alt-X }
  HaltStr = 'Alt-X';  { String to display  }

VAR
  TimeToRun,
  ProgramToRun : STRING;
  Ch : CHAR;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{=  Function: CurrentTime                                                  =}
{=  Returns : Time in 24-hour format                                       =}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

FUNCTION CurrentTime : STRING;
VAR
  hour, min, sec, i : INTEGER;
  HStr, MStr, SStr, Temp : STRING[2];
  Regs : Registers;
BEGIN
  WITH Regs DO BEGIN
(*  AH := 44;  AL := 0; *)
    AX := (44 SHL 8) + 0;      {v1.1}
    MsDos(Regs);               { Pull the time }
    hour := CH;  min := CL;        { DL=100ths sec }
    sec := DH;
  END;  { with }
  STR(hour,Hstr);              { Cvt hour to string }
  STR(min,MStr);               { Cvt min to string  }
  STR(sec,SStr);               { Cvt sec to string  }
  IF LENGTH(MStr) = 1 THEN MStr  :=  '0'+MStr;
  IF LENGTH(SStr) = 1 THEN SStr  :=  '0'+SStr;
  CurrentTime := HStr+':'+MStr+':'+SStr;
END;  { CurrentTime }

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{=  Procedure: Cursor                                                      =}
{=  Returns  : Nothing - Turns cursor on/off                               =}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

PROCEDURE Cursor(Status : BOOLEAN);
VAR
  Regs : Registers;
  i    : INTEGER;
BEGIN
  FillChar(Regs,SIZEOF(Regs),0);
  IF (Mem[0000:1040] AND 48) <> 48 THEN i  :=  0  { mono }
  ELSE i  :=  6;               { color }
  Regs.AH  :=  $01;
  IF (Status = On) THEN BEGIN  { Turn ON  }
    Regs.CH := $6+i;
    Regs.CL := $7+i;
  END
  ELSE BEGIN                   { Turn OFF }
(*
    Regs.CH  :=  $20;
    Regs.CL  :=  $20;
*)
    Regs.CX := $2020;          {v1.1}
  END;
  Intr($10,Regs);
END; { Cursor }

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{=  Procedure: Help                                                        =}
{=  Returns  : Nothing - Aborts program with USAGE message                 =}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

PROCEDURE Help;
BEGIN
  WRITELN;
  WRITELN('USAGE: TEF [24-hr time] [command]');
  WRITELN;
  Cursor(On);
  HALT;
END; { Help }

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{=  Procedure: Parse                                                       =}
{=  Returns  : TimeToRun, ProgramToRun                                     =}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

PROCEDURE Parse (VAR Time, Command : STRING);
VAR loop  : INTEGER;
    P1,P2 : STRING;
    FoundTime : BOOLEAN;
BEGIN
  IF (ParamCount <> 2) THEN Help
  ELSE BEGIN
    FoundTime := FALSE;
    P1 := ParamStr(1);  P2 := ParamStr(2);
    FOR loop := 1 TO LENGTH(P1) DO
    IF (P1[loop] = ':') THEN BEGIN
      FoundTime := TRUE;
      Time := P1;  Command := P2;
    END;
    IF NOT FoundTime THEN
      FOR loop := 1 TO LENGTH(P2) DO
        IF (P2[loop] = ':') THEN BEGIN
          FoundTime := TRUE;
          Time := P2;  Command := P1;
        END;
    IF NOT FoundTime THEN Help;
    END;
END; { Parse }

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{=  Procedure: StatusDisplay                                               =}
{=  Returns  : Nothing -- Displays current status of TEF                   =}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

PROCEDURE StatusDisplay;
BEGIN
  ClrScr;
  GotoXY (20,10);  WRITELN('Ŀ');
  GotoXY (20,11);  WRITELN('  TEF: Timed Execution Facility  ');
  GotoXY (20,12);  WRITELN('͵');
  GotoXY (20,13);  WRITELN('                                 ');
  GotoXY (20,14);  WRITELN('    Current Time:                ');
  GotoXY (20,15);  WRITELN('    Time To Run :                ');
  GotoXY (20,16);  WRITELN('    Program     :                ');
  GotoXY (20,17);  WRITELN('                                 ');
  GotoXY (20,18);  WRITELN('');
  GotoXY (20,19);  WRITELN('         ',HaltStr,' : Quit      ');
  GotoXY (20,20);  WRITELN('                ');
  GotoXY (39,15);  WRITELN(TimeToRun);
  GotoXY (39,16);  WRITELN(ProgramToRun);
END;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{=  Main Program                                                           =}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

BEGIN
  CheckBreak := FALSE;  Cursor(Off);
  Parse(TimeToRun,ProgramToRun);
  StatusDisplay;
  WHILE (TimeToRun > COPY(CurrentTime,1,5)) DO BEGIN
    IF KeyPressed THEN BEGIN
      Ch := ReadKey;
      IF Ch = #0 THEN BEGIN
        Ch := ReadKey;
        IF Ch = HaltKey THEN BEGIN
          Cursor(On);  ClrScr;  HALT;  END;
      END;
    END;
    GotoXY(39,14);  WRITELN(CurrentTime);
    Delay(1000);
  END;
  ClrScr;  Exec  (GetEnv('COMSPEC'),'/c '+ProgramToRun);
  Cursor(On);
END.
