UNIT BaseTypes ;




{**********************************************************************
 *                                                                    *
 *  PROGRAM :  BaseTypes               PC FILE NAME :  BASETYPE.PAS   *
 *  ----------------------------------------------------------------  *
 *  LIBRARY MODULES USED :  DOS CRT                                   *
 *  Objects  :  TP6.0 TPU SOURCE: OBJECTS .PAS  BINARY:  OBJECTS .TPU *
 *  ----------------------------------------------------------------  *
 *  PURPOSE :  The purpose of this UNIT is to provide Base objects    *
 *             to construct polymophic objects from.                  *
 *  ----------------------------------------------------------------  *
 *  AUTHOR   :  Thomas E. Jenkins, Jr.                                *
 *              PROGRAMMER, UNIVERSITY OF SOUTH CAROLINA, USA         *
 *  BITNET   :  C0361@UNIVSCVM.BITNET                                 *
 *  INTERNET :  C0361@univscvm.csd.scarolina.EDU                      *
 *              tomj@csdserver3.csd.scarolina.EDU                     *
 *  ----------------------------------------------------------------  *
 *  DISCAIMER :  This program has been tested to the best of my       *
 *               abilities.  The author claims no responsibility      *
 *               for the performance or side effects this program     *
 *               may yield.                                           *
 *  ----------------------------------------------------------------  *
 *  DISTIBUTION :  This program is given freely to the PD realms.     *
 *                 It may freely be copied and distributed.  Any      *
 *                 one wishing to use some or whole parts of this     *
 *                 program for commercial use please contact the      *
 *                 author first.                                      *
 *                                                                    *
 **********************************************************************}




                                  INTERFACE






             {


                 Here is a basic view of the Base object tree:

                 TObject                    [ to allow use with streams   ]
                    |
                    |
                    \___ TBaseOBJ           [ basic functions of structs  ]
                             |              [ & elements                  ]
                             |
                             \___ TElementOBJ    [ basic functionality of ]
                                                 [ any element            ]

             }


USES
       Objects ;                         {  For the base TYPE TObject  }




TYPE

       PBaseOBJ                        = ^TBaseOBJ ;
       TBaseOBJ                        = OBJECT ( TObject )

         DESTRUCTOR  Done ;              {  Ensure all derived objects  }
           VIRTUAL ;                     {  WILL have a Done method     }

         END ;  {  TBaseOBJ  }



       PElementOBJ                     = ^TElementOBJ ;
       TElementOBJ                     = OBJECT ( TBaseOBJ )

         last                          : PElementOBJ ;
         next                          : PElementOBJ ;

         CONSTRUCTOR Init ;

         FUNCTION    TheType           : WORD ;
           VIRTUAL ;

         PROCEDURE   Display ;           {  Mainly included for testing }
           VIRTUAL ;

         FUNCTION    GetData           : POINTER ;
           VIRTUAL ;

         PROCEDURE   SetData (     d   : POINTER ) ;
           VIRTUAL ;

         END ;  {  TElementOBJ  }




                                IMPLEMENTATION




 DESTRUCTOR  TBaseOBJ.Done ;

   BEGIN  {  TBaseOBJ.Done  }
     END ;  {  TBaseOBJ.Done  }




 CONSTRUCTOR TElementOBJ.Init ;

   BEGIN  {  TElementOBJ.Init  }

     last := NIL ;
     next := NIL ;

     END ;  {  TElementOBJ.Init  }




 FUNCTION    TElementOBJ.TheType       : WORD ;

   BEGIN  {  TBaseOBJ.TheType  }

     TheType := 0 ;                         {  0 = abstract type.     }

     END ;  {  TBaseOBJ.TheType  }




 PROCEDURE   TElementOBJ.Display ;

   BEGIN  {  TBaseOBJ.Display  }

     Halt ( 12 ) ;                          {  ABSTRACT call Halt if  }
                                            {  Not re-defined !!      }
     END ;  {  TBaseOBJ.Display  }




 FUNCTION    TElementOBJ.GetData       : POINTER ;

   BEGIN  {  TBaseOBJ.GetData  }

     Halt ( 12 ) ;                          {  ABSTRACT call Halt if  }
                                            {  Not re-defined !!      }
     END ;  {  TBaseOBJ.GetData  }




 PROCEDURE   TElementOBJ.SetData (     d : POINTER ) ;

   BEGIN  {  TBaseOBJ.SetData  }

     Halt ( 12 ) ;                          {  ABSTRACT call Halt if  }
                                            {  Not re-defined !!      }
     END ;  {  TBaseOBJ.SetData  }




END .