UNIT QueueOBJ ;




{**********************************************************************
 *                                                                    *
 *  PROGRAM :  QueueOBJ                PC FILE NAME :  QueueOBJ.PAS   *
 *  ----------------------------------------------------------------  *
 *  LIBRARY MODULES USED :  DOS CRT                                   *
 *  BaseType :  TP6.0 TPU SOURCE: BASETYPE.PAS  BINARY:  BASETPYE.TPU *
 *  ----------------------------------------------------------------  *
 *  PURPOSE :  The purpose of this UNIT is to provide a Queue object  *
 *             that uses a common base and base element object.       *
 *  ----------------------------------------------------------------  *
 *  AUTHOR   :  Thomas E. Jenkins, Jr.                                *
 *              PROGRAMMER, UNIVERSITY OF SOUTH CAROLINA, USA         *
 *  BITNET   :  C0361@UNIVSCVM.BITNET                                 *
 *  INTERNET :  C0361@univscvm.csd.scarolina.EDU                      *
 *              tomj@csdserver3.csd.scarolina.EDU                     *
 *  ----------------------------------------------------------------  *
 *  DISCAIMER :  This program has been tested to the best of my       *
 *               abilities.  The author claims no responsibility      *
 *               for the performance or side effects this program     *
 *               may yield.                                           *
 *  ----------------------------------------------------------------  *
 *  DISTIBUTION :  This program is given freely to the PD realms.     *
 *                 It may freely be copied and distributed.  Any      *
 *                 one wishing to use some or whole parts of this     *
 *                 program for commercial use please contact the      *
 *                 author first.                                      *
 *                                                                    *
 **********************************************************************}




                                  INTERFACE






             {


                 Here is a basic view of the Queue object tree:

                 TObject                    [ to allow use with streams   ]
                    |
                    |
                    \___ TBaseOBJ           [ basic functions of Queue &  ]
                             |              [ elements                    ]
                             |
                             \___ TElementOBJ    [ basic functionality of ]
                             /         |         [ any element            ]
                             |         |
                             |         \___ TStrOBJ [ string specific     ]
                             |         /            [ functions & storage ]
                             |         |
                             |         |
                             |         \___ TIntOBJ [ integer specific    ]
                             |         /            [ functions & storage ]
                             |         |
                             |         |
                             |         \___ TRealOBJ [ real specific      ]
                             |                       [ functions & storage]
                             |
                             \___ TQueueOBJ      [ Queue specific         ]
                                                 [ functions & storage    ]

             }


USES
       BaseTypes ;



TYPE

       PQueueOBJ                       = ^TQueueOBJ ;
       TQueueOBJ                       = OBJECT ( TBaseOBJ )

         head                          : PElementOBJ ;
         tail                          : PElementOBJ ;

         CONSTRUCTOR Init ;

         PROCEDURE   Add (     item    : PElementOBJ ) ;
           VIRTUAL ;

         FUNCTION    Get               : PElementOBJ ;
           VIRTUAL ;

         FUNCTION    Empty             : BOOLEAN ;
           VIRTUAL ;

         DESTRUCTOR  Done ;
           VIRTUAL ;

         END ;  {  TQueueOBJ  }




                                IMPLEMENTATION




 CONSTRUCTOR TQueueOBJ.Init ;

   BEGIN  {  TQueueOBJ.Init  }

     head := NIL ;
     tail := NIL ;

     END ;  {  TQueueOBJ.Init  }




 PROCEDURE   TQueueOBJ.Add (     item  : PElementOBJ ) ;

  BEGIN  {  TQueueOBJ.Add  }

    IF ( head = NIL )
     THEN
      BEGIN

        head := item ;
        tail := item ;

        Exit ;

        END ;  {  THEN  }

    tail^.last := item ;

    tail := item ;

    END ;  {  TQueueOBJ.Add  }




 FUNCTION    TQueueOBJ.Get                       : PElementOBJ ;

  BEGIN  {  TQueueOBJ.Get  }

    Get := head ;

    IF ( Empty )
     THEN
        Exit ;

    head := head^.last ;

    IF ( head = NIL )
     THEN
        tail := head ;

    END ;  {  TQueueOBJ.Get  }




 FUNCTION    TQueueOBJ.Empty                     : BOOLEAN ;

  BEGIN  {  TQueueOBJ.Empty  }

    Empty := ( head = NIL ) ;

    END ;  {  TQueueOBJ.Empty  }




 DESTRUCTOR  TQueueOBJ.Done ;

   BEGIN  {  TQueueOBJ.Done  }

     WHILE ( head <> NIL )
      DO
       BEGIN

         Dispose ( Get , Done ) ;

         END ;  {  WHILE  }

     tail := head ;

     END ;  {  TQueueOBJ.Done  }




END .