{$M 16000, 0, 32000}

program example;

{****************************************************************************
 *                                                                          *
 *  This is a very basic program that will show you a few of the VERY many  *
 *  functions available to the programmer using the TriDoor package.        *
 *                                                                          *
 *  To most effectively use and understand the unit, you should invest the  *
 *  time to read the manual included in the release and then experiment     *
 *  with the unit in your own programs.                                     *
 *                                                                          *
 ****************************************************************************}

uses
  crt,
  tridr60t;            { The TriDoor unit must come after the CRT unit. }

{* * * * * * * *}

procedure example_td_readln;

{* This procedure will show some of the td_readln() function capabilities
   and features.                                                          *}

var
  tempin : string;   {* input string used for this procedure *}

begin {* example_td_readln *}

  td_clrscr;

  td_writeln('This is an example of some of TriDoor''s input features.  All these||');
  td_writeln('capabilities are built in and very easy to use.||');
  td_writeln('-------------------------------------------------------------------||||');
  
  td_writeln('  This is an example of standard input -||');
  td_writeln('  What do you think of TriDoor?||');
  td_writeln('  -> ');
  td_readln( tempin, 80, CAPS_OFF, CODE_OFF );
  td_writeln('||||||');

  td_writeln('  This is an example of limited input -||');
  td_writeln('  Enter your name (10 Characters Max) : ');
  td_readln( tempin, 10, CAPS_OFF, CODE_OFF );
  td_writeln('||||||');

  td_writeln('  This is an example of coded and limited input -||');
  td_writeln('  Enter your password (12 Characters Max ) : ');
  td_readln( tempin, 12, CAPS_OFF, CODE_ON );
  td_writeln('  You entered the password : '+tempin+'.||||||');

  td_writeln('  This is an example of limited and upper-cased input -||');
  td_writeln('                                   [------------]||');
  td_writeln('  Enter name of file to download :  ');
  td_readln( tempin, 12, CAPS_ON, CODE_OFF );
  td_writeln('||||||');

  td_writeln('Press any key to continue : ');
  tempin[1] := get_keypress;

end;  {* example_td_readln *}

{* * * * * * * *}

procedure example_ANSI;

{* This is an example of some ANSI screen controls that are built right
   into the TriDoor program.  These screen controls were used to make
   TriUser- a QuickBBS On-Line ANSI Utilizing User Editor.               *}

var
  tempin : string;   {* input string used for this procedure *}

begin {* example_ANSI *}

  td_clrscr;

  ansi_color( BLINK_OFF, INTENSITY_ON, BLUE, BLACK );
  td_writeln('This ');
  ansi_color( BLINK_OFF, INTENSITY_ON, YELLOW, BLACK );
  td_writeln('is ');
  ansi_color( BLINK_OFF, INTENSITY_ON, GREEN, BLACK );
  td_writeln('an ');
  ansi_color( BLINK_OFF, INTENSITY_ON, MAGENTA, BLACK );
  td_writeln('example ');
  ansi_color( BLINK_OFF, INTENSITY_OFF, CYAN, BLACK );
  td_writeln('of ');
  ansi_color( BLINK_OFF, INTENSITY_OFF, RED, BLACK );
  td_writeln('ANSI');
  ansi_color( BLINK_ON, INTENSITY_ON, CYAN, BLACK );
  td_writeln('!');

  ansi_gotoxy(10,10);
  ansi_color( BLINK_ON, INTENSITY_ON, CYAN, BLUE );
  td_writeln(' ** ANSI CONTROLS CAN BE FUN!!! ** ');

  ansi_gotoxy(1,20);
  ansi_color( BLINK_OFF, INTENSITY_OFF, WHITE, BLACK );
  td_writeln('Press any key to continue : ');
  tempin[1] := get_keypress;

end;  {* example_ANSI *}

{* * * * * * * *}

procedure wrapup;

{* This is simply an ending procedure to the program. *}

begin {* wrapup *}

  td_clrscr;

  td_writeln('||||');
  td_writeln('      Well, that is about all  there is for  THIS particular  program BUT||');
  td_writeln('    as I pointed out earlier, the  possibilities are many  and due to the||');
  td_writeln('    very loose interface structure of the unit the limits are few.||||');
  
  td_writeln('      If you have ANY questions  or problems, please feel free to contact||');
  td_writeln('    us at our numbers and internet addresses listed in the documentation.||');

  td_writeln('      We hope you find  TriDoor as useful, pliable and easy to use  as we||');
  td_writeln('    have.  Good luck and happy programming!||||||');

end;  {* wrapup *}

{* * * * * * * *}

begin {* main procedure *}

  clrscr;

  if ( read_dorinfo ) then      {* if DORINFO1.DEF exists (and was read)... *}
    begin

      if ( setup_tridoor ) then
        begin

          example_td_readln;
          example_ANSI;
          wrapup;

        end
      else writeln('Error : TriDoor was inable to set-up COMM port.',chr(7));

    end
  else writeln('Error : File DORINFO1.DEF not found.',chr(7));


end.  {* main procedure *}