{
dosmcb.pas
Stealth Bomber Version 2.2

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114

February 10, 1992

	This module handles the DOS memory control block interface.

	This code is public domain.
}


unit DOSMCB;


interface


uses
  DOS;


type
  MCB =
    record
    ID : byte;		{ MCB ID ($4D for all but last which is $5A). }
    PSP : word;		{ PSP of the program that owns the block. }
    Size : word;	{ Size of allocated memory in paragraphs. }
    end;
  MCBPtr =
    ^MCB;


function GetMCB : MCBPtr;
function NextMCB(ThisMCB : MCBPtr) : MCBPtr;
function MCBOwner(Ptr : pointer) : MCBPtr;


implementation


type
  WordPtr =
    ^word;


{***}
{ Get the first DOS memory control block. }
function GetMCB : MCBPtr;

var
  Regs : Registers;

begin
{ DOS function $52 gets the DOS list of lists. }
Regs.AH := $52;
MSDos(Regs);

{ The first MCB pointer is two bytes behind the list of lists. }
GetMCB := Ptr(WordPtr(Ptr(Regs.ES, Regs.BX - 2))^, 0);
end;


{***}
{ Get the next DOS memory control block. }
function NextMCB(ThisMCB : MCBPtr) : MCBPtr;

begin
if ThisMCB^.ID = $5A then
  NextMCB := nil
else
  { Next MCB is Size + 1 paragraphs away. }
  NextMCB := Ptr(Seg(ThisMCB^) + ThisMCB^.Size + 1, 0);
end;


{***}
{ Determine the owner of a particular pointer. }
function MCBOwner(Ptr : pointer) : MCBPtr;

var
  PSeg : word;
  MCB : MCBPtr;

begin
{ Determine true segment. }
PSeg := Seg(Ptr^) + Ofs(Ptr^) shr 4;

MCB := GetMCB;

{ Pointer is invalid if below DOS memory. }
if PSeg < Seg(MCB^) then
  MCB := nil;

{ Find pointer's MCB if it exists. }
while (MCB <> nil) and (PSeg > Seg(MCB^) + MCB^.Size) do
  MCB := NextMCB(MCB);

{ Pointer cannot point within MCB itself. }
if PSeg = Seg(MCB^) then
  MCB := nil;

MCBOwner := MCB;
end;


end.
